/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XYZApp
extends Applet
implements Runnable,
MouseListener,
MouseMotionListener {
    XYZChemModel md;
    boolean painted = true;
    float xfac;
    int prevx;
    int prevy;
    float scalefudge = 1.0f;
    Matrix3D amat = new Matrix3D();
    Matrix3D tmat = new Matrix3D();
    String mdname = null;
    String message = null;
    Image backBuffer;
    Graphics backGC;
    Dimension backSize;

    private synchronized void newBackBuffer() {
        this.backBuffer = this.createImage(this.getSize().width, this.getSize().height);
        if (this.backGC != null) {
            this.backGC.dispose();
        }
        this.backGC = this.backBuffer.getGraphics();
        this.backSize = this.getSize();
    }

    @Override
    public void init() {
        this.mdname = this.getParameter("model");
        try {
            this.scalefudge = Float.valueOf(this.getParameter("scale")).floatValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.amat.yrot(20.0);
        this.amat.xrot(20.0);
        if (this.mdname == null) {
            this.mdname = "model.obj";
        }
        this.resize(this.getSize().width <= 20 ? 400 : this.getSize().width, this.getSize().height <= 20 ? 400 : this.getSize().height);
        this.newBackBuffer();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void destroy() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    @Override
    public void run() {
        InputStream inputStream = null;
        try {
            float f;
            float f2;
            Thread.currentThread().setPriority(1);
            inputStream = this.getClass().getResourceAsStream(this.mdname);
            XYZChemModel xYZChemModel = new XYZChemModel(inputStream);
            Atom.setApplet(this);
            this.md = xYZChemModel;
            xYZChemModel.findBB();
            float f3 = xYZChemModel.xmax - xYZChemModel.xmin;
            float f4 = xYZChemModel.ymax - xYZChemModel.ymin;
            float f5 = xYZChemModel.zmax - xYZChemModel.zmin;
            if (f4 > f3) {
                f3 = f4;
            }
            if (f5 > f3) {
                f3 = f5;
            }
            this.xfac = 0.7f * ((f2 = (float)this.getSize().width / f3) < (f = (float)this.getSize().height / f3) ? f2 : f) * this.scalefudge;
        }
        catch (Exception exception) {
            Logger.getLogger(XYZApp.class.getName()).log(Level.SEVERE, null, exception);
            this.md = null;
            this.message = exception.toString();
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
    }

    @Override
    public void start() {
        if (this.md == null && this.message == null) {
            new Thread(this).start();
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.prevx = mouseEvent.getX();
        this.prevy = mouseEvent.getY();
        mouseEvent.consume();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.tmat.unit();
        float f = (float)(this.prevy - n2) * (360.0f / (float)this.getSize().width);
        float f2 = (float)(n - this.prevx) * (360.0f / (float)this.getSize().height);
        this.tmat.xrot(f);
        this.tmat.yrot(f2);
        this.amat.mult(this.tmat);
        if (this.painted) {
            this.painted = false;
            this.repaint();
        }
        this.prevx = n;
        this.prevy = n2;
        mouseEvent.consume();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void update(Graphics graphics) {
        if (this.backBuffer == null) {
            graphics.clearRect(0, 0, this.getSize().width, this.getSize().height);
        }
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.md != null) {
            this.md.mat.unit();
            this.md.mat.translate(-(this.md.xmin + this.md.xmax) / 2.0f, -(this.md.ymin + this.md.ymax) / 2.0f, -(this.md.zmin + this.md.zmax) / 2.0f);
            this.md.mat.mult(this.amat);
            this.md.mat.scale(this.xfac, -this.xfac, 16.0f * this.xfac / (float)this.getSize().width);
            this.md.mat.translate(this.getSize().width / 2, this.getSize().height / 2, 8.0f);
            this.md.transformed = false;
            if (this.backBuffer != null) {
                if (!this.backSize.equals(this.getSize())) {
                    this.newBackBuffer();
                }
                this.backGC.setColor(this.getBackground());
                this.backGC.fillRect(0, 0, this.getSize().width, this.getSize().height);
                this.md.paint(this.backGC);
                graphics.drawImage(this.backBuffer, 0, 0, this);
            } else {
                this.md.paint(graphics);
            }
            this.setPainted();
        } else if (this.message != null) {
            graphics.drawString("Error in model:", 3, 20);
            graphics.drawString(this.message, 10, 40);
        }
    }

    private synchronized void setPainted() {
        this.painted = true;
        this.notifyAll();
    }

    @Override
    public String getAppletInfo() {
        return "Title: XYZApp \nAuthor: James Gosling \nAn applet to put a Chemical model into a page.";
    }

    @Override
    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"model", "path string", "The path to the model to be displayed in .xyz format (see http://chem.leeds.ac.uk/Project/MIME.html).  Default is model.obj."}, {"scale", "float", "Scale factor.  Default is 1 (i.e. no scale)."}};
        return stringArray;
    }
}

