/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.jdi.JVMTIThreadState;
import sun.jvm.hotspot.jdi.MonitorInfoImpl;
import sun.jvm.hotspot.jdi.ObjectReferenceImpl;
import sun.jvm.hotspot.jdi.StackFrameImpl;
import sun.jvm.hotspot.oops.Instance;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopUtilities;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.JavaThreadState;
import sun.jvm.hotspot.runtime.JavaVFrame;
import sun.jvm.hotspot.runtime.MonitorInfo;
import sun.jvm.hotspot.runtime.OSThread;
import sun.jvm.hotspot.runtime.ObjectMonitor;
import sun.jvm.hotspot.utilities.Assert;

public class ThreadReferenceImpl
extends ObjectReferenceImpl
implements ThreadReference,
JVMTIThreadState {
    private JavaThread myJavaThread;
    private ArrayList frames;
    private List ownedMonitors;
    private List ownedMonitorsInfo;
    private ObjectReferenceImpl currentContendingMonitor;

    ThreadReferenceImpl(VirtualMachine aVm, JavaThread aRef) {
        super(aVm, (Instance)aRef.getThreadObj());
        this.myJavaThread = aRef;
    }

    ThreadReferenceImpl(VirtualMachine vm, Instance oRef) {
        super(vm, oRef);
        this.myJavaThread = OopUtilities.threadOopGetJavaThread(oRef);
    }

    JavaThread getJavaThread() {
        return this.myJavaThread;
    }

    protected String description() {
        return "ThreadReference " + this.uniqueID();
    }

    @Override
    public String name() {
        return OopUtilities.threadOopGetName(this.ref());
    }

    @Override
    public void suspend() {
        this.vm.throwNotReadOnlyException("ThreadReference.suspend()");
    }

    @Override
    public void resume() {
        this.vm.throwNotReadOnlyException("ThreadReference.resume()");
    }

    @Override
    public int suspendCount() {
        return 1;
    }

    @Override
    public void stop(ObjectReference throwable) throws InvalidTypeException {
        this.vm.throwNotReadOnlyException("ThreadReference.stop()");
    }

    @Override
    public void interrupt() {
        this.vm.throwNotReadOnlyException("ThreadReference.interrupt()");
    }

    private int jvmtiGetThreadState() {
        int state = OopUtilities.threadOopGetThreadStatus(this.ref());
        if (this.myJavaThread != null) {
            OSThread osThread;
            JavaThreadState jts = this.myJavaThread.getThreadState();
            if (this.myJavaThread.isBeingExtSuspended()) {
                state |= 0x100000;
            }
            if (jts == JavaThreadState.IN_NATIVE) {
                state |= 0x400000;
            }
            if ((osThread = this.myJavaThread.getOSThread()) != null && osThread.interrupted()) {
                state |= 0x200000;
            }
        }
        return state;
    }

    @Override
    public int status() {
        int state = this.jvmtiGetThreadState();
        int status = -1;
        if ((state & 1) == 0) {
            status = (state & 2) != 0 ? 0 : 5;
        } else if ((state & 0x40) != 0) {
            status = 2;
        } else if ((state & 0x400) != 0) {
            status = 3;
        } else if ((state & 0x80) != 0) {
            status = 4;
        } else if ((state & 4) != 0) {
            status = 1;
        }
        return status;
    }

    @Override
    public boolean isSuspended() {
        return true;
    }

    @Override
    public boolean isAtBreakpoint() {
        return false;
    }

    @Override
    public ThreadGroupReference threadGroup() {
        return this.vm.threadGroupMirror((Instance)OopUtilities.threadOopGetThreadGroup(this.ref()));
    }

    @Override
    public int frameCount() throws IncompatibleThreadStateException {
        this.privateFrames(0, -1);
        return this.frames.size();
    }

    public List frames() throws IncompatibleThreadStateException {
        return this.privateFrames(0, -1);
    }

    @Override
    public StackFrame frame(int index) throws IncompatibleThreadStateException {
        List list = this.privateFrames(index, 1);
        return (StackFrame)list.get(0);
    }

    public List frames(int start, int length) throws IncompatibleThreadStateException {
        if (length < 0) {
            throw new IndexOutOfBoundsException("length must be greater than or equal to zero");
        }
        return this.privateFrames(start, length);
    }

    private List privateFrames(int start, int length) throws IncompatibleThreadStateException {
        List retVal;
        if (this.myJavaThread == null) {
            throw new IncompatibleThreadStateException();
        }
        if (this.frames == null) {
            this.frames = new ArrayList(10);
            for (JavaVFrame myvf = this.myJavaThread.getLastJavaVFrameDbg(); myvf != null; myvf = myvf.javaSender()) {
                StackFrameImpl myFrame = new StackFrameImpl(this.vm, this, myvf);
                this.frames.add(myFrame);
            }
        }
        if (this.frames.size() == 0) {
            retVal = new ArrayList(0);
        } else {
            int toIndex = start + length;
            if (length == -1) {
                toIndex = this.frames.size();
            }
            retVal = this.frames.subList(start, toIndex);
        }
        return Collections.unmodifiableList(retVal);
    }

    public List ownedMonitors() throws IncompatibleThreadStateException {
        if (!this.vm.canGetOwnedMonitorInfo()) {
            throw new UnsupportedOperationException();
        }
        if (this.myJavaThread == null) {
            throw new IncompatibleThreadStateException();
        }
        if (this.ownedMonitors != null) {
            return this.ownedMonitors;
        }
        this.ownedMonitorsWithStackDepth();
        Iterator omi = this.ownedMonitorsInfo.iterator();
        while (omi.hasNext()) {
            this.ownedMonitors.add(((MonitorInfoImpl)omi.next()).monitor());
        }
        return this.ownedMonitors;
    }

    public List ownedMonitorsAndFrames() throws IncompatibleThreadStateException {
        if (!this.vm.canGetMonitorFrameInfo()) {
            throw new UnsupportedOperationException("target does not support getting Monitor Frame Info");
        }
        if (this.myJavaThread == null) {
            throw new IncompatibleThreadStateException();
        }
        if (this.ownedMonitorsInfo != null) {
            return this.ownedMonitorsInfo;
        }
        this.ownedMonitorsWithStackDepth();
        return this.ownedMonitorsInfo;
    }

    private void ownedMonitorsWithStackDepth() {
        Object obj;
        this.ownedMonitorsInfo = new ArrayList();
        ArrayList<Object> lockedObjects = new ArrayList<Object>();
        ArrayList<Integer> stackDepth = new ArrayList<Integer>();
        ObjectMonitor waitingMonitor = this.myJavaThread.getCurrentWaitingMonitor();
        ObjectMonitor pendingMonitor = this.myJavaThread.getCurrentPendingMonitor();
        OopHandle waitingObj = null;
        if (waitingMonitor != null) {
            waitingObj = waitingMonitor.object();
        }
        OopHandle pendingObj = null;
        if (pendingMonitor != null) {
            pendingObj = pendingMonitor.object();
        }
        JavaVFrame frame = this.myJavaThread.getLastJavaVFrameDbg();
        int depth = 0;
        while (frame != null) {
            List frameMonitors = frame.getMonitors();
            for (MonitorInfo mi : frameMonitors) {
                if (mi.eliminated() && frame.isCompiledFrame() || (obj = mi.owner()) == null || obj.equals(waitingObj) || obj.equals(pendingObj)) continue;
                boolean found = false;
                Iterator loItr = lockedObjects.iterator();
                while (loItr.hasNext()) {
                    if (!obj.equals(loItr.next())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                lockedObjects.add(obj);
                stackDepth.add(new Integer(depth));
            }
            frame = frame.javaSender();
            ++depth;
        }
        ObjectHeap heap = this.vm.saObjectHeap();
        Iterator stk = stackDepth.iterator();
        Iterator loItr = lockedObjects.iterator();
        while (loItr.hasNext()) {
            obj = heap.newOop((OopHandle)loItr.next());
            this.ownedMonitorsInfo.add(new MonitorInfoImpl(this.vm, this.vm.objectMirror((Oop)obj), this, (Integer)stk.next()));
        }
    }

    @Override
    public ObjectReference currentContendedMonitor() throws IncompatibleThreadStateException {
        if (!this.vm.canGetCurrentContendedMonitor()) {
            throw new UnsupportedOperationException();
        }
        if (this.myJavaThread == null) {
            throw new IncompatibleThreadStateException();
        }
        ObjectMonitor mon = this.myJavaThread.getCurrentWaitingMonitor();
        if (mon == null) {
            mon = this.myJavaThread.getCurrentPendingMonitor();
            if (mon != null) {
                OopHandle handle = mon.object();
                return this.vm.objectMirror(this.vm.saObjectHeap().newOop(handle));
            }
            return null;
        }
        OopHandle handle = mon.object();
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(handle != null, "Object.wait() should have an object");
        }
        Oop obj = this.vm.saObjectHeap().newOop(handle);
        return this.vm.objectMirror(obj);
    }

    @Override
    public void popFrames(StackFrame frame) throws IncompatibleThreadStateException {
        this.vm.throwNotReadOnlyException("ThreadReference.popFrames()");
    }

    @Override
    public void forceEarlyReturn(Value returnValue) throws IncompatibleThreadStateException {
        this.vm.throwNotReadOnlyException("ThreadReference.forceEarlyReturn()");
    }

    @Override
    public String toString() {
        return "instance of " + this.referenceType().name() + "(name='" + this.name() + "', id=" + this.uniqueID() + ")";
    }
}

