/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.BytecodeGetPut;
import sun.jvm.hotspot.interpreter.BytecodeStream;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.utilities.Assert;

public class BytecodePutField
extends BytecodeGetPut {
    BytecodePutField(Method method, int bci) {
        super(method, bci);
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    public void verify() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isValid(), "check putfield");
        }
    }

    public boolean isValid() {
        return this.javaCode() == 181;
    }

    public static BytecodePutField at(Method method, int bci) {
        BytecodePutField b = new BytecodePutField(method, bci);
        if (Assert.ASSERTS_ENABLED) {
            b.verify();
        }
        return b;
    }

    public static BytecodePutField atCheck(Method method, int bci) {
        BytecodePutField b = new BytecodePutField(method, bci);
        return b.isValid() ? b : null;
    }

    public static BytecodePutField at(BytecodeStream bcs) {
        return new BytecodePutField(bcs.method(), bcs.bci());
    }
}

