/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.proc;

import java.io.File;
import java.util.List;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.cdbg.CDebugger;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.debugger.cdbg.LoadObject;
import sun.jvm.hotspot.debugger.cdbg.ProcessControl;
import sun.jvm.hotspot.debugger.proc.ProcDebugger;

class ProcCDebugger
implements CDebugger {
    private ProcDebugger dbg;

    ProcCDebugger(ProcDebugger dbg) {
        this.dbg = dbg;
    }

    @Override
    public List getThreadList() throws DebuggerException {
        return this.dbg.getThreadList();
    }

    @Override
    public List getLoadObjectList() throws DebuggerException {
        return this.dbg.getLoadObjectList();
    }

    @Override
    public LoadObject loadObjectContainingPC(Address pc) throws DebuggerException {
        if (pc == null) {
            return null;
        }
        List objs = this.getLoadObjectList();
        Object[] arr = objs.toArray();
        int mid = -1;
        int low = 0;
        int high = arr.length - 1;
        while (low <= high) {
            mid = low + high >> 1;
            LoadObject midVal = (LoadObject)arr[mid];
            long cmp = pc.minus(midVal.getBase());
            if (cmp < 0L) {
                high = mid - 1;
                continue;
            }
            if (cmp > 0L) {
                long size = midVal.getSize();
                if (cmp >= size) {
                    low = mid + 1;
                    continue;
                }
                return (LoadObject)arr[mid];
            }
            return (LoadObject)arr[mid];
        }
        return null;
    }

    @Override
    public CFrame topFrameForThread(ThreadProxy thread) throws DebuggerException {
        return this.dbg.topFrameForThread(thread);
    }

    @Override
    public String getNameOfFile(String fileName) {
        return new File(fileName).getName();
    }

    @Override
    public ProcessControl getProcessControl() throws DebuggerException {
        return null;
    }

    @Override
    public boolean canDemangle() {
        return true;
    }

    @Override
    public String demangle(String sym) {
        return this.dbg.demangle(sym);
    }
}

