/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataCacheEntry;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.DefaultResolvedModuleVersion;
import org.gradle.internal.component.external.model.ModuleComponentGraphResolveState;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.util.internal.BuildCommencedTimeProvider;

class DefaultCachedMetadata
implements ModuleMetadataCache.CachedMetadata {
    private final long ageMillis;
    private final ModuleComponentResolveMetadata metadata;
    private volatile Map<Integer, ModuleComponentGraphResolveState> processedMetadataByRules;

    DefaultCachedMetadata(ModuleMetadataCacheEntry entry, ModuleComponentResolveMetadata metadata, BuildCommencedTimeProvider timeProvider) {
        this(timeProvider.getCurrentTime() - entry.createTimestamp, metadata);
    }

    private DefaultCachedMetadata(long age, ModuleComponentResolveMetadata metadata) {
        this.ageMillis = age;
        this.metadata = metadata;
    }

    @Override
    public boolean isMissing() {
        return this.metadata == null;
    }

    @Override
    public ModuleSources getModuleSources() {
        return this.metadata.getSources();
    }

    @Override
    public ResolvedModuleVersion getModuleVersion() {
        return this.isMissing() ? null : new DefaultResolvedModuleVersion(this.getMetadata().getModuleVersionId());
    }

    @Override
    public ModuleComponentResolveMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public Duration getAge() {
        return Duration.ofMillis(this.ageMillis);
    }

    @Override
    @Nullable
    public ModuleComponentGraphResolveState getProcessedMetadata(int key) {
        if (this.processedMetadataByRules != null) {
            return this.processedMetadataByRules.get(key);
        }
        return null;
    }

    @Override
    public synchronized void putProcessedMetadata(int hash, ModuleComponentGraphResolveState processed) {
        if (this.processedMetadataByRules == null) {
            this.processedMetadataByRules = Collections.singletonMap(hash, processed);
            return;
        }
        if (this.processedMetadataByRules.size() == 1) {
            this.processedMetadataByRules = new ConcurrentHashMap<Integer, ModuleComponentGraphResolveState>(this.processedMetadataByRules);
        }
        this.processedMetadataByRules.put(hash, processed);
    }

    @Override
    public ModuleMetadataCache.CachedMetadata dehydrate() {
        if (this.metadata == null) {
            return this;
        }
        MutableModuleComponentResolveMetadata copy = this.metadata.asMutable();
        ModuleComponentResolveMetadata asImmutable = copy.asImmutable();
        return new DefaultCachedMetadata(this.ageMillis, asImmutable);
    }
}

