/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.Closeable;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.GlobalCache;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.GeneratedGradleJarCache;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.cache.scopes.GlobalScopedCacheBuilderFactory;

public class DefaultGeneratedGradleJarCache
implements GeneratedGradleJarCache,
Closeable,
GlobalCache {
    private final PersistentCache cache;
    private final String gradleVersion;

    public DefaultGeneratedGradleJarCache(GlobalScopedCacheBuilderFactory cacheBuilderFactory, String gradleVersion) {
        this.cache = cacheBuilderFactory.createCacheBuilder("generated-gradle-jars").withDisplayName("Generated Gradle JARs cache").withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.OnDemand)).open();
        this.gradleVersion = gradleVersion;
    }

    public File get(String identifier, final Action<File> creator) {
        final File jarFile = this.jarFile(identifier);
        this.cache.useCache(new Runnable(){

            @Override
            public void run() {
                if (!jarFile.exists()) {
                    creator.execute((Object)jarFile);
                }
            }
        });
        return jarFile;
    }

    @Override
    public void close() {
        this.cache.close();
    }

    private File jarFile(String identifier) {
        return new File(this.cache.getBaseDir(), "gradle-" + identifier + "-" + this.gradleVersion + ".jar");
    }

    public List<File> getGlobalCacheRoots() {
        return Collections.singletonList(this.cache.getBaseDir());
    }
}

