/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.slf4j;

import org.gradle.api.logging.LogLevel;
import org.gradle.internal.logging.events.LogEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.slf4j.BuildOperationAwareLogger;
import org.gradle.internal.logging.slf4j.OutputEventListenerBackedLoggerContext;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.time.Clock;

public class OutputEventListenerBackedLogger
extends BuildOperationAwareLogger {
    private final String name;
    private final OutputEventListenerBackedLoggerContext context;
    private final Clock clock;

    public OutputEventListenerBackedLogger(String name, OutputEventListenerBackedLoggerContext context, Clock clock) {
        this.name = name;
        this.context = context;
        this.clock = clock;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    boolean isLevelAtMost(LogLevel levelLimit) {
        return levelLimit.compareTo((Enum)this.context.getLevel()) >= 0;
    }

    @Override
    void log(LogLevel logLevel, Throwable throwable, String message, OperationIdentifier operationIdentifier) {
        LogEvent logEvent = new LogEvent(this.clock.getCurrentTime(), this.name, logLevel, message, throwable, operationIdentifier);
        OutputEventListener outputEventListener = this.context.getOutputEventListener();
        try {
            outputEventListener.onOutput(logEvent);
        }
        catch (Throwable e) {
            e.printStackTrace(System.out);
        }
    }
}

