/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.DefaultProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ForeignBuildIdentifier;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.internal.Pair;
import org.gradle.internal.build.AbstractBuildState;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.CompositeBuildParticipantBuildState;
import org.gradle.internal.buildtree.BuildTreeState;
import org.gradle.util.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompositeParticipantBuildState
extends AbstractBuildState
implements CompositeBuildParticipantBuildState {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCompositeParticipantBuildState.class);
    private Set<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> availableModules;

    public AbstractCompositeParticipantBuildState(BuildTreeState buildTree, BuildDefinition buildDefinition, @Nullable BuildState parent) {
        super(buildTree, buildDefinition, parent);
    }

    public synchronized Set<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> getAvailableModules() {
        if (this.availableModules == null) {
            this.ensureChildBuildConfigured();
            this.availableModules = new LinkedHashSet<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>>();
            for (ProjectState project : this.getProjects().getAllProjects()) {
                this.registerProject(this.availableModules, project.getMutableModel());
            }
        }
        return this.availableModules;
    }

    protected void ensureChildBuildConfigured() {
        this.ensureProjectsConfigured();
    }

    private void registerProject(Set<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> availableModules, ProjectInternal project) {
        DefaultProjectComponentIdentifier projectIdentifier = new DefaultProjectComponentIdentifier(this.getBuildIdentifier(), project.getIdentityPath(), project.getProjectPath(), project.getName());
        ModuleVersionIdentifier moduleId = DefaultModuleVersionIdentifier.newId((Module)project.getDependencyMetaDataProvider().getModule());
        LOGGER.info("Registering {} in composite build. Will substitute for module '{}'.", (Object)project, (Object)moduleId.getModule());
        availableModules.add((Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>)Pair.of((Object)moduleId, (Object)projectIdentifier));
    }

    public ProjectComponentIdentifier idToReferenceProjectFromAnotherBuild(ProjectComponentIdentifier identifier) {
        DefaultProjectComponentIdentifier original = (DefaultProjectComponentIdentifier)identifier;
        Path foreignBuildPath = Path.path((String)this.getBuildIdentifier().getBuildPath());
        return new DefaultProjectComponentIdentifier((BuildIdentifier)new ForeignBuildIdentifier(foreignBuildPath), original.getIdentityPath(), original.projectPath(), original.getProjectName());
    }
}

