/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.dependencies;

import groovy.lang.Closure;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.reporting.dependencies.DependencyReportContainer;
import org.gradle.api.reporting.dependencies.internal.DefaultDependencyReportContainer;
import org.gradle.api.reporting.dependencies.internal.HtmlDependencyReporter;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.api.tasks.diagnostics.internal.ConfigurationDetails;
import org.gradle.api.tasks.diagnostics.internal.ProjectDetails;
import org.gradle.api.tasks.diagnostics.internal.ProjectsWithConfigurations;
import org.gradle.internal.Cast;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.internal.serialization.Cached;
import org.gradle.internal.serialization.Transient;
import org.gradle.util.internal.ClosureBackedAction;

@UntrackedTask(because="We can't describe the dependency tree of all projects as input")
public abstract class HtmlDependencyReportTask
extends ConventionTask
implements Reporting<DependencyReportContainer> {
    private final Transient.Var<Set<Project>> projects = Transient.varOf((Object)((Set)Cast.uncheckedCast(Collections.singleton(this.getProject()))));
    private final Cached<ProjectsWithConfigurations<ProjectDetails.ProjectNameAndPath, ConfigurationDetails>> projectsWithConfigurations = Cached.of(this::computeProjectsWithConfigurations);
    private final DirectoryProperty reportDir;
    private final DependencyReportContainer reports = (DependencyReportContainer)this.getObjectFactory().newInstance(DefaultDependencyReportContainer.class, new Object[]{this, this.getCallbackActionDecorator()});

    public HtmlDependencyReportTask() {
        this.reportDir = this.getObjectFactory().directoryProperty();
        this.reports.getHtml().getRequired().set((Object)true);
    }

    @Internal
    public DirectoryProperty getProjectReportDirectory() {
        return this.reportDir;
    }

    @Nested
    public DependencyReportContainer getReports() {
        return this.reports;
    }

    public DependencyReportContainer reports(Closure closure) {
        return this.reports((Action)new ClosureBackedAction(closure));
    }

    public DependencyReportContainer reports(Action<? super DependencyReportContainer> configureAction) {
        configureAction.execute((Object)this.reports);
        return this.reports;
    }

    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected VersionSelectorScheme getVersionSelectorScheme() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected VersionComparator getVersionComparator() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected VersionParser getVersionParser() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected CollectionCallbackActionDecorator getCallbackActionDecorator() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void generate() {
        if (!((Boolean)this.reports.getHtml().getRequired().get()).booleanValue()) {
            this.setDidWork(false);
            return;
        }
        HtmlDependencyReporter reporter = new HtmlDependencyReporter(this.getVersionSelectorScheme(), this.getVersionComparator(), this.getVersionParser());
        reporter.render((ProjectsWithConfigurations)this.projectsWithConfigurations.get(), (File)this.reports.getHtml().getOutputLocation().getAsFile().get());
        this.getLogger().lifecycle("See the report at: {}", new Object[]{new ConsoleRenderer().asClickableFileUrl(this.reports.getHtml().getEntryPoint())});
    }

    @Internal
    public Set<Project> getProjects() {
        return (Set)this.projects.get();
    }

    public void setProjects(Set<Project> projects) {
        this.projects.set(projects);
    }

    private ProjectsWithConfigurations<ProjectDetails.ProjectNameAndPath, ConfigurationDetails> computeProjectsWithConfigurations() {
        return ProjectsWithConfigurations.from(this.getProjects(), ProjectDetails::withNameAndPath, HtmlDependencyReportTask::getConfigurationsWhichCouldHaveDependencyInfo);
    }

    private static Stream<? extends ConfigurationDetails> getConfigurationsWhichCouldHaveDependencyInfo(Project project) {
        return project.getConfigurations().stream().map(ConfigurationInternal.class::cast).filter(c -> c.isDeclarableByExtension()).map(ConfigurationDetails::of);
    }
}

