/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal.install;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.authentication.Authentication;
import org.gradle.cache.FileLock;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.jvm.toolchain.JavaToolchainDownload;
import org.gradle.jvm.toolchain.JavaToolchainResolverRegistry;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.DefaultJavaToolchainRequest;
import org.gradle.jvm.toolchain.internal.JavaToolchainResolverRegistryInternal;
import org.gradle.jvm.toolchain.internal.RealizedJavaToolchainRepository;
import org.gradle.jvm.toolchain.internal.ToolchainDownloadFailedException;
import org.gradle.jvm.toolchain.internal.install.JavaToolchainProvisioningService;
import org.gradle.jvm.toolchain.internal.install.JdkCacheDirectory;
import org.gradle.jvm.toolchain.internal.install.SecureFileDownloader;
import org.gradle.platform.BuildPlatform;

public class DefaultJavaToolchainProvisioningService
implements JavaToolchainProvisioningService {
    public static final String AUTO_DOWNLOAD = "org.gradle.java.installations.auto-download";
    private static final Object PROVISIONING_PROCESS_LOCK = new Object();
    private final JavaToolchainResolverRegistryInternal toolchainResolverRegistry;
    private final SecureFileDownloader downloader;
    private final JdkCacheDirectory cacheDirProvider;
    private final Provider<Boolean> downloadEnabled;
    private final BuildOperationExecutor buildOperationExecutor;
    private final BuildPlatform buildPlatform;

    @Inject
    public DefaultJavaToolchainProvisioningService(JavaToolchainResolverRegistry toolchainResolverRegistry, SecureFileDownloader downloader, JdkCacheDirectory cacheDirProvider, ProviderFactory factory, BuildOperationExecutor executor, BuildPlatform buildPlatform) {
        this.toolchainResolverRegistry = (JavaToolchainResolverRegistryInternal)toolchainResolverRegistry;
        this.downloader = downloader;
        this.cacheDirProvider = cacheDirProvider;
        this.downloadEnabled = factory.gradleProperty(AUTO_DOWNLOAD).map(Boolean::parseBoolean);
        this.buildOperationExecutor = executor;
        this.buildPlatform = buildPlatform;
    }

    @Override
    public boolean isAutoDownloadEnabled() {
        return (Boolean)this.downloadEnabled.getOrElse((Object)true);
    }

    @Override
    public boolean hasConfiguredToolchainRepositories() {
        return !this.toolchainResolverRegistry.requestedRepositories().isEmpty();
    }

    @Override
    public File tryInstall(JavaToolchainSpec spec) {
        if (!this.isAutoDownloadEnabled()) {
            throw new ToolchainDownloadFailedException("No locally installed toolchains match and toolchain auto-provisioning is not enabled.", "Learn more about toolchain auto-detection at " + Documentation.userManual((String)"toolchains", (String)"sec:auto_detection").documentationUrl() + ".");
        }
        List<? extends RealizedJavaToolchainRepository> repositories = this.toolchainResolverRegistry.requestedRepositories();
        if (repositories.isEmpty()) {
            throw new ToolchainDownloadFailedException("No locally installed toolchains match and toolchain download repositories have not been configured.", "Learn more about toolchain auto-detection at " + Documentation.userManual((String)"toolchains", (String)"sec:auto_detection").documentationUrl() + ".", "Learn more about toolchain repositories at " + Documentation.userManual((String)"toolchains", (String)"sub:download_repositories").documentationUrl() + ".");
        }
        for (RealizedJavaToolchainRepository realizedJavaToolchainRepository : repositories) {
            Optional<JavaToolchainDownload> download = realizedJavaToolchainRepository.getResolver().resolve(new DefaultJavaToolchainRequest(spec, this.buildPlatform));
            if (!download.isPresent()) continue;
            Collection<Authentication> authentications = realizedJavaToolchainRepository.getAuthentications(download.get().getUri());
            return this.provisionInstallation(spec, download.get().getUri(), authentications);
        }
        throw new ToolchainDownloadFailedException("No locally installed toolchains match and the configured toolchain download repositories aren't able to provide a match either.", "Learn more about toolchain auto-detection at " + Documentation.userManual((String)"toolchains", (String)"sec:auto_detection").documentationUrl() + ".", "Learn more about toolchain repositories at " + Documentation.userManual((String)"toolchains", (String)"sub:download_repositories").documentationUrl() + ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File provisionInstallation(JavaToolchainSpec spec, URI uri, Collection<Authentication> authentications) {
        Object object = PROVISIONING_PROCESS_LOCK;
        synchronized (object) {
            File file;
            File downloadFolder = this.cacheDirProvider.getDownloadLocation();
            ExternalResource resource = this.wrapInOperation("Examining toolchain URI " + uri, () -> this.downloader.getResourceFor(uri, authentications));
            File archiveFile = new File(downloadFolder, this.getFileName(uri, resource));
            FileLock fileLock = this.cacheDirProvider.acquireWriteLock(archiveFile, "Downloading toolchain");
            try {
                if (!archiveFile.exists()) {
                    this.wrapInOperation("Downloading toolchain from URI " + uri, () -> {
                        this.downloader.download(uri, archiveFile, resource);
                        return null;
                    });
                }
                file = this.wrapInOperation("Unpacking toolchain archive " + archiveFile.getName(), () -> this.cacheDirProvider.provisionFromArchive(spec, archiveFile, uri));
            }
            catch (Throwable throwable) {
                try {
                    fileLock.close();
                    throw throwable;
                }
                catch (Exception e) {
                    throw new MissingToolchainException(spec, uri, e);
                }
            }
            fileLock.close();
            return file;
        }
    }

    private String getFileName(URI uri, ExternalResource resource) {
        ExternalResourceMetaData metaData = resource.getMetaData();
        if (metaData == null) {
            throw ResourceExceptions.getMissing((URI)uri);
        }
        String fileName = metaData.getFilename();
        if (fileName == null) {
            throw new GradleException("Can't determine filename for resource located at: " + uri);
        }
        return fileName;
    }

    private <T> T wrapInOperation(String displayName, Callable<T> provisioningStep) {
        return (T)this.buildOperationExecutor.call(new ToolchainProvisioningBuildOperation<T>(displayName, provisioningStep));
    }

    private static class ToolchainProvisioningBuildOperation<T>
    implements CallableBuildOperation<T> {
        private final String displayName;
        private final Callable<T> provisioningStep;

        public ToolchainProvisioningBuildOperation(String displayName, Callable<T> provisioningStep) {
            this.displayName = displayName;
            this.provisioningStep = provisioningStep;
        }

        public T call(BuildOperationContext context) throws Exception {
            return this.provisioningStep.call();
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)this.displayName).progressDisplayName(this.displayName);
        }
    }

    @Contextual
    private static class MissingToolchainException
    extends GradleException {
        public MissingToolchainException(JavaToolchainSpec spec, URI uri, @Nullable Throwable cause) {
            super("Unable to download toolchain matching the requirements (" + spec.getDisplayName() + ") from '" + uri + "'.", cause);
        }
    }
}

