/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IndexSink;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubInputStream;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubOutputStream;
import org.jetbrains.kotlin.com.intellij.util.io.StringRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinObjectStub;
import org.jetbrains.kotlin.psi.stubs.StubUtils;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinObjectStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.Utils;

public class KtObjectElementType
extends KtStubElementType<KotlinObjectStub, KtObjectDeclaration> {
    public KtObjectElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            KtObjectElementType.$$$reportNull$$$0(0);
        }
        super(debugName, KtObjectDeclaration.class, KotlinObjectStub.class);
    }

    @Override
    @NotNull
    public KotlinObjectStub createStub(@NotNull KtObjectDeclaration psi, StubElement parentStub) {
        if (psi == null) {
            KtObjectElementType.$$$reportNull$$$0(1);
        }
        String name2 = psi.getName();
        FqName fqName2 = KtPsiUtilKt.safeFqNameForLazyResolve(psi);
        List<String> superNames = KtPsiUtilKt.getSuperNames(psi);
        return new KotlinObjectStubImpl(parentStub, StringRef.fromString(name2), fqName2, psi.getClassId(), Utils.INSTANCE.wrapStrings(superNames), psi.isTopLevel(), psi.isCompanion(), psi.isLocal(), psi.isObjectLiteral());
    }

    @Override
    public void serialize(@NotNull KotlinObjectStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            KtObjectElementType.$$$reportNull$$$0(2);
        }
        if (dataStream == null) {
            KtObjectElementType.$$$reportNull$$$0(3);
        }
        dataStream.writeName(stub.getName());
        FqName fqName2 = stub.getFqName();
        dataStream.writeName(fqName2 != null ? fqName2.toString() : null);
        StubUtils.serializeClassId(dataStream, stub.getClassId());
        dataStream.writeBoolean(stub.isTopLevel());
        dataStream.writeBoolean(stub.isCompanion());
        dataStream.writeBoolean(stub.isLocal());
        dataStream.writeBoolean(stub.isObjectLiteral());
        List<String> superNames = stub.getSuperNames();
        dataStream.writeVarInt(superNames.size());
        for (String name2 : superNames) {
            dataStream.writeName(name2);
        }
    }

    @Override
    @NotNull
    public KotlinObjectStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            KtObjectElementType.$$$reportNull$$$0(4);
        }
        StringRef name2 = dataStream.readName();
        StringRef fqNameStr = dataStream.readName();
        FqName fqName2 = fqNameStr != null ? new FqName(fqNameStr.toString()) : null;
        ClassId classId = StubUtils.deserializeClassId(dataStream);
        boolean isTopLevel = dataStream.readBoolean();
        boolean isCompanion = dataStream.readBoolean();
        boolean isLocal = dataStream.readBoolean();
        boolean isObjectLiteral = dataStream.readBoolean();
        int superCount = dataStream.readVarInt();
        StringRef[] superNames = StringRef.createArray(superCount);
        for (int i = 0; i < superCount; ++i) {
            superNames[i] = dataStream.readName();
        }
        return new KotlinObjectStubImpl(parentStub, name2, fqName2, classId, superNames, isTopLevel, isCompanion, isLocal, isObjectLiteral);
    }

    @Override
    public void indexStub(@NotNull KotlinObjectStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            KtObjectElementType.$$$reportNull$$$0(5);
        }
        if (sink == null) {
            KtObjectElementType.$$$reportNull$$$0(6);
        }
        StubIndexService.getInstance().indexObject(stub, sink);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/psi/stubs/elements/KtObjectElementType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createStub";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "indexStub";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

