/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.icons.AllIcons;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.HierarchicalMethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiKeyword;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceType;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.ResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.filters.ElementFilter;
import org.jetbrains.kotlin.com.intellij.psi.impl.CheckUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.FunctionalExpressionStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaStubPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.MethodReferenceResolver;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.scope.ElementClassFilter;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiConflictResolver;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.conflictResolvers.DuplicateConflictResolver;
import org.jetbrains.kotlin.com.intellij.psi.scope.processor.FilterScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.util.PsiScopesUtil;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class PsiMethodReferenceExpressionImpl
extends JavaStubPsiElement<FunctionalExpressionStub<PsiMethodReferenceExpression>>
implements PsiMethodReferenceExpression {
    private static final Logger LOG = Logger.getInstance(PsiMethodReferenceExpressionImpl.class);
    private static final MethodReferenceResolver RESOLVER = new MethodReferenceResolver();

    public PsiMethodReferenceExpressionImpl(@NotNull FunctionalExpressionStub<PsiMethodReferenceExpression> stub) {
        if (stub == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(0);
        }
        super(stub, (IStubElementType)JavaStubElementTypes.METHOD_REF_EXPRESSION);
    }

    public PsiMethodReferenceExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(1);
        }
        super(node);
    }

    @Override
    public PsiTypeElement getQualifierType() {
        PsiElement qualifier2 = this.getQualifier();
        return qualifier2 instanceof PsiTypeElement ? (PsiTypeElement)qualifier2 : null;
    }

    @Override
    @Nullable
    public PsiType getFunctionalInterfaceType() {
        return this.getGroundTargetType(LambdaUtil.getFunctionalInterfaceType(this, true));
    }

    @Override
    public boolean isExact() {
        return this.getPotentiallyApplicableMember() != null;
    }

    @Override
    public boolean isPotentiallyCompatible(@Nullable PsiType functionalInterfaceType) {
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(functionalInterfaceType);
        if (interfaceMethod == null) {
            return false;
        }
        MethodReferenceResolver resolver = new MethodReferenceResolver(){

            @Override
            protected PsiConflictResolver createResolver(@NotNull PsiMethodReferenceExpressionImpl referenceExpression2, @NotNull PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult, PsiMethod interfaceMethod, MethodSignature signature2) {
                if (referenceExpression2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (qualifierResolveResult == null) {
                    1.$$$reportNull$$$0(1);
                }
                return DuplicateConflictResolver.INSTANCE;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "referenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "qualifierResolveResult";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl$1";
                objectArray[2] = "createResolver";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ResolveResult[] result2 = LambdaUtil.performWithTargetType(this, functionalInterfaceType, () -> resolver.resolve(this, this.getContainingFile(), false));
        PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(this);
        int interfaceArity = interfaceMethod.getParameterList().getParametersCount();
        for (ResolveResult resolveResult : result2) {
            PsiElement element = resolveResult.getElement();
            if (element instanceof PsiMethod) {
                boolean isStatic = ((PsiMethod)element).hasModifierProperty("static");
                int parametersCount = ((PsiMethod)element).getParameterList().getParametersCount();
                if (qualifierResolveResult.isReferenceTypeQualified() && this.getReferenceNameElement() instanceof PsiIdentifier) {
                    int offset2;
                    int n = offset2 = isStatic ? 0 : 1;
                    if (parametersCount == interfaceArity - offset2) {
                        return true;
                    }
                    if (!((PsiMethod)element).isVarArgs() || !interfaceMethod.isVarArgs() && interfaceArity < parametersCount + offset2 - 1) continue;
                    return true;
                }
                if (isStatic) continue;
                if (parametersCount == interfaceArity) {
                    return true;
                }
                if (!((PsiMethod)element).isVarArgs() || !interfaceMethod.isVarArgs() && interfaceArity < parametersCount - 1) continue;
                return true;
            }
            if (!(element instanceof PsiClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public PsiType getGroundTargetType(PsiType functionalInterfaceType) {
        return FunctionalInterfaceParameterizationUtil.getGroundTargetType(functionalInterfaceType);
    }

    @Override
    public PsiMember getPotentiallyApplicableMember() {
        return (PsiMember)CachedValuesManager.getCachedValue(this, () -> CachedValueProvider.Result.create(this.getPotentiallyApplicableMemberInternal(), PsiModificationTracker.MODIFICATION_COUNT, this));
    }

    private PsiMember getPotentiallyApplicableMemberInternal() {
        PsiElement resolve2;
        PsiElement element = this.getReferenceNameElement();
        PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(this);
        PsiClass containingClass = qualifierResolveResult.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        PsiElement qualifier2 = this.getQualifier();
        if (qualifier2 instanceof PsiReferenceExpression && (resolve2 = ((PsiReferenceExpression)qualifier2).resolve()) instanceof PsiClass && ((PsiClass)resolve2).hasTypeParameters()) {
            return null;
        }
        PsiMethod[] methods2 = null;
        if (element instanceof PsiIdentifier) {
            String identifierName = element.getText();
            methods2 = containingClass.findMethodsByName(identifierName, true);
            if (methods2.length == 0) {
                return null;
            }
            if (methods2.length > 1) {
                ArrayList<PsiMethod> result2 = new ArrayList<PsiMethod>();
                for (HierarchicalMethodSignature signature2 : containingClass.getVisibleSignatures()) {
                    if (!identifierName.equals(signature2.getName())) continue;
                    result2.add(signature2.getMethod());
                }
                if (result2.isEmpty()) {
                    return null;
                }
                methods2 = result2.toArray(PsiMethod.EMPTY_ARRAY);
            }
        } else if (this.isConstructor()) {
            PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(this.getProject());
            PsiMethod[] arrayClass = factory2.getArrayClass(PsiUtil.getLanguageLevel(this));
            if (arrayClass == containingClass) {
                PsiTypeParameter[] typeParameters2 = arrayClass.getTypeParameters();
                if (typeParameters2.length != 1) {
                    return null;
                }
                PsiType componentType = qualifierResolveResult.getSubstitutor().substitute(typeParameters2[0]);
                LOG.assertTrue(componentType != null, qualifierResolveResult.getSubstitutor());
                return factory2.createMethodFromText("public " + componentType.createArrayType().getCanonicalText() + " __array__(int i) {return null;}", this);
            }
            methods2 = containingClass.getConstructors();
        }
        if (methods2 != null) {
            PsiMethod psiMethod = null;
            if (methods2.length > 0) {
                for (PsiMethod method : methods2) {
                    if (!PsiUtil.isAccessible(method, this, null)) continue;
                    if (psiMethod != null) {
                        return null;
                    }
                    psiMethod = method;
                }
                if (psiMethod == null) {
                    return null;
                }
                if (psiMethod.isVarArgs()) {
                    return null;
                }
                if (psiMethod.getTypeParameters().length > 0) {
                    PsiReferenceParameterList parameterList2 = this.getParameterList();
                    return parameterList2 != null && parameterList2.getTypeParameterElements().length > 0 ? psiMethod : null;
                }
            }
            return psiMethod == null ? containingClass : psiMethod;
        }
        return null;
    }

    @Override
    public PsiExpression getQualifierExpression() {
        PsiElement qualifier2 = this.getQualifier();
        return qualifier2 instanceof PsiExpression ? (PsiExpression)qualifier2 : null;
    }

    @Override
    public PsiType getType() {
        return new PsiMethodReferenceType(this);
    }

    @Override
    public PsiElement getReferenceNameElement() {
        PsiElement element = this.getLastChild();
        return element instanceof PsiIdentifier || PsiUtil.isJavaToken(element, JavaTokenType.NEW_KEYWORD) ? element : null;
    }

    @Override
    public void processVariants(@NotNull PsiScopeProcessor processor2) {
        if (processor2 == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(2);
        }
        FilterScopeProcessor proc = new FilterScopeProcessor((ElementFilter)ElementClassFilter.METHOD, processor2);
        PsiScopesUtil.resolveAndWalk(proc, this, null, true);
    }

    @Override
    public void setQualifierExpression(@Nullable PsiExpression newQualifier) throws IncorrectOperationException {
        if (newQualifier == null) {
            LOG.error("Forbidden null qualifier");
            return;
        }
        PsiExpression expression2 = this.getQualifierExpression();
        if (expression2 != null) {
            expression2.replace(newQualifier);
        } else {
            PsiElement qualifier2 = this.getQualifier();
            if (qualifier2 != null) {
                qualifier2.replace(newQualifier);
            }
        }
    }

    @Override
    public JavaResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        JavaResolveResult[] javaResolveResultArray = PsiImplUtil.multiResolveImpl(this, incompleteCode, RESOLVER);
        if (javaResolveResultArray == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(3);
        }
        return javaResolveResultArray;
    }

    @Override
    public PsiElement getQualifier() {
        PsiElement element = this.getFirstChild();
        return element instanceof PsiExpression || element instanceof PsiTypeElement ? element : null;
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        PsiElement element = this.getReferenceNameElement();
        if (element != null) {
            int offsetInParent = element.getStartOffsetInParent();
            return new TextRange(offsetInParent, offsetInParent + element.getTextLength());
        }
        Object colons = this.findChildByType(JavaTokenType.DOUBLE_COLON);
        if (colons != null) {
            int offsetInParent = colons.getStartOffsetInParent();
            return new TextRange(offsetInParent, offsetInParent + colons.getTextLength());
        }
        LOG.error(this.getText());
        if (null == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string2 = this.getText();
        if (string2 == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(6);
        }
        if (!(element instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)element;
        PsiElement nameElement = this.getReferenceNameElement();
        if (nameElement instanceof PsiIdentifier ? !nameElement.getText().equals(method.getName()) : PsiUtil.isJavaToken(nameElement, JavaTokenType.NEW_KEYWORD) && !method.isConstructor()) {
            return false;
        }
        return element.getManager().areElementsEquivalent(element, this.resolve());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(7);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitMethodReferenceExpression(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(8);
        }
        CheckUtil.checkWritable(this);
        if (this.isReferenceTo(element) || !this.isPhysical()) {
            return this;
        }
        if (element instanceof PsiMethod) {
            return this.handleElementRename(((PsiMethod)element).getName());
        }
        if (element instanceof PsiClass) {
            return this;
        }
        throw new IncorrectOperationException(element.toString());
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        Object oldIdentifier;
        if (newElementName == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(9);
        }
        if ((oldIdentifier = this.findChildByType(JavaTokenType.IDENTIFIER)) == null) {
            oldIdentifier = this.findChildByType(JavaElementType.REFERENCE_EXPRESSION);
        }
        if (oldIdentifier == null) {
            throw new IncorrectOperationException();
        }
        String oldRefName = oldIdentifier.getText();
        if ("this".equals(oldRefName) || "super".equals(oldRefName) || "new".equals(oldRefName) || Comparing.strEqual(oldRefName, newElementName)) {
            return this;
        }
        PsiIdentifier identifier = JavaPsiFacade.getElementFactory(this.getProject()).createIdentifier(newElementName);
        oldIdentifier.replace(identifier);
        return this;
    }

    @Override
    public boolean isConstructor() {
        PsiElement element = this.getReferenceNameElement();
        return element instanceof PsiKeyword && "new".equals(element.getText());
    }

    @Override
    public String toString() {
        return "PsiMethodReferenceExpression";
    }

    @Override
    public boolean isAcceptable(PsiType left, PsiMethod method) {
        if (left instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)left).getConjuncts()) {
                if (!this.isAcceptable(conjunct)) continue;
                return true;
            }
            return false;
        }
        PsiExpressionList argsList = PsiTreeUtil.getParentOfType((PsiElement)this, PsiExpressionList.class);
        boolean isExact = this.isExact();
        if (method != null && MethodCandidateInfo.isOverloadCheck(argsList)) {
            if (isExact && !InferenceSession.isPertinentToApplicability(this, method)) {
                return true;
            }
            if (LambdaUtil.isPotentiallyCompatibleWithTypeParameter(this, argsList, method)) {
                return true;
            }
        }
        if (!this.isPotentiallyCompatible(left = this.getGroundTargetType(left))) {
            return false;
        }
        if (MethodCandidateInfo.isOverloadCheck(argsList) && !isExact) {
            return true;
        }
        JavaResolveResult result2 = LambdaUtil.performWithTargetType(this, left, () -> this.advancedResolve(false));
        if (result2 instanceof MethodCandidateInfo && !((MethodCandidateInfo)result2).isApplicable()) {
            return false;
        }
        PsiElement resolve2 = result2.getElement();
        if (resolve2 == null) {
            return false;
        }
        return PsiMethodReferenceUtil.isReturnTypeCompatible(this, result2, left);
    }

    @Override
    @Nullable
    public Icon getIcon(int flags) {
        return AllIcons.Nodes.MethodReference;
    }

    @Override
    public PsiElement bindToElementViaStaticImport(@NotNull PsiClass qualifierClass) throws IncorrectOperationException {
        if (qualifierClass == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(10);
        }
        throw new IncorrectOperationException();
    }

    @Override
    @NotNull
    public PsiElement getElement() {
        PsiMethodReferenceExpressionImpl psiMethodReferenceExpressionImpl = this;
        if (psiMethodReferenceExpressionImpl == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(11);
        }
        return psiMethodReferenceExpressionImpl;
    }

    @Override
    public PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    @Override
    public Object @NotNull [] getVariants() {
        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(12);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        JavaResolveResult javaResolveResult = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(13);
        }
        return javaResolveResult;
    }

    @Override
    public String getReferenceName() {
        PsiElement element = this.getReferenceNameElement();
        return element != null ? element.getText() : null;
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        return PsiTreeUtil.getChildOfType(this, PsiReferenceParameterList.class);
    }

    @Override
    public PsiType @NotNull [] getTypeParameters() {
        PsiReferenceParameterList parameterList2 = this.getParameterList();
        PsiType[] psiTypeArray = parameterList2 != null ? parameterList2.getTypeArguments() : PsiType.EMPTY_ARRAY;
        if (psiTypeArray == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(14);
        }
        return psiTypeArray;
    }

    @Override
    public boolean isQualified() {
        return this.getQualifier() != null;
    }

    @Override
    public String getQualifiedName() {
        return this.getCanonicalText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "advancedResolve";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processVariants";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "bindToElementViaStaticImport";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

