/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import java.lang.ref.WeakReference;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Attachment;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayInitializerExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiDiamondTypeImpl;
import org.jetbrains.kotlin.com.intellij.psi.PsiDisjunctionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiEllipsisType;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiForeachStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.SyntaxTraverser;
import org.jetbrains.kotlin.com.intellij.psi.TypeAnnotationProvider;
import org.jetbrains.kotlin.com.intellij.psi.augment.PsiAugmentProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.ClassReferencePointer;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaVarTypeUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiClassReferenceType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiDiamondTypeElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.JBIterable;

public class PsiTypeElementImpl
extends CompositePsiElement
implements PsiTypeElement {
    public PsiTypeElementImpl() {
        this(JavaElementType.TYPE);
    }

    PsiTypeElementImpl(@NotNull IElementType type2) {
        if (type2 == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(0);
        }
        super(type2);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(1);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitTypeElement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiType psiType2 = CachedValuesManager.getProjectPsiDependentCache(this, __ -> this.calculateType());
        if (psiType2 == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(2);
        }
        return psiType2;
    }

    @NotNull
    private PsiType calculateType() {
        PsiType inferredType = PsiAugmentProvider.getInferredType(this);
        if (inferredType != null) {
            PsiType psiType2 = inferredType;
            if (psiType2 == null) {
                PsiTypeElementImpl.$$$reportNull$$$0(3);
            }
            return psiType2;
        }
        PsiType type2 = null;
        boolean ellipsis = false;
        SmartList<PsiAnnotation> annotations2 = new SmartList<PsiAnnotation>();
        SmartList<TypeAnnotationProvider> arrayComponentAnnotations = new SmartList<TypeAnnotationProvider>();
        PsiElement parent2 = this.getParent();
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            List<PsiType> types2;
            if (child instanceof PsiComment || child instanceof PsiWhiteSpace) continue;
            if (child instanceof PsiAnnotation) {
                annotations2.add((PsiAnnotation)child);
            } else if (child instanceof PsiTypeElement) {
                assert (type2 == null) : this;
                if (child instanceof PsiDiamondTypeElementImpl) {
                    type2 = new PsiDiamondTypeImpl(this.getManager(), this);
                    break;
                }
                type2 = ((PsiTypeElement)child).getType();
            } else if (PsiUtil.isJavaToken(child, ElementType.PRIMITIVE_TYPE_BIT_SET)) {
                assert (type2 == null) : this;
                String text2 = child.getText();
                type2 = annotations2.isEmpty() ? PsiJavaParserFacadeImpl.getPrimitiveType(text2) : new PsiPrimitiveType(text2, PsiTypeElementImpl.createProvider(annotations2));
            } else if (PsiUtil.isJavaToken(child, JavaTokenType.VAR_KEYWORD)) {
                assert (type2 == null) : this;
                type2 = this.inferVarType(parent2);
            } else if (child instanceof PsiJavaCodeReferenceElement) {
                assert (type2 == null) : this;
                type2 = new PsiClassReferenceType(PsiTypeElementImpl.getReferenceComputable((PsiJavaCodeReferenceElement)child), null, PsiTypeElementImpl.createProvider(annotations2));
            } else if (PsiUtil.isJavaToken(child, JavaTokenType.LBRACKET)) {
                assert (type2 != null) : this;
                arrayComponentAnnotations.add(PsiTypeElementImpl.createProvider(annotations2));
                annotations2 = new SmartList();
            } else if (PsiUtil.isJavaToken(child, JavaTokenType.ELLIPSIS)) {
                assert (type2 != null) : this;
                arrayComponentAnnotations.add(PsiTypeElementImpl.createProvider(annotations2));
                annotations2 = new SmartList();
                ellipsis = true;
            }
            if (PsiUtil.isJavaToken(child, JavaTokenType.QUEST) || child instanceof ASTNode && ((ASTNode)((Object)child)).getElementType() == JavaElementType.DUMMY_ELEMENT && "any".equals(child.getText())) {
                assert (type2 == null) : this;
                PsiElement boundKind = PsiTreeUtil.skipWhitespacesAndCommentsForward(child);
                PsiElement boundType = PsiTreeUtil.skipWhitespacesAndCommentsForward(boundKind);
                type2 = PsiUtil.isJavaToken(boundKind, JavaTokenType.EXTENDS_KEYWORD) && boundType instanceof PsiTypeElement ? PsiWildcardType.createExtends(this.getManager(), ((PsiTypeElement)boundType).getType()) : (PsiUtil.isJavaToken(boundKind, JavaTokenType.SUPER_KEYWORD) && boundType instanceof PsiTypeElement ? PsiWildcardType.createSuper(this.getManager(), ((PsiTypeElement)boundType).getType()) : PsiWildcardType.createUnbounded(this.getManager()));
                type2 = type2.annotate(PsiTypeElementImpl.createProvider(annotations2));
                break;
            }
            if (PsiUtil.isJavaToken(child, JavaTokenType.AND)) {
                types2 = this.collectTypes();
                assert (!types2.isEmpty()) : this;
                type2 = PsiIntersectionType.createIntersection(false, types2.toArray(PsiType.createArray(types2.size())));
                break;
            }
            if (!PsiUtil.isJavaToken(child, JavaTokenType.OR)) continue;
            types2 = this.collectTypes();
            assert (!types2.isEmpty()) : this;
            type2 = PsiDisjunctionType.createDisjunction(types2, this.getManager());
            break;
        }
        if (type2 == null) {
            PsiPrimitiveType psiPrimitiveType = PsiType.NULL;
            if (psiPrimitiveType == null) {
                PsiTypeElementImpl.$$$reportNull$$$0(4);
            }
            return psiPrimitiveType;
        }
        if (!arrayComponentAnnotations.isEmpty()) {
            type2 = PsiTypeElementImpl.createArray(type2, arrayComponentAnnotations, ellipsis);
        }
        if (parent2 instanceof PsiModifierListOwner) {
            type2 = JavaSharedImplUtil.applyAnnotations(type2, ((PsiModifierListOwner)parent2).getModifierList());
        }
        PsiType psiType3 = type2;
        if (psiType3 == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(5);
        }
        return psiType3;
    }

    private static PsiType createArray(PsiType elementType, List<TypeAnnotationProvider> providers, boolean ellipsis) {
        PsiType result2 = elementType;
        for (int i = providers.size() - 1; i >= 0; --i) {
            TypeAnnotationProvider provider2 = providers.get(i);
            result2 = ellipsis && i == 0 ? new PsiEllipsisType(result2, provider2) : new PsiArrayType(result2, provider2);
        }
        providers.clear();
        return result2;
    }

    private PsiType inferVarType(PsiElement parent2) {
        if (parent2 instanceof PsiParameter) {
            PsiElement declarationScope = ((PsiParameter)parent2).getDeclarationScope();
            if (declarationScope instanceof PsiForeachStatement) {
                PsiExpression iteratedValue = ((PsiForeachStatement)declarationScope).getIteratedValue();
                if (iteratedValue != null) {
                    return JavaGenericsUtil.getCollectionItemType(iteratedValue);
                }
                return null;
            }
            if (declarationScope instanceof PsiLambdaExpression) {
                return ((PsiParameter)parent2).getType();
            }
        } else {
            for (PsiElement e = this; e != null; e = e.getNextSibling()) {
                if (!(e instanceof PsiExpression)) continue;
                if (!(e instanceof PsiArrayInitializerExpression)) {
                    PsiExpression expression2 = (PsiExpression)e;
                    PsiType type2 = RecursionManager.doPreventingRecursion(expression2, true, () -> expression2.getType());
                    return type2 == null ? null : JavaVarTypeUtil.getUpwardProjection(type2);
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean isInferredType() {
        return PsiUtil.isJavaToken(this.getFirstChild(), JavaTokenType.VAR_KEYWORD) || PsiAugmentProvider.isInferredType(this);
    }

    @NotNull
    private static ClassReferencePointer getReferenceComputable(@NotNull PsiJavaCodeReferenceElement ref) {
        block6: {
            int index2;
            PsiElement parent2;
            PsiTypeElement rootType;
            block7: {
                if (ref == null) {
                    PsiTypeElementImpl.$$$reportNull$$$0(6);
                }
                if ((rootType = PsiTypeElementImpl.getRootTypeElement(ref)) == null) break block6;
                parent2 = rootType.getParent();
                if (parent2 instanceof PsiMethod) break block7;
                if (!(parent2 instanceof PsiVariable)) break block6;
            }
            if ((index2 = PsiTypeElementImpl.allReferencesInside(rootType).indexOf(ref::equals)) < 0) {
                throw new AssertionError(rootType.getClass());
            }
            return PsiTypeElementImpl.computeFromTypeOwner(parent2, index2, new WeakReference<PsiJavaCodeReferenceElement>(ref));
        }
        ClassReferencePointer classReferencePointer = ClassReferencePointer.constant(ref);
        if (classReferencePointer == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(7);
        }
        return classReferencePointer;
    }

    @Nullable
    private static PsiTypeElement getRootTypeElement(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(8);
        }
        PsiElement root2 = SyntaxTraverser.psiApi().parents(ref.getParent()).takeWhile(it -> it instanceof PsiTypeElement || it instanceof PsiReferenceParameterList || it instanceof PsiJavaCodeReferenceElement).last();
        return ObjectUtils.tryCast(root2, PsiTypeElement.class);
    }

    @NotNull
    private static JBIterable<PsiJavaCodeReferenceElement> allReferencesInside(@NotNull PsiTypeElement rootType) {
        if (rootType == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(9);
        }
        JBIterable<PsiJavaCodeReferenceElement> jBIterable = SyntaxTraverser.psiTraverser(rootType).filter(PsiJavaCodeReferenceElement.class);
        if (jBIterable == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(10);
        }
        return jBIterable;
    }

    @NotNull
    private static ClassReferencePointer computeFromTypeOwner(final PsiElement parent2, final int index2, final @NotNull WeakReference<PsiJavaCodeReferenceElement> ref) {
        if (ref == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(11);
        }
        return new ClassReferencePointer(){
            volatile WeakReference<PsiJavaCodeReferenceElement> myCache;
            {
                this.myCache = ref;
            }

            @Override
            @Nullable
            public PsiJavaCodeReferenceElement retrieveReference() {
                PsiJavaCodeReferenceElement result2 = (PsiJavaCodeReferenceElement)this.myCache.get();
                if (result2 == null) {
                    PsiType type2 = this.calcTypeByParent();
                    if (type2 instanceof PsiClassReferenceType) {
                        result2 = this.findReferenceByIndex((PsiClassReferenceType)type2);
                    }
                    this.myCache = new WeakReference<PsiJavaCodeReferenceElement>(result2);
                }
                return result2;
            }

            @Nullable
            private PsiJavaCodeReferenceElement findReferenceByIndex(PsiClassReferenceType type2) {
                PsiTypeElement root2 = PsiTypeElementImpl.getRootTypeElement(type2.getReference());
                return root2 == null ? null : (PsiJavaCodeReferenceElement)PsiTypeElementImpl.allReferencesInside(root2).get(index2);
            }

            @Nullable
            private PsiType calcTypeByParent() {
                PsiType type2;
                if (!parent2.isValid()) {
                    return null;
                }
                PsiType psiType2 = type2 = parent2 instanceof PsiMethod ? ((PsiMethod)parent2).getReturnType() : ((PsiVariable)parent2).getType();
                if (type2 instanceof PsiArrayType) {
                    return type2.getDeepComponentType();
                }
                return type2;
            }

            @Override
            @NotNull
            public PsiJavaCodeReferenceElement retrieveNonNullReference() {
                PsiJavaCodeReferenceElement result2 = this.retrieveReference();
                if (result2 == null) {
                    PsiType type2 = this.calcTypeByParent();
                    if (!(type2 instanceof PsiClassReferenceType)) {
                        PsiUtilCore.ensureValid(parent2);
                        throw new IllegalStateException("No reference type for " + parent2.getClass() + "; type: " + (type2 != null ? type2.getClass() : "null"));
                    }
                    result2 = this.findReferenceByIndex((PsiClassReferenceType)type2);
                    if (result2 == null) {
                        PsiUtilCore.ensureValid(parent2);
                        throw new RuntimeExceptionWithAttachments("Can't retrieve reference by index " + index2 + " for " + parent2.getClass() + "; type: " + type2.getClass(), new Attachment("memberType.txt", type2.getCanonicalText()));
                    }
                }
                PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = result2;
                if (psiJavaCodeReferenceElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiJavaCodeReferenceElement;
            }

            public String toString() {
                String msg2 = "Type element reference of " + parent2.getClass() + " #" + parent2.getClass().getSimpleName() + ", index=" + index2;
                return parent2.isValid() ? msg2 + " #" + parent2.getLanguage() : msg2 + ", invalid";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiTypeElementImpl$1", "retrieveNonNullReference"));
            }
        };
    }

    @NotNull
    private static TypeAnnotationProvider createProvider(@NotNull List<PsiAnnotation> annotations2) {
        if (annotations2 == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(12);
        }
        TypeAnnotationProvider typeAnnotationProvider = TypeAnnotationProvider.Static.create(ContainerUtil.copyAndClear(annotations2, PsiAnnotation.ARRAY_FACTORY, true));
        if (typeAnnotationProvider == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(13);
        }
        return typeAnnotationProvider;
    }

    @NotNull
    private List<PsiType> collectTypes() {
        List<PsiTypeElement> typeElements = PsiTreeUtil.getChildrenOfTypeAsList(this, PsiTypeElement.class);
        List<PsiType> list2 = ContainerUtil.map(typeElements, typeElement -> typeElement.getType());
        if (list2 == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(14);
        }
        return list2;
    }

    @Override
    public PsiJavaCodeReferenceElement getInnermostComponentReferenceElement() {
        TreeElement firstChildNode = this.getFirstChildNode();
        if (firstChildNode == null) {
            return null;
        }
        if (firstChildNode.getElementType() == JavaElementType.TYPE) {
            return ((PsiTypeElement)SourceTreeToPsiMap.treeToPsiNotNull(firstChildNode)).getInnermostComponentReferenceElement();
        }
        return this.getReferenceElement();
    }

    @Nullable
    private PsiJavaCodeReferenceElement getReferenceElement() {
        ASTNode ref = this.findChildByType(JavaElementType.JAVA_CODE_REFERENCE);
        if (ref == null) {
            return null;
        }
        return (PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeElementToPsi(ref);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(15);
        }
        if (state == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(16);
        }
        if (place == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(17);
        }
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        return true;
    }

    @Override
    public PsiAnnotation @NotNull [] getAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getType().getAnnotations();
        if (psiAnnotationArray == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(18);
        }
        return psiAnnotationArray;
    }

    @Override
    public PsiAnnotation @NotNull [] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations();
        if (psiAnnotationArray == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(19);
        }
        return psiAnnotationArray;
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(20);
        }
        return PsiImplUtil.findAnnotation(this, qualifiedName);
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        PsiModifierList modifierList2;
        PsiIdentifier identifier;
        if (qualifiedName == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(21);
        }
        PsiAnnotation annotation2 = JavaPsiFacade.getElementFactory(this.getProject()).createAnnotationFromText('@' + qualifiedName, this);
        PsiElement firstChild = this.getFirstChild();
        for (PsiElement child = this.getLastChild(); child != firstChild; child = child.getPrevSibling()) {
            if (!PsiUtil.isJavaToken(child, JavaTokenType.LBRACKET) && !PsiUtil.isJavaToken(child, JavaTokenType.ELLIPSIS)) continue;
            PsiAnnotation psiAnnotation = (PsiAnnotation)this.addBefore(annotation2, child);
            if (psiAnnotation == null) {
                PsiTypeElementImpl.$$$reportNull$$$0(22);
            }
            return psiAnnotation;
        }
        if (firstChild instanceof PsiJavaCodeReferenceElement && (identifier = PsiTreeUtil.getChildOfType(firstChild, PsiIdentifier.class)) != null && identifier != firstChild.getFirstChild()) {
            PsiAnnotation psiAnnotation = (PsiAnnotation)firstChild.addBefore(annotation2, identifier);
            if (psiAnnotation == null) {
                PsiTypeElementImpl.$$$reportNull$$$0(23);
            }
            return psiAnnotation;
        }
        PsiElement parent2 = this.getParent();
        while (parent2 instanceof PsiTypeElement && ((PsiTypeElement)parent2).getType() instanceof PsiArrayType) {
            parent2 = parent2.getParent();
        }
        if (parent2 instanceof PsiModifierListOwner && (modifierList2 = ((PsiModifierListOwner)parent2).getModifierList()) != null) {
            PsiTypeParameterList list2;
            PsiTypeParameterList psiTypeParameterList = list2 = parent2 instanceof PsiTypeParameterListOwner ? ((PsiTypeParameterListOwner)parent2).getTypeParameterList() : null;
            if (list2 == null || list2.textMatches("")) {
                PsiAnnotation psiAnnotation = (PsiAnnotation)modifierList2.add(annotation2);
                if (psiAnnotation == null) {
                    PsiTypeElementImpl.$$$reportNull$$$0(24);
                }
                return psiAnnotation;
            }
        }
        PsiAnnotation psiAnnotation = (PsiAnnotation)this.addBefore(annotation2, firstChild);
        if (psiAnnotation == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(25);
        }
        return psiAnnotation;
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        PsiElement result2;
        if (newElement == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(26);
        }
        if (!(newElement instanceof PsiTypeElement) || !((PsiTypeElement)newElement).isInferredType()) {
            PsiImplUtil.markTypeAnnotations(this);
        }
        if ((result2 = super.replace(newElement)) instanceof PsiTypeElement) {
            PsiImplUtil.deleteTypeAnnotations((PsiTypeElement)result2);
        }
        return result2;
    }

    @Override
    public boolean acceptsAnnotations() {
        if (this.isInferredType()) {
            return false;
        }
        PsiType type2 = this.getType();
        return !PsiType.VOID.equals(type2) && !PsiType.NULL.equals(type2);
    }

    @Override
    public String toString() {
        return "PsiTypeElement:" + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiTypeElementImpl";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiTypeElementImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceComputable";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "allReferencesInside";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createProvider";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTypes";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableAnnotations";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "addAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceComputable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRootTypeElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "allReferencesInside";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeFromTypeOwner";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createProvider";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotation";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

