/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profile;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.profile.BuildProfile;
import org.gradle.profile.ProfileReportRenderer;

@ServiceScope(value=Scopes.BuildTree.class)
public class ReportGeneratingProfileListener {
    private static final SimpleDateFormat FILE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
    private final StyledTextOutputFactory textOutputFactory;

    public ReportGeneratingProfileListener(StyledTextOutputFactory textOutputFactory) {
        this.textOutputFactory = textOutputFactory;
    }

    public void buildFinished(BuildProfile buildProfile) {
        ProfileReportRenderer renderer = new ProfileReportRenderer();
        File file = new File(buildProfile.getBuildDir(), "reports/profile/profile-" + FILE_DATE_FORMAT.format(new Date(buildProfile.getBuildStarted())) + ".html");
        renderer.writeTo(buildProfile, file);
        this.renderReportUrl(file);
    }

    private void renderReportUrl(File reportFile) {
        StyledTextOutput textOutput = this.textOutputFactory.create(ReportGeneratingProfileListener.class, LogLevel.LIFECYCLE);
        textOutput.println();
        String reportUrl = new ConsoleRenderer().asClickableFileUrl(reportFile);
        textOutput.formatln("See the profiling report at: %s", new Object[]{reportUrl});
        textOutput.text((Object)"A fine-grained performance profile is available: use the ");
        textOutput.withStyle(StyledTextOutput.Style.UserInput).format("--%s", new Object[]{"scan"});
        textOutput.text((Object)" option.");
        textOutput.println();
    }
}

