/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache;

import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.tasks.TaskDependencyUsageTracker;
import org.gradle.configurationcache.CoupledProjectsListener;
import org.gradle.configurationcache.problems.ProblemFactory;
import org.gradle.configurationcache.problems.ProblemsListener;
import org.gradle.configurationcache.problems.PropertyProblem;
import org.gradle.configurationcache.problems.StructuredMessage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0016\u0010\u0010\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\b\u0010\u0011\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/gradle/configurationcache/ReportingTaskDependencyUsageTracker;", "Lorg/gradle/api/internal/tasks/TaskDependencyUsageTracker;", "referrer", "Lorg/gradle/api/internal/project/ProjectInternal;", "coupledProjectsListener", "Lorg/gradle/configurationcache/CoupledProjectsListener;", "problems", "Lorg/gradle/configurationcache/problems/ProblemsListener;", "problemFactory", "Lorg/gradle/configurationcache/problems/ProblemFactory;", "(Lorg/gradle/api/internal/project/ProjectInternal;Lorg/gradle/configurationcache/CoupledProjectsListener;Lorg/gradle/configurationcache/problems/ProblemsListener;Lorg/gradle/configurationcache/problems/ProblemFactory;)V", "checkForCoupledProjects", "", "taskDependencies", "", "Lorg/gradle/api/Task;", "onTaskDependencyUsage", "reportProjectIsolationProblemOnApiUsage", "configuration-cache"})
@SourceDebugExtension(value={"SMAP\nReportingTaskDependencyUsageTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReportingTaskDependencyUsageTracker.kt\norg/gradle/configurationcache/ReportingTaskDependencyUsageTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1855#2,2:61\n*S KotlinDebug\n*F\n+ 1 ReportingTaskDependencyUsageTracker.kt\norg/gradle/configurationcache/ReportingTaskDependencyUsageTracker\n*L\n42#1:61,2\n*E\n"})
public final class ReportingTaskDependencyUsageTracker
implements TaskDependencyUsageTracker {
    @NotNull
    private final ProjectInternal referrer;
    @NotNull
    private final CoupledProjectsListener coupledProjectsListener;
    @NotNull
    private final ProblemsListener problems;
    @NotNull
    private final ProblemFactory problemFactory;

    public ReportingTaskDependencyUsageTracker(@NotNull ProjectInternal referrer, @NotNull CoupledProjectsListener coupledProjectsListener, @NotNull ProblemsListener problems, @NotNull ProblemFactory problemFactory) {
        Intrinsics.checkNotNullParameter((Object)referrer, (String)"referrer");
        Intrinsics.checkNotNullParameter((Object)coupledProjectsListener, (String)"coupledProjectsListener");
        Intrinsics.checkNotNullParameter((Object)problems, (String)"problems");
        Intrinsics.checkNotNullParameter((Object)problemFactory, (String)"problemFactory");
        this.referrer = referrer;
        this.coupledProjectsListener = coupledProjectsListener;
        this.problems = problems;
        this.problemFactory = problemFactory;
    }

    public void onTaskDependencyUsage(@NotNull Set<? extends Task> taskDependencies) {
        Intrinsics.checkNotNullParameter(taskDependencies, (String)"taskDependencies");
        this.checkForCoupledProjects(taskDependencies);
        this.reportProjectIsolationProblemOnApiUsage();
    }

    private final void checkForCoupledProjects(Set<? extends Task> taskDependencies) {
        Iterable $this$forEach$iv = taskDependencies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Task task = (Task)element$iv;
            boolean bl = false;
            Project project = task.getProject();
            Intrinsics.checkNotNull((Object)project, (String)"null cannot be cast to non-null type org.gradle.api.internal.project.ProjectInternal");
            ProjectInternal otherProject = (ProjectInternal)project;
            ProjectState projectState = this.referrer.getOwner();
            Intrinsics.checkNotNullExpressionValue((Object)projectState, (String)"referrer.owner");
            ProjectState projectState2 = otherProject.getOwner();
            Intrinsics.checkNotNullExpressionValue((Object)projectState2, (String)"otherProject.owner");
            this.coupledProjectsListener.onProjectReference(projectState, projectState2);
        }
    }

    private final void reportProjectIsolationProblemOnApiUsage() {
        PropertyProblem problem2 = ProblemFactory.DefaultImpls.problem$default(this.problemFactory, null, (Function1)new Function1<StructuredMessage.Builder, Unit>(this){
            final /* synthetic */ ReportingTaskDependencyUsageTracker this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull StructuredMessage.Builder $this$problem) {
                Intrinsics.checkNotNullParameter((Object)$this$problem, (String)"$this$problem");
                $this$problem.text("Project ");
                String string2 = ReportingTaskDependencyUsageTracker.access$getReferrer$p(this.this$0).getIdentityPath().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"referrer.identityPath.toString()");
                $this$problem.reference(string2);
                $this$problem.text(" cannot access task dependencies directly");
            }
        }, 1, null).exception().build();
        this.problems.onProblem(problem2);
    }

    public static final /* synthetic */ ProjectInternal access$getReferrer$p(ReportingTaskDependencyUsageTracker $this) {
        return $this.referrer;
    }
}

