/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;

public class WithSideEffectProvider<T>
extends AbstractMinimalProvider<T> {
    private final ProviderInternal<T> provider;
    private final ValueSupplier.SideEffect<? super T> sideEffect;

    public static <T> ProviderInternal<T> of(ProviderInternal<T> provider, @Nullable ValueSupplier.SideEffect<? super T> sideEffect) {
        return sideEffect == null ? provider : new WithSideEffectProvider<T>(provider, sideEffect);
    }

    private WithSideEffectProvider(ProviderInternal<T> provider, ValueSupplier.SideEffect<? super T> sideEffect) {
        this.provider = provider;
        this.sideEffect = sideEffect;
    }

    @Override
    @Nullable
    public Class<T> getType() {
        return this.provider.getType();
    }

    @Override
    public ValueSupplier.ValueProducer getProducer() {
        return this.provider.getProducer();
    }

    @Override
    public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
        return this.provider.calculatePresence(consumer);
    }

    @Override
    protected ValueSupplier.Value<? extends T> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
        return this.provider.calculateValue(consumer).withSideEffect(this.sideEffect);
    }

    @Override
    public ValueSupplier.ExecutionTimeValue<? extends T> calculateExecutionTimeValue() {
        return this.provider.calculateExecutionTimeValue().withSideEffect(this.sideEffect);
    }

    @Override
    public ProviderInternal<T> withSideEffect(@Nullable ValueSupplier.SideEffect<? super T> sideEffect) {
        if (sideEffect == null) {
            return this;
        }
        return WithSideEffectProvider.of(this.provider, ValueSupplier.SideEffect.composite(this.sideEffect, sideEffect));
    }

    @Override
    public String toString() {
        return "" + this.provider + " (with side effect " + this.sideEffect + ")";
    }
}

