/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.ProductionType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.util.test.FreeColTestCase;

public class ProductionTypeTest
extends FreeColTestCase {
    private static final Specification s = ProductionTypeTest.spec("classic");
    private static final BuildingType armory = s.getBuildingType("model.building.armory");
    private static final BuildingType arsenal = s.getBuildingType("model.building.arsenal");
    private static final BuildingType blacksmithHouse = s.getBuildingType("model.building.blacksmithHouse");
    private static final BuildingType blacksmithShop = s.getBuildingType("model.building.blacksmithShop");
    private static final BuildingType carpenterHouse = s.getBuildingType("model.building.carpenterHouse");
    private static final BuildingType cathedral = s.getBuildingType("model.building.cathedral");
    private static final BuildingType chapel = s.getBuildingType("model.building.chapel");
    private static final BuildingType church = s.getBuildingType("model.building.church");
    private static final BuildingType cigarFactory = s.getBuildingType("model.building.cigarFactory");
    private static final BuildingType college = s.getBuildingType("model.building.college");
    private static final BuildingType country = s.getBuildingType("model.building.country");
    private static final BuildingType customHouse = s.getBuildingType("model.building.customHouse");
    private static final BuildingType depot = s.getBuildingType("model.building.depot");
    private static final BuildingType distillerHouse = s.getBuildingType("model.building.distillerHouse");
    private static final BuildingType docks = s.getBuildingType("model.building.docks");
    private static final BuildingType drydock = s.getBuildingType("model.building.drydock");
    private static final BuildingType fort = s.getBuildingType("model.building.fort");
    private static final BuildingType fortress = s.getBuildingType("model.building.fortress");
    private static final BuildingType furFactory = s.getBuildingType("model.building.furFactory");
    private static final BuildingType furTraderHouse = s.getBuildingType("model.building.furTraderHouse");
    private static final BuildingType furTradingPost = s.getBuildingType("model.building.furTradingPost");
    private static final BuildingType ironWorks = s.getBuildingType("model.building.ironWorks");
    private static final BuildingType lumberMill = s.getBuildingType("model.building.lumberMill");
    private static final BuildingType magazine = s.getBuildingType("model.building.magazine");
    private static final BuildingType newspaper = s.getBuildingType("model.building.newspaper");
    private static final BuildingType printingPress = s.getBuildingType("model.building.printingPress");
    private static final BuildingType rumDistillery = s.getBuildingType("model.building.rumDistillery");
    private static final BuildingType rumFactory = s.getBuildingType("model.building.rumFactory");
    private static final BuildingType schoolhouse = s.getBuildingType("model.building.schoolhouse");
    private static final BuildingType shipyard = s.getBuildingType("model.building.shipyard");
    private static final BuildingType stables = s.getBuildingType("model.building.stables");
    private static final BuildingType stockade = s.getBuildingType("model.building.stockade");
    private static final BuildingType textileMill = s.getBuildingType("model.building.textileMill");
    private static final BuildingType tobacconistHouse = s.getBuildingType("model.building.tobacconistHouse");
    private static final BuildingType tobacconistShop = s.getBuildingType("model.building.tobacconistShop");
    private static final BuildingType townHall = s.getBuildingType("model.building.townHall");
    private static final BuildingType university = s.getBuildingType("model.building.university");
    private static final BuildingType warehouse = s.getBuildingType("model.building.warehouse");
    private static final BuildingType warehouseExpansion = s.getBuildingType("model.building.warehouseExpansion");
    private static final BuildingType weaverHouse = s.getBuildingType("model.building.weaverHouse");
    private static final BuildingType weaverShop = s.getBuildingType("model.building.weaverShop");
    private static final GoodsType bells = s.getGoodsType("model.goods.bells");
    private static final GoodsType cigars = s.getGoodsType("model.goods.cigars");
    private static final GoodsType cloth = s.getGoodsType("model.goods.cloth");
    private static final GoodsType coats = s.getGoodsType("model.goods.coats");
    private static final GoodsType cotton = s.getGoodsType("model.goods.cotton");
    private static final GoodsType crosses = s.getGoodsType("model.goods.crosses");
    private static final GoodsType fish = s.getGoodsType("model.goods.fish");
    private static final GoodsType food = s.getGoodsType("model.goods.food");
    private static final GoodsType furs = s.getGoodsType("model.goods.furs");
    private static final GoodsType grain = s.getGoodsType("model.goods.grain");
    private static final GoodsType hammers = s.getGoodsType("model.goods.hammers");
    private static final GoodsType horses = s.getGoodsType("model.goods.horses");
    private static final GoodsType lumber = s.getGoodsType("model.goods.lumber");
    private static final GoodsType muskets = s.getGoodsType("model.goods.muskets");
    private static final GoodsType ore = s.getGoodsType("model.goods.ore");
    private static final GoodsType rum = s.getGoodsType("model.goods.rum");
    private static final GoodsType tobacco = s.getGoodsType("model.goods.tobacco");
    private static final GoodsType tools = s.getGoodsType("model.goods.tools");
    private static final GoodsType silver = s.getGoodsType("model.goods.silver");
    private static final GoodsType sugar = s.getGoodsType("model.goods.sugar");
    private static final TileType arctic = s.getTileType("model.tile.arctic");
    private static final TileType borealForest = s.getTileType("model.tile.borealForest");
    private static final TileType broadleafForest = s.getTileType("model.tile.broadleafForest");
    private static final TileType coniferForest = s.getTileType("model.tile.coniferForest");
    private static final TileType desert = s.getTileType("model.tile.desert");
    private static final TileType grassland = s.getTileType("model.tile.grassland");
    private static final TileType greatRiver = s.getTileType("model.tile.greatRiver");
    private static final TileType highSeas = s.getTileType("model.tile.highSeas");
    private static final TileType hills = s.getTileType("model.tile.hills");
    private static final TileType lake = s.getTileType("model.tile.lake");
    private static final TileType marsh = s.getTileType("model.tile.marsh");
    private static final TileType mixedForest = s.getTileType("model.tile.mixedForest");
    private static final TileType mountains = s.getTileType("model.tile.mountains");
    private static final TileType ocean = s.getTileType("model.tile.ocean");
    private static final TileType plains = s.getTileType("model.tile.plains");
    private static final TileType prairie = s.getTileType("model.tile.prairie");
    private static final TileType rainForest = s.getTileType("model.tile.rainForest");
    private static final TileType savannah = s.getTileType("model.tile.savannah");
    private static final TileType scrubForest = s.getTileType("model.tile.scrubForest");
    private static final TileType swamp = s.getTileType("model.tile.swamp");
    private static final TileType tropicalForest = s.getTileType("model.tile.tropicalForest");
    private static final TileType tundra = s.getTileType("model.tile.tundra");
    private static final TileType wetlandForest = s.getTileType("model.tile.wetlandForest");
    private static final UnitType colonistType = s.getDefaultUnitType();
    private Map<GoodsType, Integer> inputs = new HashMap<GoodsType, Integer>();
    private Map<GoodsType, Integer> outputs = new HashMap<GoodsType, Integer>();

    private void testProduction(Map<GoodsType, Integer> inputs, Map<GoodsType, Integer> outputs, List<ProductionType> productionTypes) {
        for (ProductionType productionType : productionTypes) {
            Integer i;
            for (AbstractGoods ag : CollectionUtils.toList(productionType.getInputs())) {
                i = inputs.get(ag.getType());
                ProductionTypeTest.assertNotNull((String)("Input expected for " + ag.getType()), (Object)i);
                ProductionTypeTest.assertEquals((String)("Input amount mismatch for " + ag.getType()), (int)i, (int)ag.getAmount());
                inputs.remove(ag.getType());
            }
            for (AbstractGoods ag : CollectionUtils.toList(productionType.getOutputs())) {
                i = outputs.get(ag.getType());
                ProductionTypeTest.assertNotNull((String)("Output expected for " + ag.getType()), (Object)i);
                ProductionTypeTest.assertEquals((String)("Output amount mismatch for " + ag.getType()), (int)i, (int)ag.getAmount());
                outputs.remove(ag.getType());
            }
        }
        ProductionTypeTest.assertEquals((String)"Input remaining", (int)0, (int)inputs.size());
        ProductionTypeTest.assertEquals((String)"Output remaining", (int)0, (int)outputs.size());
    }

    private int getGenericPotential(TileType tileType, GoodsType goodsType) {
        return tileType.getPotentialProduction(goodsType, colonistType);
    }

    public void testArctic() {
        this.outputs.put(grain, 2);
        this.testProduction(this.inputs, this.outputs, arctic.getAvailableProductionTypes(true, "veryHigh"));
        this.testProduction(this.inputs, this.outputs, arctic.getAvailableProductionTypes(false, "veryHigh"));
        this.outputs.put(grain, 1);
        this.testProduction(this.inputs, this.outputs, arctic.getAvailableProductionTypes(true, "high"));
        this.testProduction(this.inputs, this.outputs, arctic.getAvailableProductionTypes(false, "high"));
        for (String level : new String[]{"medium", "low", "veryLow"}) {
            this.testProduction(this.inputs, this.outputs, arctic.getAvailableProductionTypes(true, level));
            this.testProduction(this.inputs, this.outputs, arctic.getAvailableProductionTypes(false, level));
        }
        ProductionTypeTest.assertEquals((int)0, (int)arctic.getPotentialProduction(grain, null));
        ProductionTypeTest.assertEquals((int)0, (int)this.getGenericPotential(arctic, grain));
    }

    public void testBorealForest() {
        this.outputs.put(grain, 2);
        this.outputs.put(furs, 3);
        this.testProduction(this.inputs, this.outputs, borealForest.getAvailableProductionTypes(true));
        this.outputs.put(grain, 2);
        this.outputs.put(furs, 3);
        this.outputs.put(lumber, 4);
        this.outputs.put(ore, 1);
        this.testProduction(this.inputs, this.outputs, borealForest.getAvailableProductionTypes(false));
        ProductionTypeTest.assertEquals((int)2, (int)borealForest.getPotentialProduction(grain, null));
        ProductionTypeTest.assertEquals((int)2, (int)this.getGenericPotential(borealForest, grain));
    }

    public void testBroadleafForest() {
        this.outputs.put(grain, 2);
        this.outputs.put(furs, 2);
        this.testProduction(this.inputs, this.outputs, broadleafForest.getAvailableProductionTypes(true));
        this.outputs.put(grain, 2);
        this.outputs.put(cotton, 1);
        this.outputs.put(furs, 2);
        this.outputs.put(lumber, 4);
        this.testProduction(this.inputs, this.outputs, broadleafForest.getAvailableProductionTypes(false));
        ProductionTypeTest.assertEquals((int)2, (int)broadleafForest.getPotentialProduction(grain, null));
        ProductionTypeTest.assertEquals((int)2, (int)this.getGenericPotential(broadleafForest, grain));
    }

    public void testConiferForest() {
        this.outputs.put(grain, 2);
        this.outputs.put(furs, 2);
        this.testProduction(this.inputs, this.outputs, coniferForest.getAvailableProductionTypes(true));
        this.outputs.put(grain, 2);
        this.outputs.put(tobacco, 1);
        this.outputs.put(furs, 2);
        this.outputs.put(lumber, 6);
        this.testProduction(this.inputs, this.outputs, coniferForest.getAvailableProductionTypes(false));
        ProductionTypeTest.assertEquals((int)2, (int)coniferForest.getPotentialProduction(grain, null));
        ProductionTypeTest.assertEquals((int)2, (int)this.getGenericPotential(coniferForest, grain));
    }

    public void testDesert() {
        this.outputs.put(grain, 2);
        this.outputs.put(ore, 2);
        this.testProduction(this.inputs, this.outputs, desert.getAvailableProductionTypes(true, "veryHigh"));
        this.outputs.put(grain, 1);
        this.outputs.put(ore, 2);
        this.testProduction(this.inputs, this.outputs, desert.getAvailableProductionTypes(true));
        this.outputs.put(grain, 1);
        this.outputs.put(ore, 2);
        this.testProduction(this.inputs, this.outputs, desert.getAvailableProductionTypes(true, "veryLow"));
        this.outputs.put(grain, 2);
        this.outputs.put(cotton, 1);
        this.outputs.put(ore, 2);
        this.testProduction(this.inputs, this.outputs, desert.getAvailableProductionTypes(false));
        ProductionTypeTest.assertEquals((int)1, (int)desert.getPotentialProduction(grain, null));
        ProductionTypeTest.assertEquals((int)2, (int)this.getGenericPotential(desert, grain));
    }

    public void testGrassland() {
        this.outputs.put(grain, 3);
        this.outputs.put(tobacco, 3);
        this.testProduction(this.inputs, this.outputs, grassland.getAvailableProductionTypes(true));
        this.outputs.put(grain, 3);
        this.outputs.put(tobacco, 3);
        this.testProduction(this.inputs, this.outputs, grassland.getAvailableProductionTypes(false));
        ProductionTypeTest.assertEquals((int)3, (int)grassland.getPotentialProduction(grain, null));
        ProductionTypeTest.assertEquals((int)3, (int)this.getGenericPotential(grassland, grain));
    }

    public void testGreatRiver() {
        this.testProduction(this.inputs, this.outputs, greatRiver.getAvailableProductionTypes(true));
        this.outputs.put(fish, 2);
        this.testProduction(this.inputs, this.outputs, greatRiver.getAvailableProductionTypes(false));
        ProductionTypeTest.assertEquals((int)0, (int)greatRiver.getPotentialProduction(grain, null));
        ProductionTypeTest.assertEquals((int)0, (int)this.getGenericPotential(greatRiver, grain));
    }

    public void testHighSeas() {
        this.testProduction(this.inputs, this.outputs, highSeas.getAvailableProductionTypes(true));
        this.outputs.put(fish, 2);
        this.testProduction(this.inputs, this.outputs, highSeas.getAvailableProductionTypes(false));
        ProductionTypeTest.assertEquals((int)0, (int)highSeas.getPotentialProduction(grain, null));
        ProductionTypeTest.assertEquals((int)0, (int)this.getGenericPotential(highSeas, grain));
    }

    public void testHills() {
        this.outputs.put(grain, 2);
        this.outputs.put(ore, 4);
        this.testProduction(this.inputs, this.outputs, hills.getAvailableProductionTypes(true));
        this.outputs.put(grain, 2);
        this.outputs.put(ore, 4);
        this.testProduction(this.inputs, this.outputs, hills.getAvailableProductionTypes(false));
        ProductionTypeTest.assertEquals((int)2, (int)hills.getPotentialProduction(grain, null));
        ProductionTypeTest.assertEquals((int)2, (int)this.getGenericPotential(hills, grain));
    }

    public void testLake() {
        this.testProduction(this.inputs, this.outputs, lake.getAvailableProductionTypes(true));
        this.outputs.put(fish, 2);
        this.testProduction(this.inputs, this.outputs, lake.getAvailableProductionTypes(false));
        ProductionTypeTest.assertEquals((int)0, (int)lake.getPotentialProduction(grain, null));
        ProductionTypeTest.assertEquals((int)0, (int)this.getGenericPotential(lake, grain));
    }

    public void testMarsh() {
        this.outputs.put(grain, 3);
        this.outputs.put(tobacco, 2);
        this.testProduction(this.inputs, this.outputs, marsh.getAvailableProductionTypes(true));
        this.outputs.put(grain, 3);
        this.outputs.put(tobacco, 2);
        this.outputs.put(ore, 2);
        this.outputs.put(silver, 0);
        this.testProduction(this.inputs, this.outputs, marsh.getAvailableProductionTypes(false));
        ProductionTypeTest.assertEquals((int)3, (int)marsh.getPotentialProduction(grain, null));
        ProductionTypeTest.assertEquals((int)3, (int)this.getGenericPotential(marsh, grain));
    }

    public void testMixedForest() {
        this.outputs.put(grain, 2);
        this.outputs.put(furs, 3);
        this.testProduction(this.inputs, this.outputs, mixedForest.getAvailableProductionTypes(true));
        this.outputs.put(grain, 3);
        this.outputs.put(cotton, 1);
        this.outputs.put(furs, 3);
        this.outputs.put(lumber, 6);
        this.testProduction(this.inputs, this.outputs, mixedForest.getAvailableProductionTypes(false));
        ProductionTypeTest.assertEquals((int)2, (int)mixedForest.getPotentialProduction(grain, null));
        ProductionTypeTest.assertEquals((int)3, (int)this.getGenericPotential(mixedForest, grain));
    }

    public void testMountains() {
        this.testProduction(this.inputs, this.outputs, mountains.getAvailableProductionTypes(true));
        this.outputs.put(ore, 4);
        this.outputs.put(silver, 1);
        this.testProduction(this.inputs, this.outputs, mountains.getAvailableProductionTypes(false));
        ProductionTypeTest.assertEquals((int)0, (int)mountains.getPotentialProduction(grain, null));
        ProductionTypeTest.assertEquals((int)0, (int)this.getGenericPotential(mountains, grain));
    }

    public void testOcean() {
        this.testProduction(this.inputs, this.outputs, ocean.getAvailableProductionTypes(true));
        this.outputs.put(fish, 2);
        this.testProduction(this.inputs, this.outputs, ocean.getAvailableProductionTypes(false));
        ProductionTypeTest.assertEquals((int)0, (int)ocean.getPotentialProduction(grain, null));
        ProductionTypeTest.assertEquals((int)0, (int)this.getGenericPotential(ocean, grain));
    }

    public void testPlains() {
        this.outputs.put(grain, 3);
        this.outputs.put(cotton, 2);
        this.testProduction(this.inputs, this.outputs, plains.getAvailableProductionTypes(true));
        this.outputs.put(grain, 5);
        this.outputs.put(cotton, 2);
        this.outputs.put(ore, 1);
        this.testProduction(this.inputs, this.outputs, plains.getAvailableProductionTypes(false));
        ProductionTypeTest.assertEquals((int)3, (int)plains.getPotentialProduction(grain, null));
        ProductionTypeTest.assertEquals((int)5, (int)this.getGenericPotential(plains, grain));
    }

    public void testPrairie() {
        this.outputs.put(grain, 3);
        this.outputs.put(cotton, 3);
        this.testProduction(this.inputs, this.outputs, prairie.getAvailableProductionTypes(true));
        this.outputs.put(grain, 3);
        this.outputs.put(cotton, 3);
        this.testProduction(this.inputs, this.outputs, prairie.getAvailableProductionTypes(false));
        ProductionTypeTest.assertEquals((int)3, (int)prairie.getPotentialProduction(grain, null));
        ProductionTypeTest.assertEquals((int)3, (int)this.getGenericPotential(prairie, grain));
    }

    public void testRainForest() {
        this.outputs.put(grain, 2);
        this.outputs.put(sugar, 1);
        this.testProduction(this.inputs, this.outputs, rainForest.getAvailableProductionTypes(true));
        this.outputs.put(grain, 2);
        this.outputs.put(sugar, 1);
        this.outputs.put(furs, 1);
        this.outputs.put(lumber, 4);
        this.outputs.put(ore, 1);
        this.outputs.put(silver, 0);
        this.testProduction(this.inputs, this.outputs, rainForest.getAvailableProductionTypes(false));
        ProductionTypeTest.assertEquals((int)2, (int)rainForest.getPotentialProduction(grain, null));
        ProductionTypeTest.assertEquals((int)2, (int)this.getGenericPotential(rainForest, grain));
    }

    public void testSavannah() {
        this.outputs.put(grain, 3);
        this.outputs.put(sugar, 3);
        this.testProduction(this.inputs, this.outputs, savannah.getAvailableProductionTypes(true));
        this.outputs.put(grain, 4);
        this.outputs.put(sugar, 3);
        this.testProduction(this.inputs, this.outputs, savannah.getAvailableProductionTypes(false));
        ProductionTypeTest.assertEquals((int)3, (int)savannah.getPotentialProduction(grain, null));
        ProductionTypeTest.assertEquals((int)4, (int)this.getGenericPotential(savannah, grain));
    }

    public void testScrubForest() {
        this.outputs.put(grain, 2);
        this.outputs.put(furs, 2);
        this.testProduction(this.inputs, this.outputs, scrubForest.getAvailableProductionTypes(true, "veryHigh"));
        this.outputs.put(grain, 1);
        this.outputs.put(furs, 2);
        this.testProduction(this.inputs, this.outputs, scrubForest.getAvailableProductionTypes(true));
        this.outputs.put(grain, 1);
        this.outputs.put(furs, 2);
        this.testProduction(this.inputs, this.outputs, scrubForest.getAvailableProductionTypes(true, "veryLow"));
        this.outputs.put(grain, 2);
        this.outputs.put(cotton, 1);
        this.outputs.put(furs, 2);
        this.outputs.put(lumber, 2);
        this.outputs.put(ore, 1);
        this.testProduction(this.inputs, this.outputs, scrubForest.getAvailableProductionTypes(false));
        ProductionTypeTest.assertEquals((int)1, (int)scrubForest.getPotentialProduction(grain, null));
        ProductionTypeTest.assertEquals((int)2, (int)this.getGenericPotential(scrubForest, grain));
    }

    public void testSwamp() {
        this.outputs.put(grain, 3);
        this.outputs.put(sugar, 2);
        this.testProduction(this.inputs, this.outputs, swamp.getAvailableProductionTypes(true));
        this.outputs.put(grain, 3);
        this.outputs.put(sugar, 2);
        this.outputs.put(ore, 2);
        this.outputs.put(silver, 0);
        this.testProduction(this.inputs, this.outputs, swamp.getAvailableProductionTypes(false));
        ProductionTypeTest.assertEquals((int)3, (int)swamp.getPotentialProduction(grain, null));
        ProductionTypeTest.assertEquals((int)3, (int)this.getGenericPotential(swamp, grain));
    }

    public void testTropicalForest() {
        this.outputs.put(grain, 2);
        this.outputs.put(furs, 2);
        this.testProduction(this.inputs, this.outputs, tropicalForest.getAvailableProductionTypes(true));
        this.outputs.put(grain, 3);
        this.outputs.put(sugar, 1);
        this.outputs.put(furs, 2);
        this.outputs.put(lumber, 4);
        this.testProduction(this.inputs, this.outputs, tropicalForest.getAvailableProductionTypes(false));
        ProductionTypeTest.assertEquals((int)2, (int)tropicalForest.getPotentialProduction(grain, null));
        ProductionTypeTest.assertEquals((int)3, (int)this.getGenericPotential(tropicalForest, grain));
    }

    public void testTundra() {
        this.outputs.put(grain, 3);
        this.outputs.put(ore, 2);
        this.testProduction(this.inputs, this.outputs, tundra.getAvailableProductionTypes(true));
        this.outputs.put(grain, 3);
        this.outputs.put(ore, 2);
        this.outputs.put(silver, 0);
        this.testProduction(this.inputs, this.outputs, tundra.getAvailableProductionTypes(false));
        ProductionTypeTest.assertEquals((int)3, (int)tundra.getPotentialProduction(grain, null));
        ProductionTypeTest.assertEquals((int)3, (int)this.getGenericPotential(tundra, grain));
    }

    public void testWetlandForest() {
        this.outputs.put(grain, 2);
        this.outputs.put(furs, 2);
        this.testProduction(this.inputs, this.outputs, wetlandForest.getAvailableProductionTypes(true));
        this.outputs.put(grain, 2);
        this.outputs.put(tobacco, 1);
        this.outputs.put(furs, 2);
        this.outputs.put(lumber, 4);
        this.outputs.put(ore, 1);
        this.outputs.put(silver, 0);
        this.testProduction(this.inputs, this.outputs, wetlandForest.getAvailableProductionTypes(false));
        ProductionTypeTest.assertEquals((int)2, (int)wetlandForest.getPotentialProduction(grain, null));
        ProductionTypeTest.assertEquals((int)2, (int)this.getGenericPotential(wetlandForest, grain));
    }

    public void testBellProduction() {
        this.outputs.put(bells, 1);
        this.testProduction(this.inputs, this.outputs, townHall.getAvailableProductionTypes(true));
        this.outputs.put(bells, 3);
        this.testProduction(this.inputs, this.outputs, townHall.getAvailableProductionTypes(false));
    }

    public void testHammerProduction() {
        this.testProduction(this.inputs, this.outputs, carpenterHouse.getAvailableProductionTypes(true));
        this.inputs.put(lumber, 3);
        this.outputs.put(hammers, 3);
        this.testProduction(this.inputs, this.outputs, carpenterHouse.getAvailableProductionTypes(false));
        this.testProduction(this.inputs, this.outputs, lumberMill.getAvailableProductionTypes(true));
        this.inputs.put(lumber, 6);
        this.outputs.put(hammers, 6);
        this.testProduction(this.inputs, this.outputs, lumberMill.getAvailableProductionTypes(false));
    }

    public void testToolsProduction() {
        this.testProduction(this.inputs, this.outputs, blacksmithHouse.getAvailableProductionTypes(true));
        this.inputs.put(ore, 3);
        this.outputs.put(tools, 3);
        this.testProduction(this.inputs, this.outputs, blacksmithHouse.getAvailableProductionTypes(false));
        this.testProduction(this.inputs, this.outputs, blacksmithShop.getAvailableProductionTypes(true));
        this.inputs.put(ore, 6);
        this.outputs.put(tools, 6);
        this.testProduction(this.inputs, this.outputs, blacksmithShop.getAvailableProductionTypes(false));
        this.testProduction(this.inputs, this.outputs, ironWorks.getAvailableProductionTypes(true));
        this.inputs.put(ore, 6);
        this.outputs.put(tools, 9);
        this.testProduction(this.inputs, this.outputs, ironWorks.getAvailableProductionTypes(false));
    }

    public void testCigarProduction() {
        this.testProduction(this.inputs, this.outputs, tobacconistHouse.getAvailableProductionTypes(true));
        this.inputs.put(tobacco, 3);
        this.outputs.put(cigars, 3);
        this.testProduction(this.inputs, this.outputs, tobacconistHouse.getAvailableProductionTypes(false));
        this.testProduction(this.inputs, this.outputs, tobacconistShop.getAvailableProductionTypes(true));
        this.inputs.put(tobacco, 6);
        this.outputs.put(cigars, 6);
        this.testProduction(this.inputs, this.outputs, tobacconistShop.getAvailableProductionTypes(false));
        this.testProduction(this.inputs, this.outputs, cigarFactory.getAvailableProductionTypes(true));
        this.inputs.put(tobacco, 6);
        this.outputs.put(cigars, 9);
        this.testProduction(this.inputs, this.outputs, cigarFactory.getAvailableProductionTypes(false));
    }

    public void testClothProduction() {
        this.testProduction(this.inputs, this.outputs, weaverHouse.getAvailableProductionTypes(true));
        this.inputs.put(cotton, 3);
        this.outputs.put(cloth, 3);
        this.testProduction(this.inputs, this.outputs, weaverHouse.getAvailableProductionTypes(false));
        this.testProduction(this.inputs, this.outputs, weaverShop.getAvailableProductionTypes(true));
        this.inputs.put(cotton, 6);
        this.outputs.put(cloth, 6);
        this.testProduction(this.inputs, this.outputs, weaverShop.getAvailableProductionTypes(false));
        this.testProduction(this.inputs, this.outputs, textileMill.getAvailableProductionTypes(true));
        this.inputs.put(cotton, 6);
        this.outputs.put(cloth, 9);
        this.testProduction(this.inputs, this.outputs, textileMill.getAvailableProductionTypes(false));
    }

    public void testRumProduction() {
        this.testProduction(this.inputs, this.outputs, distillerHouse.getAvailableProductionTypes(true));
        this.inputs.put(sugar, 3);
        this.outputs.put(rum, 3);
        this.testProduction(this.inputs, this.outputs, distillerHouse.getAvailableProductionTypes(false));
        this.testProduction(this.inputs, this.outputs, rumDistillery.getAvailableProductionTypes(true));
        this.inputs.put(sugar, 6);
        this.outputs.put(rum, 6);
        this.testProduction(this.inputs, this.outputs, rumDistillery.getAvailableProductionTypes(false));
        this.testProduction(this.inputs, this.outputs, rumFactory.getAvailableProductionTypes(true));
        this.inputs.put(sugar, 6);
        this.outputs.put(rum, 9);
        this.testProduction(this.inputs, this.outputs, rumFactory.getAvailableProductionTypes(false));
    }

    public void testCoatProduction() {
        this.testProduction(this.inputs, this.outputs, furTraderHouse.getAvailableProductionTypes(true));
        this.inputs.put(furs, 3);
        this.outputs.put(coats, 3);
        this.testProduction(this.inputs, this.outputs, furTraderHouse.getAvailableProductionTypes(false));
        this.testProduction(this.inputs, this.outputs, furTradingPost.getAvailableProductionTypes(true));
        this.inputs.put(furs, 6);
        this.outputs.put(coats, 6);
        this.testProduction(this.inputs, this.outputs, furTradingPost.getAvailableProductionTypes(false));
        this.testProduction(this.inputs, this.outputs, furFactory.getAvailableProductionTypes(true));
        this.inputs.put(furs, 6);
        this.outputs.put(coats, 9);
        this.testProduction(this.inputs, this.outputs, furFactory.getAvailableProductionTypes(false));
    }

    public void testMusketProduction() {
        this.testProduction(this.inputs, this.outputs, armory.getAvailableProductionTypes(true));
        this.inputs.put(tools, 3);
        this.outputs.put(muskets, 3);
        this.testProduction(this.inputs, this.outputs, armory.getAvailableProductionTypes(false));
        this.testProduction(this.inputs, this.outputs, magazine.getAvailableProductionTypes(true));
        this.inputs.put(tools, 6);
        this.outputs.put(muskets, 6);
        this.testProduction(this.inputs, this.outputs, magazine.getAvailableProductionTypes(false));
        this.testProduction(this.inputs, this.outputs, arsenal.getAvailableProductionTypes(true));
        this.inputs.put(tools, 9);
        this.outputs.put(muskets, 9);
        this.testProduction(this.inputs, this.outputs, arsenal.getAvailableProductionTypes(false));
    }

    public void testCrossProduction() {
        this.outputs.put(crosses, 1);
        this.testProduction(this.inputs, this.outputs, chapel.getAvailableProductionTypes(true));
        this.testProduction(this.inputs, this.outputs, chapel.getAvailableProductionTypes(false));
        this.outputs.put(crosses, 2);
        this.testProduction(this.inputs, this.outputs, church.getAvailableProductionTypes(true));
        this.outputs.put(crosses, 3);
        this.testProduction(this.inputs, this.outputs, church.getAvailableProductionTypes(false));
        this.outputs.put(crosses, 3);
        this.testProduction(this.inputs, this.outputs, cathedral.getAvailableProductionTypes(true));
        this.outputs.put(crosses, 6);
        this.testProduction(this.inputs, this.outputs, cathedral.getAvailableProductionTypes(false));
    }

    public void testHorseProduction() {
        this.inputs.put(food, 1);
        this.outputs.put(horses, 1);
        this.testProduction(this.inputs, this.outputs, country.getAvailableProductionTypes(true));
        this.testProduction(this.inputs, this.outputs, country.getAvailableProductionTypes(false));
        this.inputs.put(food, 1);
        this.outputs.put(horses, 1);
        this.testProduction(this.inputs, this.outputs, stables.getAvailableProductionTypes(true));
        this.testProduction(this.inputs, this.outputs, stables.getAvailableProductionTypes(false));
    }

    public void testOtherBuildings() {
        this.inputs.clear();
        for (BuildingType b : new BuildingType[]{schoolhouse, college, university, stockade, fort, fortress, docks, drydock, shipyard, depot, warehouse, warehouseExpansion, printingPress, newspaper, customHouse}) {
            this.testProduction(this.inputs, this.outputs, b.getAvailableProductionTypes(true));
            this.testProduction(this.inputs, this.outputs, b.getAvailableProductionTypes(false));
        }
    }
}

