/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObject;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;

public class Force
extends FreeColSpecObject {
    public static final String TAG = "force";
    private final List<AbstractUnit> landUnits = new ArrayList<AbstractUnit>();
    private final List<AbstractUnit> navalUnits = new ArrayList<AbstractUnit>();
    private int spaceRequired = 0;
    private int capacity = 0;
    private static final String LAND_UNITS_TAG = "landUnits";
    private static final String NAVAL_UNITS_TAG = "navalUnits";

    public Force(Specification specification) {
        super(specification);
    }

    public Force(Specification spec, List<AbstractUnit> units, String ability) {
        this(spec);
        for (AbstractUnit au : units) {
            if (ability == null || au.getType(spec).hasAbility(ability)) {
                this.add(au);
                continue;
            }
            logger.warning("Found unit lacking required ability \"" + ability + "\": " + au);
        }
    }

    public final int getSpaceRequired() {
        return this.spaceRequired;
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public final List<AbstractUnit> getUnitList() {
        ArrayList<AbstractUnit> result = new ArrayList<AbstractUnit>();
        result.addAll(this.landUnits);
        result.addAll(this.navalUnits);
        return result;
    }

    public final void clearLandUnits() {
        this.landUnits.clear();
        this.spaceRequired = 0;
    }

    public final void clearNavalUnits() {
        this.navalUnits.clear();
        this.capacity = 0;
    }

    public final List<AbstractUnit> getLandUnitsList() {
        return AbstractUnit.deepCopy(this.landUnits);
    }

    protected void setLandUnitList(List<AbstractUnit> landUnits) {
        this.clearLandUnits();
        this.landUnits.addAll(landUnits);
    }

    public final List<AbstractUnit> getNavalUnitsList() {
        return AbstractUnit.deepCopy(this.navalUnits);
    }

    protected void setNavalUnitList(List<AbstractUnit> navalUnits) {
        this.clearNavalUnits();
        this.navalUnits.addAll(navalUnits);
    }

    public final boolean isEmpty() {
        return this.landUnits.isEmpty() && this.navalUnits.isEmpty();
    }

    public final void add(AbstractUnit au) {
        Specification spec = this.getSpecification();
        UnitType unitType = au.getType(spec);
        int n = au.getNumber();
        Predicate<AbstractUnit> matchPred = AbstractUnit.matcher(au);
        if (unitType.hasAbility("model.ability.navalUnit")) {
            AbstractUnit refUnit = CollectionUtils.find(this.navalUnits, matchPred);
            if (refUnit != null) {
                refUnit.addToNumber(n);
            } else {
                this.navalUnits.add(au);
            }
            if (unitType.canCarryUnits()) {
                this.capacity += unitType.getSpace() * n;
            }
        } else {
            AbstractUnit refUnit = CollectionUtils.find(this.landUnits, matchPred);
            if (refUnit != null) {
                refUnit.addToNumber(n);
            } else {
                this.landUnits.add(au);
            }
            this.spaceRequired += unitType.getSpaceTaken() * n;
        }
    }

    public double calculateStrength(boolean naval) {
        return AbstractUnit.calculateStrength(this.getSpecification(), naval ? this.navalUnits : this.landUnits);
    }

    public int prepareToBoard(UnitType shipType) {
        if (this.spaceRequired > this.capacity) {
            int sp;
            int more;
            if (shipType == null) {
                Specification spec = this.getSpecification();
                AbstractUnit ship0 = CollectionUtils.find(this.navalUnits, au -> au.getType(spec).getSpace() > 0);
                if (ship0 == null) {
                    return this.capacity - this.spaceRequired;
                }
                shipType = ship0.getType(spec);
            }
            if ((more = (this.spaceRequired - this.capacity) / (sp = shipType.getSpace()) + 1) > 0) {
                this.add(new AbstractUnit(shipType, "model.role.default", more));
            }
        }
        return this.capacity - this.spaceRequired;
    }

    public boolean matchAll(Force other) {
        return AbstractUnit.matchUnits(this.landUnits, other.landUnits) && AbstractUnit.matchUnits(this.navalUnits, other.navalUnits);
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        Force o = this.copyInCast(other, Force.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.setLandUnitList(o.getLandUnitsList());
        this.setNavalUnitList(o.getNavalUnitsList());
        this.spaceRequired = o.getSpaceRequired();
        this.capacity = o.getCapacity();
        return true;
    }

    @Override
    public void toXML(FreeColXMLWriter xw, String tag) throws XMLStreamException {
        xw.writeStartElement(tag);
        xw.writeStartElement(NAVAL_UNITS_TAG);
        for (AbstractUnit unit : this.navalUnits) {
            unit.toXML(xw);
        }
        xw.writeEndElement();
        xw.writeStartElement(LAND_UNITS_TAG);
        for (AbstractUnit unit : this.landUnits) {
            unit.toXML(xw);
        }
        xw.writeEndElement();
        xw.writeEndElement();
    }

    @Override
    public void readFromXML(FreeColXMLReader xr) throws XMLStreamException {
        this.clearLandUnits();
        this.clearNavalUnits();
        while (xr.moreTags()) {
            String tag = xr.getLocalName();
            if (LAND_UNITS_TAG.equals(tag)) {
                while (xr.moreTags()) {
                    this.add(new AbstractUnit(xr));
                }
                continue;
            }
            if (NAVAL_UNITS_TAG.equals(tag)) {
                while (xr.moreTags()) {
                    this.add(new AbstractUnit(xr));
                }
                continue;
            }
            logger.warning("Bogus Force tag: " + tag);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("<Force ").append(this.spaceRequired).append('/').append(this.capacity);
        for (AbstractUnit au : this.landUnits) {
            sb.append(' ').append(au);
        }
        for (AbstractUnit au : this.navalUnits) {
            sb.append(' ').append(au);
        }
        sb.append('>');
        return sb.toString();
    }
}

