/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.util.CollectionUtils;

public class EuropeanNationType
extends NationType {
    public static final String TAG = "european-nation-type";
    private static final String DEFAULT_MAP_KEY = "default";
    private static final String EXPERT_MAP_KEY = "expert";
    private boolean ref = false;
    private final Map<String, Map<String, AbstractUnit>> startingUnitMap = new HashMap<String, Map<String, AbstractUnit>>();
    private static final String EXPERT_STARTING_UNITS_TAG = "expert-starting-units";
    private static final String REF_TAG = "ref";
    private static final String ROLE_TAG = "role";
    private static final String TYPE_TAG = "type";
    private static final String UNIT_TAG = "unit";

    public EuropeanNationType(String id, Specification specification) {
        super(id, specification);
    }

    protected Map<String, Map<String, AbstractUnit>> getStartingUnitMap() {
        return this.startingUnitMap;
    }

    protected void setStartingUnitMap(Map<String, Map<String, AbstractUnit>> startingUnitMap) {
        this.startingUnitMap.clear();
        this.startingUnitMap.putAll(startingUnitMap);
    }

    private String getMapKey(boolean b) {
        return b ? EXPERT_MAP_KEY : DEFAULT_MAP_KEY;
    }

    public List<AbstractUnit> getStartingUnits() {
        boolean ex = this.getSpecification().getBoolean("model.option.expertStartingUnits");
        return this.getStartingUnits(this.getMapKey(ex));
    }

    public List<AbstractUnit> getStartingUnits(String key) {
        HashMap<String, AbstractUnit> result = new HashMap<String, AbstractUnit>();
        Map<String, AbstractUnit> defaultMap = this.startingUnitMap.get(DEFAULT_MAP_KEY);
        Map<String, AbstractUnit> difficultyMap = this.startingUnitMap.get(key);
        if (defaultMap != null) {
            result.putAll(defaultMap);
        }
        if (difficultyMap != null) {
            result.putAll(difficultyMap);
        }
        return new ArrayList<AbstractUnit>(result.values());
    }

    private void addStartingUnit(String id, AbstractUnit unit, boolean expert) {
        String mapTag = this.getMapKey(expert);
        Map<String, AbstractUnit> units = this.startingUnitMap.get(mapTag);
        if (units == null) {
            units = new HashMap<String, AbstractUnit>();
            this.startingUnitMap.put(mapTag, units);
        }
        units.put(id, unit);
    }

    @Override
    public final boolean isREF() {
        return this.ref;
    }

    @Override
    public boolean isEuropean() {
        return true;
    }

    @Override
    public boolean isIndian() {
        return false;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        EuropeanNationType o = this.copyInCast(other, EuropeanNationType.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.setStartingUnitMap(o.getStartingUnitMap());
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(REF_TAG, this.ref);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (this.startingUnitMap != null && !this.startingUnitMap.isEmpty()) {
            Map<String, AbstractUnit> map = this.startingUnitMap.get(DEFAULT_MAP_KEY);
            if (map != null) {
                for (Map.Entry<String, AbstractUnit> entry : map.entrySet()) {
                    this.writeUnit(xw, entry.getKey(), entry.getValue(), false);
                }
            }
            if ((map = this.startingUnitMap.get(EXPERT_MAP_KEY)) != null) {
                for (Map.Entry<String, AbstractUnit> entry : map.entrySet()) {
                    this.writeUnit(xw, entry.getKey(), entry.getValue(), true);
                }
            }
        }
    }

    private void writeUnit(FreeColXMLWriter xw, String id, AbstractUnit au, boolean expert) throws XMLStreamException {
        xw.writeStartElement(UNIT_TAG);
        xw.writeAttribute("id", id);
        xw.writeAttribute(TYPE_TAG, au);
        xw.writeAttribute(ROLE_TAG, au.getRoleId());
        if (expert) {
            xw.writeAttribute(EXPERT_STARTING_UNITS_TAG, expert);
        }
        xw.writeEndElement();
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        EuropeanNationType parent = xr.getType(spec, "extends", EuropeanNationType.class, this);
        this.ref = xr.getAttribute(REF_TAG, parent.ref);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec;
        EuropeanNationType parent;
        if (xr.shouldClearContainers()) {
            this.startingUnitMap.clear();
        }
        if ((parent = xr.getType(spec = this.getSpecification(), "extends", EuropeanNationType.class, this)) != this) {
            CollectionUtils.forEachMapEntry(parent.startingUnitMap, e -> this.startingUnitMap.put((String)e.getKey(), new HashMap((Map)e.getValue())));
        }
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (UNIT_TAG.equals(tag)) {
            String id = xr.readId();
            String type = xr.getAttribute(TYPE_TAG, null);
            String roleId = xr.getAttribute(ROLE_TAG, "model.role.default");
            boolean ex = xr.getAttribute(EXPERT_STARTING_UNITS_TAG, false);
            this.addStartingUnit(id, new AbstractUnit(type, roleId, 1), ex);
            xr.closeTag(UNIT_TAG);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }
}

