/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.swing.JList;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Limit;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.util.CollectionUtils;

public abstract class BuildableType
extends FreeColSpecObjectType {
    private static final int DEFAULT_REQUIRED_POPULATION = 1;
    private int requiredPopulation = 1;
    private Map<String, Boolean> requiredAbilities = null;
    private List<AbstractGoods> requiredGoods = null;
    private List<Limit> limits = null;
    private static final String REQUIRED_ABILITY_TAG = "required-ability";
    private static final String REQUIRED_GOODS_TAG = "required-goods";
    public static final String REQUIRED_POPULATION_TAG = "required-population";

    public BuildableType(String id, Specification specification) {
        super(id, specification);
    }

    public int getRequiredPopulation() {
        return this.requiredPopulation;
    }

    public void setRequiredPopulation(int newPopulation) {
        this.requiredPopulation = newPopulation;
    }

    public Map<String, Boolean> getRequiredAbilities() {
        return this.requiredAbilities == null ? Collections.emptyMap() : new HashMap<String, Boolean>(this.requiredAbilities);
    }

    public boolean requiresAbility(String key) {
        return this.requiredAbilities == null ? false : (!this.requiredAbilities.containsKey(key) ? false : this.requiredAbilities.get(key));
    }

    public void setRequiredAbilities(Map<String, Boolean> abilities) {
        this.requiredAbilities = abilities;
    }

    public void addRequiredAbility(String tag, boolean value) {
        if (this.requiredAbilities == null) {
            this.requiredAbilities = new HashMap<String, Boolean>();
        }
        this.requiredAbilities.put(tag, value);
    }

    public void removeRequiredAbility(String tag) {
        if (this.requiredAbilities != null) {
            this.requiredAbilities.remove(tag);
        }
    }

    public boolean isAvailableTo(FreeColObject ... fco) {
        return this.requiredAbilities == null ? true : CollectionUtils.all(this.requiredAbilities.entrySet(), e -> (Boolean)e.getValue() == CollectionUtils.any(fco, o -> o != null && o.hasAbility((String)e.getKey())));
    }

    public List<AbstractGoods> getRequiredGoodsList() {
        return this.requiredGoods == null ? Collections.emptyList() : CollectionUtils.transform(this.requiredGoods, CollectionUtils.alwaysTrue(), ag -> new AbstractGoods(ag.getType(), ag.getAmount()));
    }

    public Stream<AbstractGoods> getRequiredGoods() {
        return this.requiredGoods == null ? Stream.empty() : this.getRequiredGoodsList().stream();
    }

    public void setRequiredGoods(List<AbstractGoods> goods) {
        this.requiredGoods.clear();
        this.requiredGoods.addAll(goods);
    }

    public int getRequiredAmountOf(GoodsType type) {
        return AbstractGoods.getCount(type, this.getRequiredGoodsList());
    }

    private void addRequiredGoods(AbstractGoods ag) {
        if (this.requiredGoods == null) {
            this.requiredGoods = new ArrayList<AbstractGoods>();
        }
        this.requiredGoods.add(ag);
    }

    public boolean needsGoodsToBuild() {
        return this.requiredGoods != null && !this.requiredGoods.isEmpty();
    }

    public List<Limit> getLimits() {
        return this.limits == null ? Collections.emptyList() : this.limits;
    }

    public void setLimits(List<Limit> newLimits) {
        this.limits = newLimits;
    }

    private void addLimit(Limit limit) {
        if (this.limits == null) {
            this.limits = new ArrayList<Limit>();
        }
        this.limits.add(limit);
    }

    public StringTemplate getCurrentlyBuildingLabel() {
        return StringTemplate.template("model.buildableType.currentlyBuilding").addNamed("%buildable%", this);
    }

    public abstract Colony.NoBuildReason canBeBuiltInColony(Colony var1, List<BuildableType> var2);

    public int getMinimumIndex(Colony colony, JList<BuildableType> buildQueueList, int UNABLE_TO_BUILD) {
        return UNABLE_TO_BUILD;
    }

    public int getMaximumIndex(Colony colony, JList<BuildableType> buildQueueList, int UNABLE_TO_BUILD) {
        return UNABLE_TO_BUILD;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        BuildableType o = this.copyInCast(other, BuildableType.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.setRequiredPopulation(o.getRequiredPopulation());
        this.setRequiredAbilities(o.getRequiredAbilities());
        this.setRequiredGoods(o.getRequiredGoodsList());
        this.setLimits(o.getLimits());
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.requiredPopulation > 1) {
            xw.writeAttribute(REQUIRED_POPULATION_TAG, this.requiredPopulation);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (this.requiredAbilities != null) {
            for (Map.Entry entry : this.requiredAbilities.entrySet()) {
                xw.writeStartElement(REQUIRED_ABILITY_TAG);
                xw.writeAttribute("id", (String)entry.getKey());
                xw.writeAttribute("value", entry.getValue());
                xw.writeEndElement();
            }
        }
        for (AbstractGoods abstractGoods : this.getRequiredGoodsList()) {
            xw.writeStartElement(REQUIRED_GOODS_TAG);
            xw.writeAttribute("id", abstractGoods.getType());
            xw.writeAttribute("value", abstractGoods.getAmount());
            xw.writeEndElement();
        }
        for (Limit limit : this.getLimits()) {
            limit.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.requiredPopulation = xr.getAttribute(REQUIRED_POPULATION_TAG, 1);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        if (xr.shouldClearContainers()) {
            this.requiredAbilities = null;
            this.requiredGoods = null;
            this.limits = null;
        }
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (REQUIRED_ABILITY_TAG.equals(tag)) {
            String id = xr.readId();
            this.addRequiredAbility(id, xr.getAttribute("value", true));
            spec.addAbility(id);
            xr.closeTag(REQUIRED_ABILITY_TAG);
        } else if (REQUIRED_GOODS_TAG.equals(tag)) {
            GoodsType type = xr.getType(spec, "id", GoodsType.class, null);
            int amount = xr.getAttribute("value", 0);
            this.addRequiredGoods(new AbstractGoods(type, amount));
            xr.closeTag(REQUIRED_GOODS_TAG);
        } else if ("limit".equals(tag)) {
            Limit limit = new Limit(xr, spec);
            if (limit.getLeftHandSide().getType() == null) {
                limit.getLeftHandSide().setType(this.getId());
            }
            this.addLimit(limit);
        } else {
            super.readChild(xr);
        }
    }
}

