/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.label;

import java.awt.Component;
import javax.swing.JComponent;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.label.AbstractGoodsLabel;
import net.sf.freecol.client.gui.label.CargoLabel;
import net.sf.freecol.client.gui.label.Draggable;
import net.sf.freecol.client.gui.panel.CargoPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Unit;

public final class GoodsLabel
extends AbstractGoodsLabel
implements CargoLabel,
Draggable {
    public GoodsLabel(FreeColClient freeColClient, Goods goods) {
        super(freeColClient, goods);
        this.initialize();
    }

    private void initialize() {
        Goods goods = this.getGoods();
        Location location = goods.getLocation();
        Player player = location instanceof Ownable ? ((Ownable)((Object)location)).getOwner() : null;
        GoodsType type = goods.getType();
        Specification spec = goods.getGame().getSpecification();
        if (this.getAmount() < 100) {
            this.setPartialChosen(true);
        }
        this.setForeground(ImageLibrary.getGoodsColor(type, goods.getAmount(), location));
        this.setText(String.valueOf(goods.getAmount()));
        if (player == null || !type.isStorable() || player.canTrade(type) || location instanceof Colony && spec.getBoolean("model.option.customIgnoreBoycott") && ((Colony)location).hasAbility("model.ability.export")) {
            Utility.localizeToolTip((JComponent)this, goods.getLabel(true));
        } else {
            Utility.localizeToolTip((JComponent)this, goods.getLabel(false));
            this.setIcon(this.getDisabledIcon());
        }
    }

    public Goods getGoods() {
        return (Goods)this.getAbstractGoods();
    }

    @Override
    public boolean isOnCarrier() {
        Goods goods = this.getGoods();
        return goods != null && goods.getLocation() instanceof Unit;
    }

    @Override
    public boolean addCargo(Component comp, Unit carrier, CargoPanel cargoPanel) {
        Goods goods = ((GoodsLabel)comp).getGoods();
        int loadable = carrier.getLoadableAmount(goods.getType());
        if (loadable <= 0) {
            return false;
        }
        if (loadable > goods.getAmount()) {
            loadable = goods.getAmount();
        }
        Goods toAdd = new Goods(goods.getGame(), goods.getLocation(), goods.getType(), loadable);
        goods.setAmount(goods.getAmount() - loadable);
        cargoPanel.igc().loadCargo(toAdd, carrier);
        cargoPanel.update();
        return true;
    }

    @Override
    public void removeCargo(Component comp, CargoPanel cargoPanel) {
        Goods g = ((GoodsLabel)comp).getGoods();
        cargoPanel.igc().unloadCargo(g, false);
        cargoPanel.update();
    }
}

