/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.dialog;

import java.awt.Component;
import java.awt.Font;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.ModifierFormat;
import net.sf.freecol.client.gui.dialog.FreeColConfirmDialog;
import net.sf.freecol.client.gui.label.UnitLabel;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.CollectionUtils;

public class PreCombatDialog
extends FreeColConfirmDialog {
    public PreCombatDialog(FreeColClient freeColClient, JFrame frame, Unit attacker, FreeColGameObject defender) {
        super(freeColClient, frame);
        ImageLibrary lib = this.getImageLibrary();
        Game game = attacker.getGame();
        CombatModel combatModel = game.getCombatModel();
        Turn turn = game.getTurn();
        Set<Modifier> attackModifiers = combatModel.getOffensiveModifiers(attacker, defender);
        Set<Modifier> defenceModifiers = combatModel.getDefensiveModifiers(attacker, defender);
        List<Modifier> offence = CollectionUtils.sort(attackModifiers, Modifier.ascendingModifierIndexComparator);
        List<Modifier> defence = CollectionUtils.sort(defenceModifiers, Modifier.ascendingModifierIndexComparator);
        MigPanel panel = new MigPanel(new MigLayout("wrap 6", "[sg label]20[sg value, right]1px[sg percent]40[sg label]20[sg value, right]1px[sg percent]", ""));
        String attackerName = attacker.getDescription(Unit.UnitLabelType.NATIONAL);
        UnitLabel attackerLabel = new UnitLabel(freeColClient, attacker, false, true);
        String defenderName = null;
        JLabel defenderLabel = null;
        if (combatModel.combatIsAttack(attacker, defender)) {
            Unit defenderUnit = (Unit)defender;
            defenderName = defenderUnit.getDescription(Unit.UnitLabelType.NATIONAL);
            defenderLabel = new UnitLabel(freeColClient, defenderUnit, false, true);
        } else if (combatModel.combatIsSettlementAttack(attacker, defender)) {
            Settlement settlement = (Settlement)defender;
            defenderName = settlement.getName();
            defenderLabel = new JLabel(new ImageIcon(lib.getScaledSettlementImage(settlement)));
        } else {
            throw new RuntimeException("Bogus attack: " + attacker + " v " + defender);
        }
        panel.add((Component)new JLabel(attackerName), "span 3, align center");
        panel.add((Component)new JLabel(defenderName), "span 3, align center");
        panel.add((Component)attackerLabel, "span 3, align center");
        panel.add((Component)defenderLabel, "span 3, align center");
        panel.add((Component)new JSeparator(0), "newline, span 3, growx");
        panel.add((Component)new JSeparator(0), "span 3, growx");
        Iterator<Modifier> offenceI = offence.iterator();
        Iterator<Modifier> defenceI = defence.iterator();
        while (offenceI.hasNext() || defenceI.hasNext()) {
            JLabel[] labels;
            int skip = 0;
            boolean hasOffence = offenceI.hasNext();
            if (hasOffence) {
                labels = ModifierFormat.getModifierLabels(offenceI.next(), null, turn);
                skip = this.addLabels(panel, labels, true, 0);
            } else {
                skip = 3;
            }
            if (!defenceI.hasNext()) continue;
            labels = ModifierFormat.getModifierLabels(defenceI.next(), null, turn);
            this.addLabels(panel, labels, !hasOffence, skip);
        }
        Font bigFont = FontLibrary.getScaledFont("normal-bold-smaller");
        float offenceResult = FeatureContainer.applyModifiers(0.0f, turn, attackModifiers);
        JLabel finalLabel = Utility.localizedLabel("finalResult");
        finalLabel.setFont(bigFont);
        panel.add((Component)new JSeparator(0), "newline, span 3, growx");
        panel.add((Component)new JSeparator(0), "span 3, growx");
        panel.add(finalLabel);
        JLabel finalOffenceResult = new JLabel(ModifierFormat.format(offenceResult));
        finalOffenceResult.setFont(bigFont);
        panel.add(finalOffenceResult);
        float defenceResult = FeatureContainer.applyModifiers(0.0f, turn, defenceModifiers);
        panel.add((Component)finalLabel, "skip");
        JLabel finalDefenceResult = new JLabel(ModifierFormat.format(defenceResult));
        finalDefenceResult.setFont(bigFont);
        panel.add(finalDefenceResult);
        panel.setSize(panel.getPreferredSize());
        this.initializeConfirmDialog(frame, true, panel, null, "ok", "cancel");
    }

    private int addLabels(JPanel panel, JLabel[] labels, boolean newline, int skip) {
        Object constraint;
        int len = labels.length;
        for (int i = 0; i < len; ++i) {
            if (labels[i] != null) continue;
            len = i;
        }
        Object object = constraint = newline ? "newline" : null;
        if (skip > 0) {
            constraint = constraint == null ? "skip " + skip : (String)constraint + ", skip " + skip;
        }
        for (int i = 0; i < len; ++i) {
            if (constraint != null) {
                panel.add((Component)labels[i], constraint);
                constraint = null;
                continue;
            }
            panel.add(labels[i]);
        }
        return 3 - len;
    }
}

