/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.logging.Logger;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.FreeColClientHolder;
import net.sf.freecol.client.gui.Scrolling;

public final class CanvasMouseMotionListener
extends FreeColClientHolder
implements MouseMotionListener {
    private static final Logger logger = Logger.getLogger(CanvasMouseMotionListener.class.getName());
    private final Scrolling scrolling;

    public CanvasMouseMotionListener(FreeColClient freeColClient, Scrolling scrolling) {
        super(freeColClient);
        this.scrolling = scrolling;
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        this.scrolling.performAutoScrollIfActive(me);
        this.getGUI().updateGoto(me.getX(), me.getY(), false);
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if ((me.getModifiersEx() & 0x400) != 1024) {
            return;
        }
        this.scrolling.performDragScrollIfActive(me);
        this.getGUI().updateGoto(me.getX(), me.getY(), true);
    }
}

