from typing import Any, Callable, NamedTuple, Text

class Event(NamedTuple):
    time: float
    priority: Any
    action: Callable[..., Any]
    argument: tuple[Any, ...]
    kwargs: dict[Text, Any]

class scheduler:
    def __init__(self, timefunc: Callable[[], float], delayfunc: Callable[[float], None]) -> None: ...
    def enterabs(self, time: float, priority: Any, action: Callable[..., Any], argument: tuple[Any, ...]) -> Event: ...
    def enter(self, delay: float, priority: Any, action: Callable[..., Any], argument: tuple[Any, ...]) -> Event: ...
    def run(self) -> None: ...
    def cancel(self, event: Event) -> None: ...
    def empty(self) -> bool: ...
    @property
    def queue(self) -> list[Event]: ...
