/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRAbstractJavaCompiler;
import net.sf.jasperreports.engine.design.JRClassCompiler;
import net.sf.jasperreports.engine.design.JRClassGenerator;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRSaver;

public abstract class JRAbstractClassCompiler
extends JRAbstractJavaCompiler
implements JRClassCompiler {
    public JasperReport compileReport(JasperDesign jasperDesign) throws JRException {
        JasperReport jasperReport = null;
        if (!"java".equals(jasperDesign.getLanguage())) {
            throw new JRException("Language \"" + jasperDesign.getLanguage() + "\" not supported by this report compiler.\n" + "Expecting \"java\" instead.");
        }
        Collection brokenRules = JRVerifier.verifyDesign(jasperDesign);
        if (brokenRules != null && brokenRules.size() > 0) {
            StringBuffer sbuffer = new StringBuffer();
            sbuffer.append("Report design not valid : ");
            int i = 1;
            Iterator it = brokenRules.iterator();
            while (it.hasNext()) {
                sbuffer.append("\n\t " + i + ". " + (String)it.next());
                ++i;
            }
            throw new JRException(sbuffer.toString());
        }
        String sourceCode = JRClassGenerator.generateClass(jasperDesign);
        boolean isKeepJavaFile = JRProperties.getBooleanProperty("net.sf.jasperreports.compiler.keep.java.file");
        String tempDirStr = JRProperties.getProperty("net.sf.jasperreports.compiler.temp.dir");
        File tempDirFile = new File(tempDirStr);
        if (!tempDirFile.exists() || !tempDirFile.isDirectory()) {
            throw new JRException("Temporary directory not found : " + tempDirStr);
        }
        File javaFile = new File(tempDirFile, jasperDesign.getName() + ".java");
        File classFile = new File(tempDirFile, jasperDesign.getName() + ".class");
        JRSaver.saveClassSource(sourceCode, javaFile);
        String classpath = JRProperties.getProperty("net.sf.jasperreports.compiler.classpath");
        try {
            String compileErrors = this.compileClass(javaFile, classpath);
            if (compileErrors != null) {
                throw new JRException("Errors were encountered when compiling report expressions class file:\n" + compileErrors);
            }
            jasperReport = new JasperReport(jasperDesign, this.getClass().getName(), JRLoader.loadBytes(classFile));
        }
        catch (JRException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JRException("Error compiling report design.", e);
        }
        finally {
            if (!isKeepJavaFile) {
                javaFile.delete();
            }
            classFile.delete();
        }
        return jasperReport;
    }
}

