/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * degrees(-3.1415927) => -180.0
 * degrees(-1.0471976) => -60.0
 * degrees(1.0471976) => 60.0
 * degrees(3.1415927) => 180.0
 */
#version 120

void main()
{
  float[distance(degrees(-3.1415927), -180.0) <= 0.0018000001 ? 1 : -1] array0;
  float[distance(degrees(-1.0471976), -60.0) <= 0.0006 ? 1 : -1] array1;
  float[distance(degrees(1.0471976), 60.0) <= 0.0006 ? 1 : -1] array2;
  float[distance(degrees(3.1415927), 180.0) <= 0.0018000001 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
