/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoDecodeH265PictureInfoFlags;

public class StdVideoDecodeH265PictureInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VPS_VIDEO_PARAMETER_SET_ID;
    public static final int SPS_SEQ_PARAMETER_SET_ID;
    public static final int PPS_PIC_PARAMETER_SET_ID;
    public static final int NUM_SHORT_TERM_REF_PIC_SETS;
    public static final int PICORDERCNTVAL;
    public static final int NUMBITSFORSTREFPICSETINSLICE;
    public static final int NUMDELTAPOCSOFREFRPSIDX;
    public static final int REFPICSETSTCURRBEFORE;
    public static final int REFPICSETSTCURRAFTER;
    public static final int REFPICSETLTCURR;
    public static final int FLAGS;

    public StdVideoDecodeH265PictureInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), StdVideoDecodeH265PictureInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint8_t")
    public byte vps_video_parameter_set_id() {
        return StdVideoDecodeH265PictureInfo.nvps_video_parameter_set_id(this.address());
    }

    @NativeType(value="uint8_t")
    public byte sps_seq_parameter_set_id() {
        return StdVideoDecodeH265PictureInfo.nsps_seq_parameter_set_id(this.address());
    }

    @NativeType(value="uint8_t")
    public byte pps_pic_parameter_set_id() {
        return StdVideoDecodeH265PictureInfo.npps_pic_parameter_set_id(this.address());
    }

    @NativeType(value="uint8_t")
    public byte num_short_term_ref_pic_sets() {
        return StdVideoDecodeH265PictureInfo.nnum_short_term_ref_pic_sets(this.address());
    }

    @NativeType(value="int32_t")
    public int PicOrderCntVal() {
        return StdVideoDecodeH265PictureInfo.nPicOrderCntVal(this.address());
    }

    @NativeType(value="uint16_t")
    public short NumBitsForSTRefPicSetInSlice() {
        return StdVideoDecodeH265PictureInfo.nNumBitsForSTRefPicSetInSlice(this.address());
    }

    @NativeType(value="uint8_t")
    public byte NumDeltaPocsOfRefRpsIdx() {
        return StdVideoDecodeH265PictureInfo.nNumDeltaPocsOfRefRpsIdx(this.address());
    }

    @NativeType(value="uint8_t[STD_VIDEO_DECODE_H265_REF_PIC_SET_LIST_SIZE]")
    public ByteBuffer RefPicSetStCurrBefore() {
        return StdVideoDecodeH265PictureInfo.nRefPicSetStCurrBefore(this.address());
    }

    @NativeType(value="uint8_t")
    public byte RefPicSetStCurrBefore(int index) {
        return StdVideoDecodeH265PictureInfo.nRefPicSetStCurrBefore(this.address(), index);
    }

    @NativeType(value="uint8_t[STD_VIDEO_DECODE_H265_REF_PIC_SET_LIST_SIZE]")
    public ByteBuffer RefPicSetStCurrAfter() {
        return StdVideoDecodeH265PictureInfo.nRefPicSetStCurrAfter(this.address());
    }

    @NativeType(value="uint8_t")
    public byte RefPicSetStCurrAfter(int index) {
        return StdVideoDecodeH265PictureInfo.nRefPicSetStCurrAfter(this.address(), index);
    }

    @NativeType(value="uint8_t[STD_VIDEO_DECODE_H265_REF_PIC_SET_LIST_SIZE]")
    public ByteBuffer RefPicSetLtCurr() {
        return StdVideoDecodeH265PictureInfo.nRefPicSetLtCurr(this.address());
    }

    @NativeType(value="uint8_t")
    public byte RefPicSetLtCurr(int index) {
        return StdVideoDecodeH265PictureInfo.nRefPicSetLtCurr(this.address(), index);
    }

    public StdVideoDecodeH265PictureInfoFlags flags() {
        return StdVideoDecodeH265PictureInfo.nflags(this.address());
    }

    public StdVideoDecodeH265PictureInfo vps_video_parameter_set_id(@NativeType(value="uint8_t") byte value) {
        StdVideoDecodeH265PictureInfo.nvps_video_parameter_set_id(this.address(), value);
        return this;
    }

    public StdVideoDecodeH265PictureInfo sps_seq_parameter_set_id(@NativeType(value="uint8_t") byte value) {
        StdVideoDecodeH265PictureInfo.nsps_seq_parameter_set_id(this.address(), value);
        return this;
    }

    public StdVideoDecodeH265PictureInfo pps_pic_parameter_set_id(@NativeType(value="uint8_t") byte value) {
        StdVideoDecodeH265PictureInfo.npps_pic_parameter_set_id(this.address(), value);
        return this;
    }

    public StdVideoDecodeH265PictureInfo num_short_term_ref_pic_sets(@NativeType(value="uint8_t") byte value) {
        StdVideoDecodeH265PictureInfo.nnum_short_term_ref_pic_sets(this.address(), value);
        return this;
    }

    public StdVideoDecodeH265PictureInfo PicOrderCntVal(@NativeType(value="int32_t") int value) {
        StdVideoDecodeH265PictureInfo.nPicOrderCntVal(this.address(), value);
        return this;
    }

    public StdVideoDecodeH265PictureInfo NumBitsForSTRefPicSetInSlice(@NativeType(value="uint16_t") short value) {
        StdVideoDecodeH265PictureInfo.nNumBitsForSTRefPicSetInSlice(this.address(), value);
        return this;
    }

    public StdVideoDecodeH265PictureInfo NumDeltaPocsOfRefRpsIdx(@NativeType(value="uint8_t") byte value) {
        StdVideoDecodeH265PictureInfo.nNumDeltaPocsOfRefRpsIdx(this.address(), value);
        return this;
    }

    public StdVideoDecodeH265PictureInfo RefPicSetStCurrBefore(@NativeType(value="uint8_t[STD_VIDEO_DECODE_H265_REF_PIC_SET_LIST_SIZE]") ByteBuffer value) {
        StdVideoDecodeH265PictureInfo.nRefPicSetStCurrBefore(this.address(), value);
        return this;
    }

    public StdVideoDecodeH265PictureInfo RefPicSetStCurrBefore(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoDecodeH265PictureInfo.nRefPicSetStCurrBefore(this.address(), index, value);
        return this;
    }

    public StdVideoDecodeH265PictureInfo RefPicSetStCurrAfter(@NativeType(value="uint8_t[STD_VIDEO_DECODE_H265_REF_PIC_SET_LIST_SIZE]") ByteBuffer value) {
        StdVideoDecodeH265PictureInfo.nRefPicSetStCurrAfter(this.address(), value);
        return this;
    }

    public StdVideoDecodeH265PictureInfo RefPicSetStCurrAfter(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoDecodeH265PictureInfo.nRefPicSetStCurrAfter(this.address(), index, value);
        return this;
    }

    public StdVideoDecodeH265PictureInfo RefPicSetLtCurr(@NativeType(value="uint8_t[STD_VIDEO_DECODE_H265_REF_PIC_SET_LIST_SIZE]") ByteBuffer value) {
        StdVideoDecodeH265PictureInfo.nRefPicSetLtCurr(this.address(), value);
        return this;
    }

    public StdVideoDecodeH265PictureInfo RefPicSetLtCurr(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoDecodeH265PictureInfo.nRefPicSetLtCurr(this.address(), index, value);
        return this;
    }

    public StdVideoDecodeH265PictureInfo flags(StdVideoDecodeH265PictureInfoFlags value) {
        StdVideoDecodeH265PictureInfo.nflags(this.address(), value);
        return this;
    }

    public StdVideoDecodeH265PictureInfo flags(Consumer<StdVideoDecodeH265PictureInfoFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoDecodeH265PictureInfo set(byte vps_video_parameter_set_id, byte sps_seq_parameter_set_id, byte pps_pic_parameter_set_id, byte num_short_term_ref_pic_sets, int PicOrderCntVal, short NumBitsForSTRefPicSetInSlice, byte NumDeltaPocsOfRefRpsIdx, ByteBuffer RefPicSetStCurrBefore, ByteBuffer RefPicSetStCurrAfter, ByteBuffer RefPicSetLtCurr, StdVideoDecodeH265PictureInfoFlags flags) {
        this.vps_video_parameter_set_id(vps_video_parameter_set_id);
        this.sps_seq_parameter_set_id(sps_seq_parameter_set_id);
        this.pps_pic_parameter_set_id(pps_pic_parameter_set_id);
        this.num_short_term_ref_pic_sets(num_short_term_ref_pic_sets);
        this.PicOrderCntVal(PicOrderCntVal);
        this.NumBitsForSTRefPicSetInSlice(NumBitsForSTRefPicSetInSlice);
        this.NumDeltaPocsOfRefRpsIdx(NumDeltaPocsOfRefRpsIdx);
        this.RefPicSetStCurrBefore(RefPicSetStCurrBefore);
        this.RefPicSetStCurrAfter(RefPicSetStCurrAfter);
        this.RefPicSetLtCurr(RefPicSetLtCurr);
        this.flags(flags);
        return this;
    }

    public StdVideoDecodeH265PictureInfo set(StdVideoDecodeH265PictureInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static StdVideoDecodeH265PictureInfo malloc() {
        return (StdVideoDecodeH265PictureInfo)StdVideoDecodeH265PictureInfo.wrap(StdVideoDecodeH265PictureInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static StdVideoDecodeH265PictureInfo calloc() {
        return (StdVideoDecodeH265PictureInfo)StdVideoDecodeH265PictureInfo.wrap(StdVideoDecodeH265PictureInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static StdVideoDecodeH265PictureInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (StdVideoDecodeH265PictureInfo)StdVideoDecodeH265PictureInfo.wrap(StdVideoDecodeH265PictureInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static StdVideoDecodeH265PictureInfo create(long address) {
        return (StdVideoDecodeH265PictureInfo)StdVideoDecodeH265PictureInfo.wrap(StdVideoDecodeH265PictureInfo.class, (long)address);
    }

    @Nullable
    public static StdVideoDecodeH265PictureInfo createSafe(long address) {
        return address == 0L ? null : (StdVideoDecodeH265PictureInfo)StdVideoDecodeH265PictureInfo.wrap(StdVideoDecodeH265PictureInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)StdVideoDecodeH265PictureInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)StdVideoDecodeH265PictureInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)StdVideoDecodeH265PictureInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoDecodeH265PictureInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)StdVideoDecodeH265PictureInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)StdVideoDecodeH265PictureInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)StdVideoDecodeH265PictureInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static StdVideoDecodeH265PictureInfo malloc(MemoryStack stack) {
        return (StdVideoDecodeH265PictureInfo)StdVideoDecodeH265PictureInfo.wrap(StdVideoDecodeH265PictureInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static StdVideoDecodeH265PictureInfo calloc(MemoryStack stack) {
        return (StdVideoDecodeH265PictureInfo)StdVideoDecodeH265PictureInfo.wrap(StdVideoDecodeH265PictureInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)StdVideoDecodeH265PictureInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)StdVideoDecodeH265PictureInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static byte nvps_video_parameter_set_id(long struct) {
        return UNSAFE.getByte(null, struct + (long)VPS_VIDEO_PARAMETER_SET_ID);
    }

    public static byte nsps_seq_parameter_set_id(long struct) {
        return UNSAFE.getByte(null, struct + (long)SPS_SEQ_PARAMETER_SET_ID);
    }

    public static byte npps_pic_parameter_set_id(long struct) {
        return UNSAFE.getByte(null, struct + (long)PPS_PIC_PARAMETER_SET_ID);
    }

    public static byte nnum_short_term_ref_pic_sets(long struct) {
        return UNSAFE.getByte(null, struct + (long)NUM_SHORT_TERM_REF_PIC_SETS);
    }

    public static int nPicOrderCntVal(long struct) {
        return UNSAFE.getInt(null, struct + (long)PICORDERCNTVAL);
    }

    public static short nNumBitsForSTRefPicSetInSlice(long struct) {
        return UNSAFE.getShort(null, struct + (long)NUMBITSFORSTREFPICSETINSLICE);
    }

    public static byte nNumDeltaPocsOfRefRpsIdx(long struct) {
        return UNSAFE.getByte(null, struct + (long)NUMDELTAPOCSOFREFRPSIDX);
    }

    public static ByteBuffer nRefPicSetStCurrBefore(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)REFPICSETSTCURRBEFORE), (int)8);
    }

    public static byte nRefPicSetStCurrBefore(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)REFPICSETSTCURRBEFORE + Checks.check((int)index, (int)8) * 1L);
    }

    public static ByteBuffer nRefPicSetStCurrAfter(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)REFPICSETSTCURRAFTER), (int)8);
    }

    public static byte nRefPicSetStCurrAfter(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)REFPICSETSTCURRAFTER + Checks.check((int)index, (int)8) * 1L);
    }

    public static ByteBuffer nRefPicSetLtCurr(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)REFPICSETLTCURR), (int)8);
    }

    public static byte nRefPicSetLtCurr(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)REFPICSETLTCURR + Checks.check((int)index, (int)8) * 1L);
    }

    public static StdVideoDecodeH265PictureInfoFlags nflags(long struct) {
        return StdVideoDecodeH265PictureInfoFlags.create(struct + (long)FLAGS);
    }

    public static void nvps_video_parameter_set_id(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)VPS_VIDEO_PARAMETER_SET_ID, value);
    }

    public static void nsps_seq_parameter_set_id(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SPS_SEQ_PARAMETER_SET_ID, value);
    }

    public static void npps_pic_parameter_set_id(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)PPS_PIC_PARAMETER_SET_ID, value);
    }

    public static void nnum_short_term_ref_pic_sets(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)NUM_SHORT_TERM_REF_PIC_SETS, value);
    }

    public static void nPicOrderCntVal(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PICORDERCNTVAL, value);
    }

    public static void nNumBitsForSTRefPicSetInSlice(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)NUMBITSFORSTREFPICSETINSLICE, value);
    }

    public static void nNumDeltaPocsOfRefRpsIdx(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)NUMDELTAPOCSOFREFRPSIDX, value);
    }

    public static void nRefPicSetStCurrBefore(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)8);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)REFPICSETSTCURRBEFORE), (long)(value.remaining() * 1));
    }

    public static void nRefPicSetStCurrBefore(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)REFPICSETSTCURRBEFORE + Checks.check((int)index, (int)8) * 1L, value);
    }

    public static void nRefPicSetStCurrAfter(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)8);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)REFPICSETSTCURRAFTER), (long)(value.remaining() * 1));
    }

    public static void nRefPicSetStCurrAfter(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)REFPICSETSTCURRAFTER + Checks.check((int)index, (int)8) * 1L, value);
    }

    public static void nRefPicSetLtCurr(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)8);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)REFPICSETLTCURR), (long)(value.remaining() * 1));
    }

    public static void nRefPicSetLtCurr(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)REFPICSETLTCURR + Checks.check((int)index, (int)8) * 1L, value);
    }

    public static void nflags(long struct, StdVideoDecodeH265PictureInfoFlags value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FLAGS), (long)StdVideoDecodeH265PictureInfoFlags.SIZEOF);
    }

    static {
        Struct.Layout layout = StdVideoDecodeH265PictureInfo.__struct((Struct.Member[])new Struct.Member[]{StdVideoDecodeH265PictureInfo.__member((int)1), StdVideoDecodeH265PictureInfo.__member((int)1), StdVideoDecodeH265PictureInfo.__member((int)1), StdVideoDecodeH265PictureInfo.__member((int)1), StdVideoDecodeH265PictureInfo.__member((int)4), StdVideoDecodeH265PictureInfo.__member((int)2), StdVideoDecodeH265PictureInfo.__member((int)1), StdVideoDecodeH265PictureInfo.__array((int)1, (int)8), StdVideoDecodeH265PictureInfo.__array((int)1, (int)8), StdVideoDecodeH265PictureInfo.__array((int)1, (int)8), StdVideoDecodeH265PictureInfo.__member((int)StdVideoDecodeH265PictureInfoFlags.SIZEOF, (int)StdVideoDecodeH265PictureInfoFlags.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VPS_VIDEO_PARAMETER_SET_ID = layout.offsetof(0);
        SPS_SEQ_PARAMETER_SET_ID = layout.offsetof(1);
        PPS_PIC_PARAMETER_SET_ID = layout.offsetof(2);
        NUM_SHORT_TERM_REF_PIC_SETS = layout.offsetof(3);
        PICORDERCNTVAL = layout.offsetof(4);
        NUMBITSFORSTREFPICSETINSLICE = layout.offsetof(5);
        NUMDELTAPOCSOFREFRPSIDX = layout.offsetof(6);
        REFPICSETSTCURRBEFORE = layout.offsetof(7);
        REFPICSETSTCURRAFTER = layout.offsetof(8);
        REFPICSETLTCURR = layout.offsetof(9);
        FLAGS = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<StdVideoDecodeH265PictureInfo, Buffer>
    implements NativeResource {
        private static final StdVideoDecodeH265PictureInfo ELEMENT_FACTORY = StdVideoDecodeH265PictureInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected StdVideoDecodeH265PictureInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint8_t")
        public byte vps_video_parameter_set_id() {
            return StdVideoDecodeH265PictureInfo.nvps_video_parameter_set_id(this.address());
        }

        @NativeType(value="uint8_t")
        public byte sps_seq_parameter_set_id() {
            return StdVideoDecodeH265PictureInfo.nsps_seq_parameter_set_id(this.address());
        }

        @NativeType(value="uint8_t")
        public byte pps_pic_parameter_set_id() {
            return StdVideoDecodeH265PictureInfo.npps_pic_parameter_set_id(this.address());
        }

        @NativeType(value="uint8_t")
        public byte num_short_term_ref_pic_sets() {
            return StdVideoDecodeH265PictureInfo.nnum_short_term_ref_pic_sets(this.address());
        }

        @NativeType(value="int32_t")
        public int PicOrderCntVal() {
            return StdVideoDecodeH265PictureInfo.nPicOrderCntVal(this.address());
        }

        @NativeType(value="uint16_t")
        public short NumBitsForSTRefPicSetInSlice() {
            return StdVideoDecodeH265PictureInfo.nNumBitsForSTRefPicSetInSlice(this.address());
        }

        @NativeType(value="uint8_t")
        public byte NumDeltaPocsOfRefRpsIdx() {
            return StdVideoDecodeH265PictureInfo.nNumDeltaPocsOfRefRpsIdx(this.address());
        }

        @NativeType(value="uint8_t[STD_VIDEO_DECODE_H265_REF_PIC_SET_LIST_SIZE]")
        public ByteBuffer RefPicSetStCurrBefore() {
            return StdVideoDecodeH265PictureInfo.nRefPicSetStCurrBefore(this.address());
        }

        @NativeType(value="uint8_t")
        public byte RefPicSetStCurrBefore(int index) {
            return StdVideoDecodeH265PictureInfo.nRefPicSetStCurrBefore(this.address(), index);
        }

        @NativeType(value="uint8_t[STD_VIDEO_DECODE_H265_REF_PIC_SET_LIST_SIZE]")
        public ByteBuffer RefPicSetStCurrAfter() {
            return StdVideoDecodeH265PictureInfo.nRefPicSetStCurrAfter(this.address());
        }

        @NativeType(value="uint8_t")
        public byte RefPicSetStCurrAfter(int index) {
            return StdVideoDecodeH265PictureInfo.nRefPicSetStCurrAfter(this.address(), index);
        }

        @NativeType(value="uint8_t[STD_VIDEO_DECODE_H265_REF_PIC_SET_LIST_SIZE]")
        public ByteBuffer RefPicSetLtCurr() {
            return StdVideoDecodeH265PictureInfo.nRefPicSetLtCurr(this.address());
        }

        @NativeType(value="uint8_t")
        public byte RefPicSetLtCurr(int index) {
            return StdVideoDecodeH265PictureInfo.nRefPicSetLtCurr(this.address(), index);
        }

        public StdVideoDecodeH265PictureInfoFlags flags() {
            return StdVideoDecodeH265PictureInfo.nflags(this.address());
        }

        public Buffer vps_video_parameter_set_id(@NativeType(value="uint8_t") byte value) {
            StdVideoDecodeH265PictureInfo.nvps_video_parameter_set_id(this.address(), value);
            return this;
        }

        public Buffer sps_seq_parameter_set_id(@NativeType(value="uint8_t") byte value) {
            StdVideoDecodeH265PictureInfo.nsps_seq_parameter_set_id(this.address(), value);
            return this;
        }

        public Buffer pps_pic_parameter_set_id(@NativeType(value="uint8_t") byte value) {
            StdVideoDecodeH265PictureInfo.npps_pic_parameter_set_id(this.address(), value);
            return this;
        }

        public Buffer num_short_term_ref_pic_sets(@NativeType(value="uint8_t") byte value) {
            StdVideoDecodeH265PictureInfo.nnum_short_term_ref_pic_sets(this.address(), value);
            return this;
        }

        public Buffer PicOrderCntVal(@NativeType(value="int32_t") int value) {
            StdVideoDecodeH265PictureInfo.nPicOrderCntVal(this.address(), value);
            return this;
        }

        public Buffer NumBitsForSTRefPicSetInSlice(@NativeType(value="uint16_t") short value) {
            StdVideoDecodeH265PictureInfo.nNumBitsForSTRefPicSetInSlice(this.address(), value);
            return this;
        }

        public Buffer NumDeltaPocsOfRefRpsIdx(@NativeType(value="uint8_t") byte value) {
            StdVideoDecodeH265PictureInfo.nNumDeltaPocsOfRefRpsIdx(this.address(), value);
            return this;
        }

        public Buffer RefPicSetStCurrBefore(@NativeType(value="uint8_t[STD_VIDEO_DECODE_H265_REF_PIC_SET_LIST_SIZE]") ByteBuffer value) {
            StdVideoDecodeH265PictureInfo.nRefPicSetStCurrBefore(this.address(), value);
            return this;
        }

        public Buffer RefPicSetStCurrBefore(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoDecodeH265PictureInfo.nRefPicSetStCurrBefore(this.address(), index, value);
            return this;
        }

        public Buffer RefPicSetStCurrAfter(@NativeType(value="uint8_t[STD_VIDEO_DECODE_H265_REF_PIC_SET_LIST_SIZE]") ByteBuffer value) {
            StdVideoDecodeH265PictureInfo.nRefPicSetStCurrAfter(this.address(), value);
            return this;
        }

        public Buffer RefPicSetStCurrAfter(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoDecodeH265PictureInfo.nRefPicSetStCurrAfter(this.address(), index, value);
            return this;
        }

        public Buffer RefPicSetLtCurr(@NativeType(value="uint8_t[STD_VIDEO_DECODE_H265_REF_PIC_SET_LIST_SIZE]") ByteBuffer value) {
            StdVideoDecodeH265PictureInfo.nRefPicSetLtCurr(this.address(), value);
            return this;
        }

        public Buffer RefPicSetLtCurr(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoDecodeH265PictureInfo.nRefPicSetLtCurr(this.address(), index, value);
            return this;
        }

        public Buffer flags(StdVideoDecodeH265PictureInfoFlags value) {
            StdVideoDecodeH265PictureInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoDecodeH265PictureInfoFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }
    }
}

