/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkRect2D;

public class VkDeviceGroupRenderPassBeginInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DEVICEMASK;
    public static final int DEVICERENDERAREACOUNT;
    public static final int PDEVICERENDERAREAS;

    public VkDeviceGroupRenderPassBeginInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDeviceGroupRenderPassBeginInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceGroupRenderPassBeginInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDeviceGroupRenderPassBeginInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int deviceMask() {
        return VkDeviceGroupRenderPassBeginInfo.ndeviceMask(this.address());
    }

    @NativeType(value="uint32_t")
    public int deviceRenderAreaCount() {
        return VkDeviceGroupRenderPassBeginInfo.ndeviceRenderAreaCount(this.address());
    }

    @Nullable
    @NativeType(value="VkRect2D const *")
    public VkRect2D.Buffer pDeviceRenderAreas() {
        return VkDeviceGroupRenderPassBeginInfo.npDeviceRenderAreas(this.address());
    }

    public VkDeviceGroupRenderPassBeginInfo sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceGroupRenderPassBeginInfo.nsType(this.address(), value);
        return this;
    }

    public VkDeviceGroupRenderPassBeginInfo sType$Default() {
        return this.sType(1000060003);
    }

    public VkDeviceGroupRenderPassBeginInfo pNext(@NativeType(value="void const *") long value) {
        VkDeviceGroupRenderPassBeginInfo.npNext(this.address(), value);
        return this;
    }

    public VkDeviceGroupRenderPassBeginInfo deviceMask(@NativeType(value="uint32_t") int value) {
        VkDeviceGroupRenderPassBeginInfo.ndeviceMask(this.address(), value);
        return this;
    }

    public VkDeviceGroupRenderPassBeginInfo pDeviceRenderAreas(@Nullable @NativeType(value="VkRect2D const *") VkRect2D.Buffer value) {
        VkDeviceGroupRenderPassBeginInfo.npDeviceRenderAreas(this.address(), value);
        return this;
    }

    public VkDeviceGroupRenderPassBeginInfo set(int sType, long pNext, int deviceMask, @Nullable VkRect2D.Buffer pDeviceRenderAreas) {
        this.sType(sType);
        this.pNext(pNext);
        this.deviceMask(deviceMask);
        this.pDeviceRenderAreas(pDeviceRenderAreas);
        return this;
    }

    public VkDeviceGroupRenderPassBeginInfo set(VkDeviceGroupRenderPassBeginInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDeviceGroupRenderPassBeginInfo malloc() {
        return (VkDeviceGroupRenderPassBeginInfo)VkDeviceGroupRenderPassBeginInfo.wrap(VkDeviceGroupRenderPassBeginInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkDeviceGroupRenderPassBeginInfo calloc() {
        return (VkDeviceGroupRenderPassBeginInfo)VkDeviceGroupRenderPassBeginInfo.wrap(VkDeviceGroupRenderPassBeginInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkDeviceGroupRenderPassBeginInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkDeviceGroupRenderPassBeginInfo)VkDeviceGroupRenderPassBeginInfo.wrap(VkDeviceGroupRenderPassBeginInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkDeviceGroupRenderPassBeginInfo create(long address) {
        return (VkDeviceGroupRenderPassBeginInfo)VkDeviceGroupRenderPassBeginInfo.wrap(VkDeviceGroupRenderPassBeginInfo.class, (long)address);
    }

    @Nullable
    public static VkDeviceGroupRenderPassBeginInfo createSafe(long address) {
        return address == 0L ? null : (VkDeviceGroupRenderPassBeginInfo)VkDeviceGroupRenderPassBeginInfo.wrap(VkDeviceGroupRenderPassBeginInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkDeviceGroupRenderPassBeginInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkDeviceGroupRenderPassBeginInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkDeviceGroupRenderPassBeginInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceGroupRenderPassBeginInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkDeviceGroupRenderPassBeginInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkDeviceGroupRenderPassBeginInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkDeviceGroupRenderPassBeginInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkDeviceGroupRenderPassBeginInfo mallocStack() {
        return VkDeviceGroupRenderPassBeginInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDeviceGroupRenderPassBeginInfo callocStack() {
        return VkDeviceGroupRenderPassBeginInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDeviceGroupRenderPassBeginInfo mallocStack(MemoryStack stack) {
        return VkDeviceGroupRenderPassBeginInfo.malloc(stack);
    }

    @Deprecated
    public static VkDeviceGroupRenderPassBeginInfo callocStack(MemoryStack stack) {
        return VkDeviceGroupRenderPassBeginInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDeviceGroupRenderPassBeginInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDeviceGroupRenderPassBeginInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupRenderPassBeginInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupRenderPassBeginInfo.calloc(capacity, stack);
    }

    public static VkDeviceGroupRenderPassBeginInfo malloc(MemoryStack stack) {
        return (VkDeviceGroupRenderPassBeginInfo)VkDeviceGroupRenderPassBeginInfo.wrap(VkDeviceGroupRenderPassBeginInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceGroupRenderPassBeginInfo calloc(MemoryStack stack) {
        return (VkDeviceGroupRenderPassBeginInfo)VkDeviceGroupRenderPassBeginInfo.wrap(VkDeviceGroupRenderPassBeginInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkDeviceGroupRenderPassBeginInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkDeviceGroupRenderPassBeginInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int ndeviceMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEVICEMASK);
    }

    public static int ndeviceRenderAreaCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEVICERENDERAREACOUNT);
    }

    @Nullable
    public static VkRect2D.Buffer npDeviceRenderAreas(long struct) {
        return VkRect2D.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PDEVICERENDERAREAS)), VkDeviceGroupRenderPassBeginInfo.ndeviceRenderAreaCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void ndeviceMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEVICEMASK, value);
    }

    public static void ndeviceRenderAreaCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEVICERENDERAREACOUNT, value);
    }

    public static void npDeviceRenderAreas(long struct, @Nullable VkRect2D.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PDEVICERENDERAREAS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkDeviceGroupRenderPassBeginInfo.ndeviceRenderAreaCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkDeviceGroupRenderPassBeginInfo.ndeviceRenderAreaCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PDEVICERENDERAREAS)));
        }
    }

    static {
        Struct.Layout layout = VkDeviceGroupRenderPassBeginInfo.__struct((Struct.Member[])new Struct.Member[]{VkDeviceGroupRenderPassBeginInfo.__member((int)4), VkDeviceGroupRenderPassBeginInfo.__member((int)POINTER_SIZE), VkDeviceGroupRenderPassBeginInfo.__member((int)4), VkDeviceGroupRenderPassBeginInfo.__member((int)4), VkDeviceGroupRenderPassBeginInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DEVICEMASK = layout.offsetof(2);
        DEVICERENDERAREACOUNT = layout.offsetof(3);
        PDEVICERENDERAREAS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceGroupRenderPassBeginInfo, Buffer>
    implements NativeResource {
        private static final VkDeviceGroupRenderPassBeginInfo ELEMENT_FACTORY = VkDeviceGroupRenderPassBeginInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDeviceGroupRenderPassBeginInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceGroupRenderPassBeginInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDeviceGroupRenderPassBeginInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int deviceMask() {
            return VkDeviceGroupRenderPassBeginInfo.ndeviceMask(this.address());
        }

        @NativeType(value="uint32_t")
        public int deviceRenderAreaCount() {
            return VkDeviceGroupRenderPassBeginInfo.ndeviceRenderAreaCount(this.address());
        }

        @Nullable
        @NativeType(value="VkRect2D const *")
        public VkRect2D.Buffer pDeviceRenderAreas() {
            return VkDeviceGroupRenderPassBeginInfo.npDeviceRenderAreas(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceGroupRenderPassBeginInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000060003);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceGroupRenderPassBeginInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer deviceMask(@NativeType(value="uint32_t") int value) {
            VkDeviceGroupRenderPassBeginInfo.ndeviceMask(this.address(), value);
            return this;
        }

        public Buffer pDeviceRenderAreas(@Nullable @NativeType(value="VkRect2D const *") VkRect2D.Buffer value) {
            VkDeviceGroupRenderPassBeginInfo.npDeviceRenderAreas(this.address(), value);
            return this;
        }
    }
}

