/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrGraphicsBindingEGLMNDX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int GETPROCADDRESS;
    public static final int DISPLAY;
    public static final int CONFIG;
    public static final int CONTEXT;

    public XrGraphicsBindingEGLMNDX(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrGraphicsBindingEGLMNDX.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrGraphicsBindingEGLMNDX.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrGraphicsBindingEGLMNDX.nnext(this.address());
    }

    @NativeType(value="PFNEGLGETPROCADDRESSPROC")
    public long getProcAddress() {
        return XrGraphicsBindingEGLMNDX.ngetProcAddress(this.address());
    }

    @NativeType(value="EGLDisplay")
    public long display() {
        return XrGraphicsBindingEGLMNDX.ndisplay(this.address());
    }

    @NativeType(value="EGLConfig")
    public long config() {
        return XrGraphicsBindingEGLMNDX.nconfig(this.address());
    }

    @NativeType(value="EGLContext")
    public long context() {
        return XrGraphicsBindingEGLMNDX.ncontext(this.address());
    }

    public XrGraphicsBindingEGLMNDX type(@NativeType(value="XrStructureType") int value) {
        XrGraphicsBindingEGLMNDX.ntype(this.address(), value);
        return this;
    }

    public XrGraphicsBindingEGLMNDX type$Default() {
        return this.type(1000048004);
    }

    public XrGraphicsBindingEGLMNDX next(@NativeType(value="void const *") long value) {
        XrGraphicsBindingEGLMNDX.nnext(this.address(), value);
        return this;
    }

    public XrGraphicsBindingEGLMNDX getProcAddress(@NativeType(value="PFNEGLGETPROCADDRESSPROC") long value) {
        XrGraphicsBindingEGLMNDX.ngetProcAddress(this.address(), value);
        return this;
    }

    public XrGraphicsBindingEGLMNDX display(@NativeType(value="EGLDisplay") long value) {
        XrGraphicsBindingEGLMNDX.ndisplay(this.address(), value);
        return this;
    }

    public XrGraphicsBindingEGLMNDX config(@NativeType(value="EGLConfig") long value) {
        XrGraphicsBindingEGLMNDX.nconfig(this.address(), value);
        return this;
    }

    public XrGraphicsBindingEGLMNDX context(@NativeType(value="EGLContext") long value) {
        XrGraphicsBindingEGLMNDX.ncontext(this.address(), value);
        return this;
    }

    public XrGraphicsBindingEGLMNDX set(int type, long next, long getProcAddress, long display, long config, long context) {
        this.type(type);
        this.next(next);
        this.getProcAddress(getProcAddress);
        this.display(display);
        this.config(config);
        this.context(context);
        return this;
    }

    public XrGraphicsBindingEGLMNDX set(XrGraphicsBindingEGLMNDX src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrGraphicsBindingEGLMNDX malloc() {
        return (XrGraphicsBindingEGLMNDX)XrGraphicsBindingEGLMNDX.wrap(XrGraphicsBindingEGLMNDX.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrGraphicsBindingEGLMNDX calloc() {
        return (XrGraphicsBindingEGLMNDX)XrGraphicsBindingEGLMNDX.wrap(XrGraphicsBindingEGLMNDX.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrGraphicsBindingEGLMNDX create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrGraphicsBindingEGLMNDX)XrGraphicsBindingEGLMNDX.wrap(XrGraphicsBindingEGLMNDX.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrGraphicsBindingEGLMNDX create(long address) {
        return (XrGraphicsBindingEGLMNDX)XrGraphicsBindingEGLMNDX.wrap(XrGraphicsBindingEGLMNDX.class, (long)address);
    }

    @Nullable
    public static XrGraphicsBindingEGLMNDX createSafe(long address) {
        return address == 0L ? null : (XrGraphicsBindingEGLMNDX)XrGraphicsBindingEGLMNDX.wrap(XrGraphicsBindingEGLMNDX.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrGraphicsBindingEGLMNDX.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrGraphicsBindingEGLMNDX.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrGraphicsBindingEGLMNDX.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrGraphicsBindingEGLMNDX.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrGraphicsBindingEGLMNDX.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrGraphicsBindingEGLMNDX.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrGraphicsBindingEGLMNDX.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrGraphicsBindingEGLMNDX malloc(MemoryStack stack) {
        return (XrGraphicsBindingEGLMNDX)XrGraphicsBindingEGLMNDX.wrap(XrGraphicsBindingEGLMNDX.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrGraphicsBindingEGLMNDX calloc(MemoryStack stack) {
        return (XrGraphicsBindingEGLMNDX)XrGraphicsBindingEGLMNDX.wrap(XrGraphicsBindingEGLMNDX.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrGraphicsBindingEGLMNDX.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrGraphicsBindingEGLMNDX.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long ngetProcAddress(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)GETPROCADDRESS));
    }

    public static long ndisplay(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DISPLAY));
    }

    public static long nconfig(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)CONFIG));
    }

    public static long ncontext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)CONTEXT));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void ngetProcAddress(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)GETPROCADDRESS), (long)Checks.check((long)value));
    }

    public static void ndisplay(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DISPLAY), (long)Checks.check((long)value));
    }

    public static void nconfig(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CONFIG), (long)Checks.check((long)value));
    }

    public static void ncontext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CONTEXT), (long)Checks.check((long)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)GETPROCADDRESS)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)DISPLAY)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)CONFIG)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)CONTEXT)));
    }

    static {
        Struct.Layout layout = XrGraphicsBindingEGLMNDX.__struct((Struct.Member[])new Struct.Member[]{XrGraphicsBindingEGLMNDX.__member((int)4), XrGraphicsBindingEGLMNDX.__member((int)POINTER_SIZE), XrGraphicsBindingEGLMNDX.__member((int)POINTER_SIZE), XrGraphicsBindingEGLMNDX.__member((int)POINTER_SIZE), XrGraphicsBindingEGLMNDX.__member((int)POINTER_SIZE), XrGraphicsBindingEGLMNDX.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        GETPROCADDRESS = layout.offsetof(2);
        DISPLAY = layout.offsetof(3);
        CONFIG = layout.offsetof(4);
        CONTEXT = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrGraphicsBindingEGLMNDX, Buffer>
    implements NativeResource {
        private static final XrGraphicsBindingEGLMNDX ELEMENT_FACTORY = XrGraphicsBindingEGLMNDX.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrGraphicsBindingEGLMNDX getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrGraphicsBindingEGLMNDX.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrGraphicsBindingEGLMNDX.nnext(this.address());
        }

        @NativeType(value="PFNEGLGETPROCADDRESSPROC")
        public long getProcAddress() {
            return XrGraphicsBindingEGLMNDX.ngetProcAddress(this.address());
        }

        @NativeType(value="EGLDisplay")
        public long display() {
            return XrGraphicsBindingEGLMNDX.ndisplay(this.address());
        }

        @NativeType(value="EGLConfig")
        public long config() {
            return XrGraphicsBindingEGLMNDX.nconfig(this.address());
        }

        @NativeType(value="EGLContext")
        public long context() {
            return XrGraphicsBindingEGLMNDX.ncontext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrGraphicsBindingEGLMNDX.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000048004);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrGraphicsBindingEGLMNDX.nnext(this.address(), value);
            return this;
        }

        public Buffer getProcAddress(@NativeType(value="PFNEGLGETPROCADDRESSPROC") long value) {
            XrGraphicsBindingEGLMNDX.ngetProcAddress(this.address(), value);
            return this;
        }

        public Buffer display(@NativeType(value="EGLDisplay") long value) {
            XrGraphicsBindingEGLMNDX.ndisplay(this.address(), value);
            return this;
        }

        public Buffer config(@NativeType(value="EGLConfig") long value) {
            XrGraphicsBindingEGLMNDX.nconfig(this.address(), value);
            return this;
        }

        public Buffer context(@NativeType(value="EGLContext") long value) {
            XrGraphicsBindingEGLMNDX.ncontext(this.address(), value);
            return this;
        }
    }
}

