/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrVector2f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrActionStateVector2f
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int CURRENTSTATE;
    public static final int CHANGEDSINCELASTSYNC;
    public static final int LASTCHANGETIME;
    public static final int ISACTIVE;

    public XrActionStateVector2f(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrActionStateVector2f.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrActionStateVector2f.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrActionStateVector2f.nnext(this.address());
    }

    public XrVector2f currentState() {
        return XrActionStateVector2f.ncurrentState(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean changedSinceLastSync() {
        return XrActionStateVector2f.nchangedSinceLastSync(this.address()) != 0;
    }

    @NativeType(value="XrTime")
    public long lastChangeTime() {
        return XrActionStateVector2f.nlastChangeTime(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean isActive() {
        return XrActionStateVector2f.nisActive(this.address()) != 0;
    }

    public XrActionStateVector2f type(@NativeType(value="XrStructureType") int value) {
        XrActionStateVector2f.ntype(this.address(), value);
        return this;
    }

    public XrActionStateVector2f type$Default() {
        return this.type(25);
    }

    public XrActionStateVector2f next(@NativeType(value="void *") long value) {
        XrActionStateVector2f.nnext(this.address(), value);
        return this;
    }

    public XrActionStateVector2f currentState(XrVector2f value) {
        XrActionStateVector2f.ncurrentState(this.address(), value);
        return this;
    }

    public XrActionStateVector2f currentState(Consumer<XrVector2f> consumer) {
        consumer.accept(this.currentState());
        return this;
    }

    public XrActionStateVector2f changedSinceLastSync(@NativeType(value="XrBool32") boolean value) {
        XrActionStateVector2f.nchangedSinceLastSync(this.address(), value ? 1 : 0);
        return this;
    }

    public XrActionStateVector2f lastChangeTime(@NativeType(value="XrTime") long value) {
        XrActionStateVector2f.nlastChangeTime(this.address(), value);
        return this;
    }

    public XrActionStateVector2f isActive(@NativeType(value="XrBool32") boolean value) {
        XrActionStateVector2f.nisActive(this.address(), value ? 1 : 0);
        return this;
    }

    public XrActionStateVector2f set(int type, long next, XrVector2f currentState, boolean changedSinceLastSync, long lastChangeTime, boolean isActive) {
        this.type(type);
        this.next(next);
        this.currentState(currentState);
        this.changedSinceLastSync(changedSinceLastSync);
        this.lastChangeTime(lastChangeTime);
        this.isActive(isActive);
        return this;
    }

    public XrActionStateVector2f set(XrActionStateVector2f src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrActionStateVector2f malloc() {
        return (XrActionStateVector2f)XrActionStateVector2f.wrap(XrActionStateVector2f.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrActionStateVector2f calloc() {
        return (XrActionStateVector2f)XrActionStateVector2f.wrap(XrActionStateVector2f.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrActionStateVector2f create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrActionStateVector2f)XrActionStateVector2f.wrap(XrActionStateVector2f.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrActionStateVector2f create(long address) {
        return (XrActionStateVector2f)XrActionStateVector2f.wrap(XrActionStateVector2f.class, (long)address);
    }

    @Nullable
    public static XrActionStateVector2f createSafe(long address) {
        return address == 0L ? null : (XrActionStateVector2f)XrActionStateVector2f.wrap(XrActionStateVector2f.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrActionStateVector2f.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrActionStateVector2f.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrActionStateVector2f.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrActionStateVector2f.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrActionStateVector2f.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrActionStateVector2f.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrActionStateVector2f.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrActionStateVector2f malloc(MemoryStack stack) {
        return (XrActionStateVector2f)XrActionStateVector2f.wrap(XrActionStateVector2f.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrActionStateVector2f calloc(MemoryStack stack) {
        return (XrActionStateVector2f)XrActionStateVector2f.wrap(XrActionStateVector2f.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrActionStateVector2f.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrActionStateVector2f.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static XrVector2f ncurrentState(long struct) {
        return XrVector2f.create(struct + (long)CURRENTSTATE);
    }

    public static int nchangedSinceLastSync(long struct) {
        return UNSAFE.getInt(null, struct + (long)CHANGEDSINCELASTSYNC);
    }

    public static long nlastChangeTime(long struct) {
        return UNSAFE.getLong(null, struct + (long)LASTCHANGETIME);
    }

    public static int nisActive(long struct) {
        return UNSAFE.getInt(null, struct + (long)ISACTIVE);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void ncurrentState(long struct, XrVector2f value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CURRENTSTATE), (long)XrVector2f.SIZEOF);
    }

    public static void nchangedSinceLastSync(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CHANGEDSINCELASTSYNC, value);
    }

    public static void nlastChangeTime(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)LASTCHANGETIME, value);
    }

    public static void nisActive(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ISACTIVE, value);
    }

    static {
        Struct.Layout layout = XrActionStateVector2f.__struct((Struct.Member[])new Struct.Member[]{XrActionStateVector2f.__member((int)4), XrActionStateVector2f.__member((int)POINTER_SIZE), XrActionStateVector2f.__member((int)XrVector2f.SIZEOF, (int)XrVector2f.ALIGNOF), XrActionStateVector2f.__member((int)4), XrActionStateVector2f.__member((int)8), XrActionStateVector2f.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        CURRENTSTATE = layout.offsetof(2);
        CHANGEDSINCELASTSYNC = layout.offsetof(3);
        LASTCHANGETIME = layout.offsetof(4);
        ISACTIVE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrActionStateVector2f, Buffer>
    implements NativeResource {
        private static final XrActionStateVector2f ELEMENT_FACTORY = XrActionStateVector2f.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrActionStateVector2f getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrActionStateVector2f.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrActionStateVector2f.nnext(this.address());
        }

        public XrVector2f currentState() {
            return XrActionStateVector2f.ncurrentState(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean changedSinceLastSync() {
            return XrActionStateVector2f.nchangedSinceLastSync(this.address()) != 0;
        }

        @NativeType(value="XrTime")
        public long lastChangeTime() {
            return XrActionStateVector2f.nlastChangeTime(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean isActive() {
            return XrActionStateVector2f.nisActive(this.address()) != 0;
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrActionStateVector2f.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(25);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrActionStateVector2f.nnext(this.address(), value);
            return this;
        }

        public Buffer currentState(XrVector2f value) {
            XrActionStateVector2f.ncurrentState(this.address(), value);
            return this;
        }

        public Buffer currentState(Consumer<XrVector2f> consumer) {
            consumer.accept(this.currentState());
            return this;
        }

        public Buffer changedSinceLastSync(@NativeType(value="XrBool32") boolean value) {
            XrActionStateVector2f.nchangedSinceLastSync(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer lastChangeTime(@NativeType(value="XrTime") long value) {
            XrActionStateVector2f.nlastChangeTime(this.address(), value);
            return this;
        }

        public Buffer isActive(@NativeType(value="XrBool32") boolean value) {
            XrActionStateVector2f.nisActive(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

