/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrActionStateBoolean
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int CURRENTSTATE;
    public static final int CHANGEDSINCELASTSYNC;
    public static final int LASTCHANGETIME;
    public static final int ISACTIVE;

    public XrActionStateBoolean(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrActionStateBoolean.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrActionStateBoolean.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrActionStateBoolean.nnext(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean currentState() {
        return XrActionStateBoolean.ncurrentState(this.address()) != 0;
    }

    @NativeType(value="XrBool32")
    public boolean changedSinceLastSync() {
        return XrActionStateBoolean.nchangedSinceLastSync(this.address()) != 0;
    }

    @NativeType(value="XrTime")
    public long lastChangeTime() {
        return XrActionStateBoolean.nlastChangeTime(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean isActive() {
        return XrActionStateBoolean.nisActive(this.address()) != 0;
    }

    public XrActionStateBoolean type(@NativeType(value="XrStructureType") int value) {
        XrActionStateBoolean.ntype(this.address(), value);
        return this;
    }

    public XrActionStateBoolean type$Default() {
        return this.type(23);
    }

    public XrActionStateBoolean next(@NativeType(value="void *") long value) {
        XrActionStateBoolean.nnext(this.address(), value);
        return this;
    }

    public XrActionStateBoolean currentState(@NativeType(value="XrBool32") boolean value) {
        XrActionStateBoolean.ncurrentState(this.address(), value ? 1 : 0);
        return this;
    }

    public XrActionStateBoolean changedSinceLastSync(@NativeType(value="XrBool32") boolean value) {
        XrActionStateBoolean.nchangedSinceLastSync(this.address(), value ? 1 : 0);
        return this;
    }

    public XrActionStateBoolean lastChangeTime(@NativeType(value="XrTime") long value) {
        XrActionStateBoolean.nlastChangeTime(this.address(), value);
        return this;
    }

    public XrActionStateBoolean isActive(@NativeType(value="XrBool32") boolean value) {
        XrActionStateBoolean.nisActive(this.address(), value ? 1 : 0);
        return this;
    }

    public XrActionStateBoolean set(int type, long next, boolean currentState, boolean changedSinceLastSync, long lastChangeTime, boolean isActive) {
        this.type(type);
        this.next(next);
        this.currentState(currentState);
        this.changedSinceLastSync(changedSinceLastSync);
        this.lastChangeTime(lastChangeTime);
        this.isActive(isActive);
        return this;
    }

    public XrActionStateBoolean set(XrActionStateBoolean src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrActionStateBoolean malloc() {
        return (XrActionStateBoolean)XrActionStateBoolean.wrap(XrActionStateBoolean.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrActionStateBoolean calloc() {
        return (XrActionStateBoolean)XrActionStateBoolean.wrap(XrActionStateBoolean.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrActionStateBoolean create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrActionStateBoolean)XrActionStateBoolean.wrap(XrActionStateBoolean.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrActionStateBoolean create(long address) {
        return (XrActionStateBoolean)XrActionStateBoolean.wrap(XrActionStateBoolean.class, (long)address);
    }

    @Nullable
    public static XrActionStateBoolean createSafe(long address) {
        return address == 0L ? null : (XrActionStateBoolean)XrActionStateBoolean.wrap(XrActionStateBoolean.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrActionStateBoolean.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrActionStateBoolean.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrActionStateBoolean.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrActionStateBoolean.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrActionStateBoolean.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrActionStateBoolean.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrActionStateBoolean.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrActionStateBoolean malloc(MemoryStack stack) {
        return (XrActionStateBoolean)XrActionStateBoolean.wrap(XrActionStateBoolean.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrActionStateBoolean calloc(MemoryStack stack) {
        return (XrActionStateBoolean)XrActionStateBoolean.wrap(XrActionStateBoolean.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrActionStateBoolean.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrActionStateBoolean.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int ncurrentState(long struct) {
        return UNSAFE.getInt(null, struct + (long)CURRENTSTATE);
    }

    public static int nchangedSinceLastSync(long struct) {
        return UNSAFE.getInt(null, struct + (long)CHANGEDSINCELASTSYNC);
    }

    public static long nlastChangeTime(long struct) {
        return UNSAFE.getLong(null, struct + (long)LASTCHANGETIME);
    }

    public static int nisActive(long struct) {
        return UNSAFE.getInt(null, struct + (long)ISACTIVE);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void ncurrentState(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CURRENTSTATE, value);
    }

    public static void nchangedSinceLastSync(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CHANGEDSINCELASTSYNC, value);
    }

    public static void nlastChangeTime(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)LASTCHANGETIME, value);
    }

    public static void nisActive(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ISACTIVE, value);
    }

    static {
        Struct.Layout layout = XrActionStateBoolean.__struct((Struct.Member[])new Struct.Member[]{XrActionStateBoolean.__member((int)4), XrActionStateBoolean.__member((int)POINTER_SIZE), XrActionStateBoolean.__member((int)4), XrActionStateBoolean.__member((int)4), XrActionStateBoolean.__member((int)8), XrActionStateBoolean.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        CURRENTSTATE = layout.offsetof(2);
        CHANGEDSINCELASTSYNC = layout.offsetof(3);
        LASTCHANGETIME = layout.offsetof(4);
        ISACTIVE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrActionStateBoolean, Buffer>
    implements NativeResource {
        private static final XrActionStateBoolean ELEMENT_FACTORY = XrActionStateBoolean.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrActionStateBoolean getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrActionStateBoolean.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrActionStateBoolean.nnext(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean currentState() {
            return XrActionStateBoolean.ncurrentState(this.address()) != 0;
        }

        @NativeType(value="XrBool32")
        public boolean changedSinceLastSync() {
            return XrActionStateBoolean.nchangedSinceLastSync(this.address()) != 0;
        }

        @NativeType(value="XrTime")
        public long lastChangeTime() {
            return XrActionStateBoolean.nlastChangeTime(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean isActive() {
            return XrActionStateBoolean.nisActive(this.address()) != 0;
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrActionStateBoolean.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(23);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrActionStateBoolean.nnext(this.address(), value);
            return this;
        }

        public Buffer currentState(@NativeType(value="XrBool32") boolean value) {
            XrActionStateBoolean.ncurrentState(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer changedSinceLastSync(@NativeType(value="XrBool32") boolean value) {
            XrActionStateBoolean.nchangedSinceLastSync(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer lastChangeTime(@NativeType(value="XrTime") long value) {
            XrActionStateBoolean.nlastChangeTime(this.address(), value);
            return this;
        }

        public Buffer isActive(@NativeType(value="XrBool32") boolean value) {
            XrActionStateBoolean.nisActive(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

