/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.opus;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.opus.OPECloseFunc;
import org.lwjgl.util.opus.OPECloseFuncI;
import org.lwjgl.util.opus.OPEWriteFunc;
import org.lwjgl.util.opus.OPEWriteFuncI;

public class OpusEncCallbacks
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WRITE;
    public static final int CLOSE;

    public OpusEncCallbacks(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OpusEncCallbacks.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ope_write_func")
    public OPEWriteFunc write() {
        return OpusEncCallbacks.nwrite(this.address());
    }

    @NativeType(value="ope_close_func")
    public OPECloseFunc close$() {
        return OpusEncCallbacks.nclose$(this.address());
    }

    public OpusEncCallbacks write(@NativeType(value="ope_write_func") OPEWriteFuncI value) {
        OpusEncCallbacks.nwrite(this.address(), value);
        return this;
    }

    public OpusEncCallbacks close$(@NativeType(value="ope_close_func") OPECloseFuncI value) {
        OpusEncCallbacks.nclose$(this.address(), value);
        return this;
    }

    public OpusEncCallbacks set(OPEWriteFuncI write, OPECloseFuncI close$) {
        this.write(write);
        this.close$(close$);
        return this;
    }

    public OpusEncCallbacks set(OpusEncCallbacks src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OpusEncCallbacks malloc() {
        return (OpusEncCallbacks)OpusEncCallbacks.wrap(OpusEncCallbacks.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OpusEncCallbacks calloc() {
        return (OpusEncCallbacks)OpusEncCallbacks.wrap(OpusEncCallbacks.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OpusEncCallbacks create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (OpusEncCallbacks)OpusEncCallbacks.wrap(OpusEncCallbacks.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static OpusEncCallbacks create(long address) {
        return (OpusEncCallbacks)OpusEncCallbacks.wrap(OpusEncCallbacks.class, (long)address);
    }

    @Nullable
    public static OpusEncCallbacks createSafe(long address) {
        return address == 0L ? null : (OpusEncCallbacks)OpusEncCallbacks.wrap(OpusEncCallbacks.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)OpusEncCallbacks.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)OpusEncCallbacks.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)OpusEncCallbacks.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OpusEncCallbacks.__create((int)capacity, (int)SIZEOF);
        return (Buffer)OpusEncCallbacks.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)OpusEncCallbacks.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)OpusEncCallbacks.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static OpusEncCallbacks malloc(MemoryStack stack) {
        return (OpusEncCallbacks)OpusEncCallbacks.wrap(OpusEncCallbacks.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OpusEncCallbacks calloc(MemoryStack stack) {
        return (OpusEncCallbacks)OpusEncCallbacks.wrap(OpusEncCallbacks.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)OpusEncCallbacks.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)OpusEncCallbacks.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static OPEWriteFunc nwrite(long struct) {
        return OPEWriteFunc.create(MemoryUtil.memGetAddress((long)(struct + (long)WRITE)));
    }

    public static OPECloseFunc nclose$(long struct) {
        return OPECloseFunc.create(MemoryUtil.memGetAddress((long)(struct + (long)CLOSE)));
    }

    public static void nwrite(long struct, OPEWriteFuncI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)WRITE), (long)value.address());
    }

    public static void nclose$(long struct, OPECloseFuncI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CLOSE), (long)value.address());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)WRITE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)CLOSE)));
    }

    static {
        Struct.Layout layout = OpusEncCallbacks.__struct((Struct.Member[])new Struct.Member[]{OpusEncCallbacks.__member((int)POINTER_SIZE), OpusEncCallbacks.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WRITE = layout.offsetof(0);
        CLOSE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<OpusEncCallbacks, Buffer>
    implements NativeResource {
        private static final OpusEncCallbacks ELEMENT_FACTORY = OpusEncCallbacks.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected OpusEncCallbacks getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ope_write_func")
        public OPEWriteFunc write() {
            return OpusEncCallbacks.nwrite(this.address());
        }

        @NativeType(value="ope_close_func")
        public OPECloseFunc close$() {
            return OpusEncCallbacks.nclose$(this.address());
        }

        public Buffer write(@NativeType(value="ope_write_func") OPEWriteFuncI value) {
            OpusEncCallbacks.nwrite(this.address(), value);
            return this;
        }

        public Buffer close$(@NativeType(value="ope_close_func") OPECloseFuncI value) {
            OpusEncCallbacks.nclose$(this.address(), value);
            return this;
        }
    }
}

