/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LLVMTargetMachine {
    public static final int LLVMCodeGenLevelNone = 0;
    public static final int LLVMCodeGenLevelLess = 1;
    public static final int LLVMCodeGenLevelDefault = 2;
    public static final int LLVMCodeGenLevelAggressive = 3;
    public static final int LLVMRelocDefault = 0;
    public static final int LLVMRelocStatic = 1;
    public static final int LLVMRelocPIC = 2;
    public static final int LLVMRelocDynamicNoPic = 3;
    public static final int LLVMRelocROPI = 4;
    public static final int LLVMRelocRWPI = 5;
    public static final int LLVMRelocROPI_RWPI = 6;
    public static final int LLVMCodeModelDefault = 0;
    public static final int LLVMCodeModelJITDefault = 1;
    public static final int LLVMCodeModelTiny = 2;
    public static final int LLVMCodeModelSmall = 3;
    public static final int LLVMCodeModelKernel = 4;
    public static final int LLVMCodeModelMedium = 5;
    public static final int LLVMCodeModelLarge = 6;
    public static final int LLVMAssemblyFile = 0;
    public static final int LLVMObjectFile = 1;

    protected LLVMTargetMachine() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="LLVMTargetRef")
    public static long LLVMGetFirstTarget() {
        long __functionAddress = Functions.GetFirstTarget;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="LLVMTargetRef")
    public static long LLVMGetNextTarget(@NativeType(value="LLVMTargetRef") long T) {
        long __functionAddress = Functions.GetNextTarget;
        if (Checks.CHECKS) {
            Checks.check((long)T);
        }
        return JNI.invokePP((long)T, (long)__functionAddress);
    }

    public static long nLLVMGetTargetFromName(long Name) {
        long __functionAddress = Functions.GetTargetFromName;
        return JNI.invokePP((long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMTargetRef")
    public static long LLVMGetTargetFromName(@NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMTargetMachine.nLLVMGetTargetFromName(MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMTargetRef")
    public static long LLVMGetTargetFromName(@NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMTargetMachine.nLLVMGetTargetFromName(NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nLLVMGetTargetFromTriple(long Triple, long T, long ErrorMessage) {
        long __functionAddress = Functions.GetTargetFromTriple;
        return JNI.invokePPPI((long)Triple, (long)T, (long)ErrorMessage, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMGetTargetFromTriple(@NativeType(value="char const *") ByteBuffer Triple, @NativeType(value="LLVMTargetRef *") PointerBuffer T, @NativeType(value="char **") PointerBuffer ErrorMessage) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Triple);
            Checks.check((CustomBuffer)T, (int)1);
            Checks.check((CustomBuffer)ErrorMessage, (int)1);
        }
        return LLVMTargetMachine.nLLVMGetTargetFromTriple(MemoryUtil.memAddress((ByteBuffer)Triple), MemoryUtil.memAddress((CustomBuffer)T), MemoryUtil.memAddress((CustomBuffer)ErrorMessage)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMBool")
    public static boolean LLVMGetTargetFromTriple(@NativeType(value="char const *") CharSequence Triple, @NativeType(value="LLVMTargetRef *") PointerBuffer T, @NativeType(value="char **") PointerBuffer ErrorMessage) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)T, (int)1);
            Checks.check((CustomBuffer)ErrorMessage, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Triple, true);
            long TripleEncoded = stack.getPointerAddress();
            boolean bl = LLVMTargetMachine.nLLVMGetTargetFromTriple(TripleEncoded, MemoryUtil.memAddress((CustomBuffer)T), MemoryUtil.memAddress((CustomBuffer)ErrorMessage)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetTargetName(long T) {
        long __functionAddress = Functions.GetTargetName;
        if (Checks.CHECKS) {
            Checks.check((long)T);
        }
        return JNI.invokePP((long)T, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetTargetName(@NativeType(value="LLVMTargetRef") long T) {
        long __result = LLVMTargetMachine.nLLVMGetTargetName(T);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static long nLLVMGetTargetDescription(long T) {
        long __functionAddress = Functions.GetTargetDescription;
        if (Checks.CHECKS) {
            Checks.check((long)T);
        }
        return JNI.invokePP((long)T, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetTargetDescription(@NativeType(value="LLVMTargetRef") long T) {
        long __result = LLVMTargetMachine.nLLVMGetTargetDescription(T);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMTargetHasJIT(@NativeType(value="LLVMTargetRef") long T) {
        long __functionAddress = Functions.TargetHasJIT;
        if (Checks.CHECKS) {
            Checks.check((long)T);
        }
        return JNI.invokePI((long)T, (long)__functionAddress) != 0;
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMTargetHasTargetMachine(@NativeType(value="LLVMTargetRef") long T) {
        long __functionAddress = Functions.TargetHasTargetMachine;
        if (Checks.CHECKS) {
            Checks.check((long)T);
        }
        return JNI.invokePI((long)T, (long)__functionAddress) != 0;
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMTargetHasAsmBackend(@NativeType(value="LLVMTargetRef") long T) {
        long __functionAddress = Functions.TargetHasAsmBackend;
        if (Checks.CHECKS) {
            Checks.check((long)T);
        }
        return JNI.invokePI((long)T, (long)__functionAddress) != 0;
    }

    public static long nLLVMCreateTargetMachine(long T, long Triple, long CPU, long Features, int Level, int Reloc, int CodeModel) {
        long __functionAddress = Functions.CreateTargetMachine;
        if (Checks.CHECKS) {
            Checks.check((long)T);
        }
        return JNI.invokePPPPP((long)T, (long)Triple, (long)CPU, (long)Features, (int)Level, (int)Reloc, (int)CodeModel, (long)__functionAddress);
    }

    @NativeType(value="LLVMTargetMachineRef")
    public static long LLVMCreateTargetMachine(@NativeType(value="LLVMTargetRef") long T, @NativeType(value="char const *") ByteBuffer Triple, @NativeType(value="char const *") ByteBuffer CPU, @NativeType(value="char const *") ByteBuffer Features, @NativeType(value="LLVMCodeGenOptLevel") int Level, @NativeType(value="LLVMRelocMode") int Reloc, @NativeType(value="LLVMCodeModel") int CodeModel) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Triple);
            Checks.checkNT1((ByteBuffer)CPU);
            Checks.checkNT1((ByteBuffer)Features);
        }
        return LLVMTargetMachine.nLLVMCreateTargetMachine(T, MemoryUtil.memAddress((ByteBuffer)Triple), MemoryUtil.memAddress((ByteBuffer)CPU), MemoryUtil.memAddress((ByteBuffer)Features), Level, Reloc, CodeModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMTargetMachineRef")
    public static long LLVMCreateTargetMachine(@NativeType(value="LLVMTargetRef") long T, @NativeType(value="char const *") CharSequence Triple, @NativeType(value="char const *") CharSequence CPU, @NativeType(value="char const *") CharSequence Features, @NativeType(value="LLVMCodeGenOptLevel") int Level, @NativeType(value="LLVMRelocMode") int Reloc, @NativeType(value="LLVMCodeModel") int CodeModel) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Triple, true);
            long TripleEncoded = stack.getPointerAddress();
            stack.nUTF8(CPU, true);
            long CPUEncoded = stack.getPointerAddress();
            stack.nUTF8(Features, true);
            long FeaturesEncoded = stack.getPointerAddress();
            long l = LLVMTargetMachine.nLLVMCreateTargetMachine(T, TripleEncoded, CPUEncoded, FeaturesEncoded, Level, Reloc, CodeModel);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void LLVMDisposeTargetMachine(@NativeType(value="LLVMTargetMachineRef") long T) {
        long __functionAddress = Functions.DisposeTargetMachine;
        if (Checks.CHECKS) {
            Checks.check((long)T);
        }
        JNI.invokePV((long)T, (long)__functionAddress);
    }

    @NativeType(value="LLVMTargetRef")
    public static long LLVMGetTargetMachineTarget(@NativeType(value="LLVMTargetMachineRef") long T) {
        long __functionAddress = Functions.GetTargetMachineTarget;
        if (Checks.CHECKS) {
            Checks.check((long)T);
        }
        return JNI.invokePP((long)T, (long)__functionAddress);
    }

    public static long nLLVMGetTargetMachineTriple(long T) {
        long __functionAddress = Functions.GetTargetMachineTriple;
        if (Checks.CHECKS) {
            Checks.check((long)T);
        }
        return JNI.invokePP((long)T, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char *")
    public static String LLVMGetTargetMachineTriple(@NativeType(value="LLVMTargetMachineRef") long T) {
        long __result = LLVMTargetMachine.nLLVMGetTargetMachineTriple(T);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static long nLLVMGetTargetMachineCPU(long T) {
        long __functionAddress = Functions.GetTargetMachineCPU;
        if (Checks.CHECKS) {
            Checks.check((long)T);
        }
        return JNI.invokePP((long)T, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char *")
    public static String LLVMGetTargetMachineCPU(@NativeType(value="LLVMTargetMachineRef") long T) {
        long __result = LLVMTargetMachine.nLLVMGetTargetMachineCPU(T);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static long nLLVMGetTargetMachineFeatureString(long T) {
        long __functionAddress = Functions.GetTargetMachineFeatureString;
        if (Checks.CHECKS) {
            Checks.check((long)T);
        }
        return JNI.invokePP((long)T, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char *")
    public static String LLVMGetTargetMachineFeatureString(@NativeType(value="LLVMTargetMachineRef") long T) {
        long __result = LLVMTargetMachine.nLLVMGetTargetMachineFeatureString(T);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    @NativeType(value="LLVMTargetDataRef")
    public static long LLVMCreateTargetDataLayout(@NativeType(value="LLVMTargetMachineRef") long T) {
        long __functionAddress = Functions.CreateTargetDataLayout;
        if (Checks.CHECKS) {
            Checks.check((long)T);
        }
        return JNI.invokePP((long)T, (long)__functionAddress);
    }

    public static void LLVMSetTargetMachineAsmVerbosity(@NativeType(value="LLVMTargetMachineRef") long T, @NativeType(value="LLVMBool") boolean VerboseAsm) {
        long __functionAddress = Functions.SetTargetMachineAsmVerbosity;
        if (Checks.CHECKS) {
            Checks.check((long)T);
        }
        JNI.invokePV((long)T, (int)(VerboseAsm ? 1 : 0), (long)__functionAddress);
    }

    public static int nLLVMTargetMachineEmitToFile(long T, long M, long Filename, int codegen, long ErrorMessage) {
        long __functionAddress = Functions.TargetMachineEmitToFile;
        if (Checks.CHECKS) {
            Checks.check((long)T);
            Checks.check((long)M);
        }
        return JNI.invokePPPPI((long)T, (long)M, (long)Filename, (int)codegen, (long)ErrorMessage, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMTargetMachineEmitToFile(@NativeType(value="LLVMTargetMachineRef") long T, @NativeType(value="LLVMModuleRef") long M, @NativeType(value="char *") ByteBuffer Filename, @NativeType(value="LLVMCodeGenFileType") int codegen, @NativeType(value="char **") PointerBuffer ErrorMessage) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Filename);
            Checks.check((CustomBuffer)ErrorMessage, (int)1);
        }
        return LLVMTargetMachine.nLLVMTargetMachineEmitToFile(T, M, MemoryUtil.memAddress((ByteBuffer)Filename), codegen, MemoryUtil.memAddress((CustomBuffer)ErrorMessage)) != 0;
    }

    public static int nLLVMTargetMachineEmitToMemoryBuffer(long T, long M, int codegen, long ErrorMessage, long OutMemBuf) {
        long __functionAddress = Functions.TargetMachineEmitToMemoryBuffer;
        if (Checks.CHECKS) {
            Checks.check((long)T);
            Checks.check((long)M);
        }
        return JNI.invokePPPPI((long)T, (long)M, (int)codegen, (long)ErrorMessage, (long)OutMemBuf, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMTargetMachineEmitToMemoryBuffer(@NativeType(value="LLVMTargetMachineRef") long T, @NativeType(value="LLVMModuleRef") long M, @NativeType(value="LLVMCodeGenFileType") int codegen, @NativeType(value="char **") PointerBuffer ErrorMessage, @NativeType(value="LLVMMemoryBufferRef *") PointerBuffer OutMemBuf) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)ErrorMessage, (int)1);
            Checks.check((CustomBuffer)OutMemBuf, (int)1);
        }
        return LLVMTargetMachine.nLLVMTargetMachineEmitToMemoryBuffer(T, M, codegen, MemoryUtil.memAddress((CustomBuffer)ErrorMessage), MemoryUtil.memAddress((CustomBuffer)OutMemBuf)) != 0;
    }

    public static long nLLVMGetDefaultTargetTriple() {
        long __functionAddress = Functions.GetDefaultTargetTriple;
        return JNI.invokeP((long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char *")
    public static String LLVMGetDefaultTargetTriple() {
        long __result = LLVMTargetMachine.nLLVMGetDefaultTargetTriple();
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static long nLLVMNormalizeTargetTriple(long triple) {
        long __functionAddress = Functions.NormalizeTargetTriple;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.invokePP((long)triple, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char *")
    public static String LLVMNormalizeTargetTriple(@NativeType(value="char const *") ByteBuffer triple) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)triple);
        }
        long __result = LLVMTargetMachine.nLLVMNormalizeTargetTriple(MemoryUtil.memAddress((ByteBuffer)triple));
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char *")
    public static String LLVMNormalizeTargetTriple(@NativeType(value="char const *") CharSequence triple) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(triple, true);
            long tripleEncoded = stack.getPointerAddress();
            long __result = LLVMTargetMachine.nLLVMNormalizeTargetTriple(tripleEncoded);
            String string = MemoryUtil.memUTF8Safe((long)__result);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetHostCPUName() {
        long __functionAddress = Functions.GetHostCPUName;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.invokeP((long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char *")
    public static String LLVMGetHostCPUName() {
        long __result = LLVMTargetMachine.nLLVMGetHostCPUName();
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static long nLLVMGetHostCPUFeatures() {
        long __functionAddress = Functions.GetHostCPUFeatures;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.invokeP((long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char *")
    public static String LLVMGetHostCPUFeatures() {
        long __result = LLVMTargetMachine.nLLVMGetHostCPUFeatures();
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static void LLVMAddAnalysisPasses(@NativeType(value="LLVMTargetMachineRef") long T, @NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddAnalysisPasses;
        if (Checks.CHECKS) {
            Checks.check((long)T);
            Checks.check((long)PM);
        }
        JNI.invokePPV((long)T, (long)PM, (long)__functionAddress);
    }

    public static final class Functions {
        public static final long GetFirstTarget = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetFirstTarget");
        public static final long GetNextTarget = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetNextTarget");
        public static final long GetTargetFromName = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetTargetFromName");
        public static final long GetTargetFromTriple = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetTargetFromTriple");
        public static final long GetTargetName = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetTargetName");
        public static final long GetTargetDescription = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetTargetDescription");
        public static final long TargetHasJIT = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMTargetHasJIT");
        public static final long TargetHasTargetMachine = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMTargetHasTargetMachine");
        public static final long TargetHasAsmBackend = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMTargetHasAsmBackend");
        public static final long CreateTargetMachine = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMCreateTargetMachine");
        public static final long DisposeTargetMachine = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDisposeTargetMachine");
        public static final long GetTargetMachineTarget = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetTargetMachineTarget");
        public static final long GetTargetMachineTriple = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetTargetMachineTriple");
        public static final long GetTargetMachineCPU = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetTargetMachineCPU");
        public static final long GetTargetMachineFeatureString = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetTargetMachineFeatureString");
        public static final long CreateTargetDataLayout = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMCreateTargetDataLayout");
        public static final long SetTargetMachineAsmVerbosity = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMSetTargetMachineAsmVerbosity");
        public static final long TargetMachineEmitToFile = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMTargetMachineEmitToFile");
        public static final long TargetMachineEmitToMemoryBuffer = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMTargetMachineEmitToMemoryBuffer");
        public static final long GetDefaultTargetTriple = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetDefaultTargetTriple");
        public static final long NormalizeTargetTriple = LLVMCore.getLibrary().getFunctionAddress((CharSequence)"LLVMNormalizeTargetTriple");
        public static final long GetHostCPUName = LLVMCore.getLibrary().getFunctionAddress((CharSequence)"LLVMGetHostCPUName");
        public static final long GetHostCPUFeatures = LLVMCore.getLibrary().getFunctionAddress((CharSequence)"LLVMGetHostCPUFeatures");
        public static final long AddAnalysisPasses = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMAddAnalysisPasses");

        private Functions() {
        }
    }
}

