/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LLVMBitWriter {
    protected LLVMBitWriter() {
        throw new UnsupportedOperationException();
    }

    public static int nLLVMWriteBitcodeToFile(long M, long Path) {
        long __functionAddress = Functions.WriteBitcodeToFile;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePPI((long)M, (long)Path, (long)__functionAddress);
    }

    public static int LLVMWriteBitcodeToFile(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Path) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Path);
        }
        return LLVMBitWriter.nLLVMWriteBitcodeToFile(M, MemoryUtil.memAddress((ByteBuffer)Path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int LLVMWriteBitcodeToFile(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Path) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Path, true);
            long PathEncoded = stack.getPointerAddress();
            int n = LLVMBitWriter.nLLVMWriteBitcodeToFile(M, PathEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int LLVMWriteBitcodeToFD(@NativeType(value="LLVMModuleRef") long M, int FD, int ShouldClose, int Unbuffered) {
        long __functionAddress = Functions.WriteBitcodeToFD;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePI((long)M, (int)FD, (int)ShouldClose, (int)Unbuffered, (long)__functionAddress);
    }

    public static int LLVMWriteBitcodeToFileHandle(@NativeType(value="LLVMModuleRef") long M, int Handle) {
        long __functionAddress = Functions.WriteBitcodeToFileHandle;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePI((long)M, (int)Handle, (long)__functionAddress);
    }

    @NativeType(value="LLVMMemoryBufferRef")
    public static long LLVMWriteBitcodeToMemoryBuffer(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.WriteBitcodeToMemoryBuffer;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePP((long)M, (long)__functionAddress);
    }

    public static final class Functions {
        public static final long WriteBitcodeToFile = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMWriteBitcodeToFile");
        public static final long WriteBitcodeToFD = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMWriteBitcodeToFD");
        public static final long WriteBitcodeToFileHandle = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMWriteBitcodeToFileHandle");
        public static final long WriteBitcodeToMemoryBuffer = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMWriteBitcodeToMemoryBuffer");

        private Functions() {
        }
    }
}

