/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUaccessPolicyWindow
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BASE_PTR;
    public static final int NUM_BYTES;
    public static final int HITRATIO;
    public static final int HITPROP;
    public static final int MISSPROP;

    public CUaccessPolicyWindow(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUaccessPolicyWindow.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long base_ptr() {
        return CUaccessPolicyWindow.nbase_ptr(this.address());
    }

    @NativeType(value="size_t")
    public long num_bytes() {
        return CUaccessPolicyWindow.nnum_bytes(this.address());
    }

    public float hitRatio() {
        return CUaccessPolicyWindow.nhitRatio(this.address());
    }

    @NativeType(value="CUaccessProperty")
    public int hitProp() {
        return CUaccessPolicyWindow.nhitProp(this.address());
    }

    @NativeType(value="CUaccessProperty")
    public int missProp() {
        return CUaccessPolicyWindow.nmissProp(this.address());
    }

    public CUaccessPolicyWindow base_ptr(@NativeType(value="void *") long value) {
        CUaccessPolicyWindow.nbase_ptr(this.address(), value);
        return this;
    }

    public CUaccessPolicyWindow num_bytes(@NativeType(value="size_t") long value) {
        CUaccessPolicyWindow.nnum_bytes(this.address(), value);
        return this;
    }

    public CUaccessPolicyWindow hitRatio(float value) {
        CUaccessPolicyWindow.nhitRatio(this.address(), value);
        return this;
    }

    public CUaccessPolicyWindow hitProp(@NativeType(value="CUaccessProperty") int value) {
        CUaccessPolicyWindow.nhitProp(this.address(), value);
        return this;
    }

    public CUaccessPolicyWindow missProp(@NativeType(value="CUaccessProperty") int value) {
        CUaccessPolicyWindow.nmissProp(this.address(), value);
        return this;
    }

    public CUaccessPolicyWindow set(long base_ptr, long num_bytes, float hitRatio, int hitProp, int missProp) {
        this.base_ptr(base_ptr);
        this.num_bytes(num_bytes);
        this.hitRatio(hitRatio);
        this.hitProp(hitProp);
        this.missProp(missProp);
        return this;
    }

    public CUaccessPolicyWindow set(CUaccessPolicyWindow src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUaccessPolicyWindow malloc() {
        return (CUaccessPolicyWindow)CUaccessPolicyWindow.wrap(CUaccessPolicyWindow.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CUaccessPolicyWindow calloc() {
        return (CUaccessPolicyWindow)CUaccessPolicyWindow.wrap(CUaccessPolicyWindow.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CUaccessPolicyWindow create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CUaccessPolicyWindow)CUaccessPolicyWindow.wrap(CUaccessPolicyWindow.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CUaccessPolicyWindow create(long address) {
        return (CUaccessPolicyWindow)CUaccessPolicyWindow.wrap(CUaccessPolicyWindow.class, (long)address);
    }

    @Nullable
    public static CUaccessPolicyWindow createSafe(long address) {
        return address == 0L ? null : (CUaccessPolicyWindow)CUaccessPolicyWindow.wrap(CUaccessPolicyWindow.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CUaccessPolicyWindow.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CUaccessPolicyWindow.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CUaccessPolicyWindow.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUaccessPolicyWindow.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CUaccessPolicyWindow.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CUaccessPolicyWindow.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CUaccessPolicyWindow.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static CUaccessPolicyWindow malloc(MemoryStack stack) {
        return (CUaccessPolicyWindow)CUaccessPolicyWindow.wrap(CUaccessPolicyWindow.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CUaccessPolicyWindow calloc(MemoryStack stack) {
        return (CUaccessPolicyWindow)CUaccessPolicyWindow.wrap(CUaccessPolicyWindow.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)CUaccessPolicyWindow.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)CUaccessPolicyWindow.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nbase_ptr(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)BASE_PTR));
    }

    public static long nnum_bytes(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NUM_BYTES));
    }

    public static float nhitRatio(long struct) {
        return UNSAFE.getFloat(null, struct + (long)HITRATIO);
    }

    public static int nhitProp(long struct) {
        return UNSAFE.getInt(null, struct + (long)HITPROP);
    }

    public static int nmissProp(long struct) {
        return UNSAFE.getInt(null, struct + (long)MISSPROP);
    }

    public static void nbase_ptr(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BASE_PTR), (long)Checks.check((long)value));
    }

    public static void nnum_bytes(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NUM_BYTES), (long)value);
    }

    public static void nhitRatio(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)HITRATIO, value);
    }

    public static void nhitProp(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HITPROP, value);
    }

    public static void nmissProp(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MISSPROP, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)BASE_PTR)));
    }

    static {
        Struct.Layout layout = CUaccessPolicyWindow.__struct((Struct.Member[])new Struct.Member[]{CUaccessPolicyWindow.__member((int)POINTER_SIZE), CUaccessPolicyWindow.__member((int)POINTER_SIZE), CUaccessPolicyWindow.__member((int)4), CUaccessPolicyWindow.__member((int)4), CUaccessPolicyWindow.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BASE_PTR = layout.offsetof(0);
        NUM_BYTES = layout.offsetof(1);
        HITRATIO = layout.offsetof(2);
        HITPROP = layout.offsetof(3);
        MISSPROP = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<CUaccessPolicyWindow, Buffer>
    implements NativeResource {
        private static final CUaccessPolicyWindow ELEMENT_FACTORY = CUaccessPolicyWindow.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CUaccessPolicyWindow getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public long base_ptr() {
            return CUaccessPolicyWindow.nbase_ptr(this.address());
        }

        @NativeType(value="size_t")
        public long num_bytes() {
            return CUaccessPolicyWindow.nnum_bytes(this.address());
        }

        public float hitRatio() {
            return CUaccessPolicyWindow.nhitRatio(this.address());
        }

        @NativeType(value="CUaccessProperty")
        public int hitProp() {
            return CUaccessPolicyWindow.nhitProp(this.address());
        }

        @NativeType(value="CUaccessProperty")
        public int missProp() {
            return CUaccessPolicyWindow.nmissProp(this.address());
        }

        public Buffer base_ptr(@NativeType(value="void *") long value) {
            CUaccessPolicyWindow.nbase_ptr(this.address(), value);
            return this;
        }

        public Buffer num_bytes(@NativeType(value="size_t") long value) {
            CUaccessPolicyWindow.nnum_bytes(this.address(), value);
            return this;
        }

        public Buffer hitRatio(float value) {
            CUaccessPolicyWindow.nhitRatio(this.address(), value);
            return this;
        }

        public Buffer hitProp(@NativeType(value="CUaccessProperty") int value) {
            CUaccessPolicyWindow.nhitProp(this.address(), value);
            return this;
        }

        public Buffer missProp(@NativeType(value="CUaccessProperty") int value) {
            CUaccessPolicyWindow.nmissProp(this.address(), value);
            return this;
        }
    }
}

