/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kafka.api.LeaderAndIsr;
import kafka.server.AlterPartitionManager;
import kafka.server.IsrChangePropagationConfig;
import kafka.server.ZkAlterPartitionManager$;
import kafka.utils.Logging;
import kafka.utils.ReplicationUtils$;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidUpdateVersionException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.mutable.HashSet;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005mr!\u0002\f\u0018\u0011\u0003ab!\u0002\u0010\u0018\u0011\u0003y\u0002\"\u0002\u0014\u0002\t\u00039\u0003b\u0002\u0015\u0002\u0001\u0004%\t!\u000b\u0005\b[\u0005\u0001\r\u0011\"\u0001/\u0011\u0019!\u0014\u0001)Q\u0005U\u0019!ad\u0006\u0001:\u0011!\u0019eA!A!\u0002\u0013!\u0005\u0002C$\u0007\u0005\u0003\u0005\u000b\u0011\u0002%\t\u0011Q3!\u0011!Q\u0001\nUCQA\n\u0004\u0005\u0002mCq\u0001\u0019\u0004C\u0002\u0013%\u0011\u0006\u0003\u0004b\r\u0001\u0006IA\u000b\u0005\tE\u001a\u0011\r\u0011\"\u0001\u0018G\"1\u0001O\u0002Q\u0001\n\u0011Dq!\u001d\u0004C\u0002\u0013%!\u000f\u0003\u0004\u0000\r\u0001\u0006Ia\u001d\u0005\t\u0003\u00031!\u0019!C\u0005e\"9\u00111\u0001\u0004!\u0002\u0013\u0019\bbBA\u0003\r\u0011\u0005\u0013q\u0001\u0005\b\u0003\u00131A\u0011IA\u0006\u0011!\tID\u0002C\u0001/\u0005\u001d\u0011a\u0006.l\u00032$XM\u001d)beRLG/[8o\u001b\u0006t\u0017mZ3s\u0015\tA\u0012$\u0001\u0004tKJ4XM\u001d\u0006\u00025\u0005)1.\u00194lC\u000e\u0001\u0001CA\u000f\u0002\u001b\u00059\"a\u0006.l\u00032$XM\u001d)beRLG/[8o\u001b\u0006t\u0017mZ3s'\t\t\u0001\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\t1\u0004R3gCVdG/S:s!J|\u0007/Y4bi&|gnQ8oM&<W#\u0001\u0016\u0011\u0005uY\u0013B\u0001\u0017\u0018\u0005iI5O]\"iC:<W\r\u0015:pa\u0006<\u0017\r^5p]\u000e{gNZ5h\u0003}!UMZ1vYRL5O\u001d)s_B\fw-\u0019;j_:\u001cuN\u001c4jO~#S-\u001d\u000b\u0003_I\u0002\"!\t\u0019\n\u0005E\u0012#\u0001B+oSRDqa\r\u0003\u0002\u0002\u0003\u0007!&A\u0002yIE\nA\u0004R3gCVdG/S:s!J|\u0007/Y4bi&|gnQ8oM&<\u0007\u0005\u000b\u0002\u0006mA\u0011\u0011eN\u0005\u0003q\t\u0012\u0001B^8mCRLG.Z\n\u0005\r\u0001RT\b\u0005\u0002\u001ew%\u0011Ah\u0006\u0002\u0016\u00032$XM\u001d)beRLG/[8o\u001b\u0006t\u0017mZ3s!\tq\u0014)D\u0001@\u0015\t\u0001\u0015$A\u0003vi&d7/\u0003\u0002C\u007f\t9Aj\\4hS:<\u0017!C:dQ\u0016$W\u000f\\3s!\tqT)\u0003\u0002G\u007f\tI1k\u00195fIVdWM]\u0001\u0005i&lW\r\u0005\u0002J%6\t!J\u0003\u0002A\u0017*\u0011A*T\u0001\u0007G>lWn\u001c8\u000b\u0005iq%BA(Q\u0003\u0019\t\u0007/Y2iK*\t\u0011+A\u0002pe\u001eL!a\u0015&\u0003\tQKW.Z\u0001\tu.\u001cE.[3oiB\u0011a+W\u0007\u0002/*\u0011\u0001,G\u0001\u0003u.L!AW,\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u)\u0011aVLX0\u0011\u0005u1\u0001\"B\"\u000b\u0001\u0004!\u0005\"B$\u000b\u0001\u0004A\u0005\"\u0002+\u000b\u0001\u0004)\u0016aG5te\u000eC\u0017M\\4f\u001d>$\u0018NZ5dCRLwN\\\"p]\u001aLw-\u0001\u000fjgJ\u001c\u0005.\u00198hK:{G/\u001b4jG\u0006$\u0018n\u001c8D_:4\u0017n\u001a\u0011\u0002\u0019%\u001c(o\u00115b]\u001e,7+\u001a;\u0016\u0003\u0011\u00042!\u001a6m\u001b\u00051'BA4i\u0003\u001diW\u000f^1cY\u0016T!!\u001b\u0012\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002lM\n\u00191+\u001a;\u0011\u00055tW\"A&\n\u0005=\\%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u000eSN\u00148\t[1oO\u0016\u001cV\r\u001e\u0011\u0002\u001f1\f7\u000f^%te\u000eC\u0017M\\4f\u001bN,\u0012a\u001d\t\u0003ivl\u0011!\u001e\u0006\u0003m^\fa!\u0019;p[&\u001c'B\u0001=z\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003un\fA!\u001e;jY*\tA0\u0001\u0003kCZ\f\u0017B\u0001@v\u0005)\tEo\\7jG2{gnZ\u0001\u0011Y\u0006\u001cH/S:s\u0007\"\fgnZ3Ng\u0002\nA\u0003\\1ti&\u001b(\u000f\u0015:pa\u0006<\u0017\r^5p]6\u001b\u0018!\u00067bgRL5O\u001d)s_B\fw-\u0019;j_:l5\u000fI\u0001\u0006gR\f'\u000f\u001e\u000b\u0002_\u000511/\u001e2nSR$\u0002\"!\u0004\u0002\"\u0005-\u0012q\u0006\t\u0007\u0003\u001f\t\t\"!\u0006\u000e\u0003]L1!a\u0005x\u0005E\u0019u.\u001c9mKR\f'\r\\3GkR,(/\u001a\t\u0005\u0003/\ti\"\u0004\u0002\u0002\u001a)\u0019\u00111D\r\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002 \u0005e!\u0001\u0004'fC\u0012,'/\u00118e\u0013N\u0014\bbBA\u0012)\u0001\u0007\u0011QE\u0001\u0011i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u00042!\\A\u0014\u0013\r\tIc\u0013\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:Dq!!\f\u0015\u0001\u0004\t)\"\u0001\u0007mK\u0006$WM]!oI&\u001b(\u000fC\u0004\u00022Q\u0001\r!a\r\u0002\u001f\r|g\u000e\u001e:pY2,'/\u00129pG\"\u00042!IA\u001b\u0013\r\t9D\t\u0002\u0004\u0013:$\u0018\u0001G7bs\n,\u0007K]8qC\u001e\fG/Z%te\u000eC\u0017M\\4fg\u0002")
public class ZkAlterPartitionManager
implements AlterPartitionManager,
Logging {
    private final Scheduler scheduler;
    private final Time time;
    private final KafkaZkClient zkClient;
    private final IsrChangePropagationConfig isrChangeNotificationConfig;
    private final scala.collection.mutable.Set<TopicPartition> isrChangeSet;
    private final AtomicLong lastIsrChangeMs;
    private final AtomicLong lastIsrPropagationMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void DefaultIsrPropagationConfig_$eq(IsrChangePropagationConfig isrChangePropagationConfig) {
        ZkAlterPartitionManager$.MODULE$.DefaultIsrPropagationConfig_$eq(isrChangePropagationConfig);
    }

    public static IsrChangePropagationConfig DefaultIsrPropagationConfig() {
        return ZkAlterPartitionManager$.MODULE$.DefaultIsrPropagationConfig();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public void shutdown() {
        AlterPartitionManager.shutdown$(this);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private IsrChangePropagationConfig isrChangeNotificationConfig() {
        return this.isrChangeNotificationConfig;
    }

    public scala.collection.mutable.Set<TopicPartition> isrChangeSet() {
        return this.isrChangeSet;
    }

    private AtomicLong lastIsrChangeMs() {
        return this.lastIsrChangeMs;
    }

    private AtomicLong lastIsrPropagationMs() {
        return this.lastIsrPropagationMs;
    }

    @Override
    public void start() {
        String x$1 = "isr-change-propagation";
        JFunction0.mcV.sp & Serializable & scala.Serializable x$2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.maybePropagateIsrChanges();
        long x$3 = this.isrChangeNotificationConfig().checkIntervalMs();
        TimeUnit x$4 = TimeUnit.MILLISECONDS;
        long x$5 = this.scheduler.schedule$default$3();
        this.scheduler.schedule(x$1, (Function0<BoxedUnit>)x$2, x$5, x$3, x$4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompletableFuture<LeaderAndIsr> submit(TopicIdPartition topicIdPartition, LeaderAndIsr leaderAndIsr, int controllerEpoch) {
        void var5_5;
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Writing new ISR ").append(leaderAndIsr.isr()).append(" to ZooKeeper with version ").append(leaderAndIsr.partitionEpoch()).append(" for partition ").append(topicIdPartition).toString());
        Tuple2<Object, Object> tuple2 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkClient, topicIdPartition.topicPartition(), leaderAndIsr, controllerEpoch);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean updateSucceeded = tuple2._1$mcZ$sp();
        int newVersion = tuple2._2$mcI$sp();
        CompletableFuture<LeaderAndIsr> future = new CompletableFuture<LeaderAndIsr>();
        if (var5_5 != false) {
            void var6_6;
            scala.collection.mutable.Set<TopicPartition> set = this.isrChangeSet();
            synchronized (set) {
                this.isrChangeSet().$plus$eq((Object)topicIdPartition.topicPartition());
                this.lastIsrChangeMs().set(this.time.milliseconds());
            }
            future.complete(leaderAndIsr.withPartitionEpoch((int)var6_6));
        } else {
            future.completeExceptionally((Throwable)new InvalidUpdateVersionException(new StringBuilder(86).append("ISR update ").append(leaderAndIsr).append(" for partition ").append(topicIdPartition).append(" with controller epoch ").append(controllerEpoch).append(" ").append("failed with an invalid version error").toString()));
        }
        return future;
    }

    public void maybePropagateIsrChanges() {
        long now = this.time.milliseconds();
        scala.collection.mutable.Set<TopicPartition> set = this.isrChangeSet();
        synchronized (set) {
            if (this.isrChangeSet().nonEmpty() && (this.lastIsrChangeMs().get() + this.isrChangeNotificationConfig().lingerMs() < now || this.lastIsrPropagationMs().get() + this.isrChangeNotificationConfig().maxDelayMs() < now)) {
                this.zkClient.propagateIsrChanges((Set<TopicPartition>)this.isrChangeSet());
                this.isrChangeSet().clear();
                this.lastIsrPropagationMs().set(now);
            }
            return;
        }
    }

    public ZkAlterPartitionManager(Scheduler scheduler, Time time, KafkaZkClient zkClient) {
        this.scheduler = scheduler;
        this.time = time;
        this.zkClient = zkClient;
        AlterPartitionManager.$init$(this);
        Logging.$init$(this);
        this.isrChangeNotificationConfig = ZkAlterPartitionManager$.MODULE$.DefaultIsrPropagationConfig();
        this.isrChangeSet = new HashSet();
        this.lastIsrChangeMs = new AtomicLong(time.milliseconds());
        this.lastIsrPropagationMs = new AtomicLong(time.milliseconds());
    }
}

