/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.accessibility.Accessible;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.gui.widgets.TextContextualPopupMenu;

public class JosmComboBox<E>
extends JComboBox<E> {
    public JosmComboBox() {
        this.init(null);
    }

    public JosmComboBox(E prototypeDisplayValue) {
        this.init(prototypeDisplayValue);
    }

    public JosmComboBox(ComboBoxModel<E> aModel) {
        super(aModel);
        ArrayList list = new ArrayList(aModel.getSize());
        for (int i = 0; i < aModel.getSize(); ++i) {
            list.add(aModel.getElementAt(i));
        }
        this.init(this.findPrototypeDisplayValue(list));
    }

    public JosmComboBox(E[] items) {
        super(items);
        this.init(this.findPrototypeDisplayValue(Arrays.asList(items)));
    }

    public JTextField getEditorComponent() {
        return (JTextField)this.getEditor().getEditorComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final E findPrototypeDisplayValue(Collection<E> possibleValues) {
        E result = null;
        int maxHeight = -1;
        if (possibleValues != null) {
            Object oldPrototype = this.getPrototypeDisplayValue();
            JList<Object> list = this.getList();
            try {
                int i = 0;
                for (E value : possibleValues) {
                    Component c;
                    if (value != null && (c = this.getRenderer().getListCellRendererComponent(list, value, i, true, true)) != null) {
                        Dimension dim = c.getPreferredSize();
                        if (dim.height > maxHeight) {
                            maxHeight = dim.height;
                            result = value;
                        }
                    }
                    ++i;
                }
            }
            finally {
                this.setPrototypeDisplayValue(oldPrototype);
            }
        }
        return result;
    }

    protected final JList<Object> getList() {
        for (int i = 0; i < this.getUI().getAccessibleChildrenCount(this); ++i) {
            Accessible child = this.getUI().getAccessibleChild(this, i);
            if (!(child instanceof ComboPopup)) continue;
            return ((ComboPopup)((Object)child)).getList();
        }
        return null;
    }

    protected final void init(E prototype) {
        if (prototype != null) {
            this.setPrototypeDisplayValue(prototype);
            int screenHeight = GuiHelper.getScreenSize().height;
            int maxsize = screenHeight / this.getPreferredSize().height / 2;
            JList<Object> list = this.getList();
            if (list != null) {
                int height;
                if (!prototype.equals(list.getPrototypeCellValue())) {
                    list.setPrototypeCellValue(prototype);
                }
                if ((height = list.getFixedCellHeight()) > 0) {
                    maxsize = screenHeight / height / 2;
                }
            }
            this.setMaximumRowCount(Math.max(this.getMaximumRowCount(), maxsize));
        }
        ContextMenuHandler handler = new ContextMenuHandler();
        this.addPropertyChangeListener("editable", handler);
        this.addPropertyChangeListener("editor", handler);
    }

    public final void reinitialize(Collection<E> values) {
        this.init(this.findPrototypeDisplayValue(values));
    }

    protected class ContextMenuHandler
    extends MouseAdapter
    implements PropertyChangeListener {
        private JTextComponent component;
        private PopupMenuLauncher launcher;

        protected ContextMenuHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("editable".equals(evt.getPropertyName())) {
                if (evt.getNewValue().equals(Boolean.TRUE)) {
                    this.enableMenu();
                } else {
                    this.disableMenu();
                }
            } else if ("editor".equals(evt.getPropertyName())) {
                this.disableMenu();
                if (JosmComboBox.this.isEditable()) {
                    this.enableMenu();
                }
            }
        }

        private void enableMenu() {
            Component editorComponent;
            if (this.launcher == null && JosmComboBox.this.editor != null && (editorComponent = JosmComboBox.this.editor.getEditorComponent()) instanceof JTextComponent) {
                this.component = (JTextComponent)editorComponent;
                this.component.addMouseListener(this);
                this.launcher = TextContextualPopupMenu.enableMenuFor(this.component, true);
            }
        }

        private void disableMenu() {
            if (this.launcher != null) {
                TextContextualPopupMenu.disableMenuFor(this.component, this.launcher);
                this.launcher = null;
                this.component.removeMouseListener(this);
                this.component = null;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.processEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.processEvent(e);
        }

        private void processEvent(MouseEvent e) {
            if (this.launcher != null && !e.isPopupTrigger() && this.launcher.getMenu().isShowing()) {
                this.launcher.getMenu().setVisible(false);
            }
        }
    }
}

