/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.DefaultComboBoxModel;
import org.openstreetmap.josm.data.tagging.ac.AutoCompletionItem;

class ComboBoxHistory
extends DefaultComboBoxModel<AutoCompletionItem>
implements Iterable<AutoCompletionItem> {
    private final int maxSize;

    ComboBoxHistory(int size) {
        this.maxSize = size;
    }

    @Override
    public void addElement(String s) {
        this.addElement(new AutoCompletionItem(s));
    }

    @Override
    public void addElement(AutoCompletionItem o) {
        String newEntry = o.getValue();
        for (int i = 0; i < this.getSize(); ++i) {
            String oldEntry = ((AutoCompletionItem)this.getElementAt(i)).getValue();
            if (!oldEntry.equals(newEntry)) continue;
            this.removeElementAt(i);
        }
        this.insertElementAt(o, 0);
        if (this.getSize() > this.maxSize) {
            this.removeElementAt(this.getSize() - 1);
        }
        this.setSelectedItem(o);
    }

    @Override
    public Iterator<AutoCompletionItem> iterator() {
        return new Iterator<AutoCompletionItem>(){
            private int position = -1;

            @Override
            public void remove() {
                ComboBoxHistory.this.removeElementAt(this.position);
            }

            @Override
            public boolean hasNext() {
                return this.position < ComboBoxHistory.this.getSize() - 1 && ComboBoxHistory.this.getSize() > 0;
            }

            @Override
            public AutoCompletionItem next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.position;
                return (AutoCompletionItem)ComboBoxHistory.this.getElementAt(this.position);
            }
        };
    }

    public void setItemsAsString(List<String> items) {
        this.removeAllElements();
        for (int i = items.size() - 1; i >= 0; --i) {
            this.addElement(items.get(i));
        }
    }

    public List<String> asStringList() {
        ArrayList<String> list = new ArrayList<String>(this.maxSize);
        for (AutoCompletionItem item : this) {
            list.add(item.getValue());
        }
        return list;
    }
}

