/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.validator;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.openstreetmap.josm.data.preferences.sources.ValidatorPrefHelper;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ValidatorTestsPreference
implements SubPreferenceSetting {
    private JCheckBox prefUseIgnore;
    private JCheckBox prefUseLayer;
    private JCheckBox prefOtherUpload;
    private JCheckBox prefOther;
    private Collection<Test> allTests;

    @Override
    public void addGui(PreferenceTabbedPane gui) {
        VerticallyScrollablePanel testPanel = new VerticallyScrollablePanel(new GridBagLayout());
        testPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.prefUseIgnore = new JCheckBox(I18n.tr("Use ignore list.", new Object[0]), (boolean)ValidatorPrefHelper.PREF_USE_IGNORE.get());
        this.prefUseIgnore.setToolTipText(I18n.tr("Use the ignore list to suppress warnings.", new Object[0]));
        testPanel.add((Component)this.prefUseIgnore, GBC.eol());
        this.prefUseLayer = new JCheckBox(I18n.tr("Use error layer.", new Object[0]), (boolean)ValidatorPrefHelper.PREF_LAYER.get());
        this.prefUseLayer.setToolTipText(I18n.tr("Use the error layer to display problematic elements.", new Object[0]));
        testPanel.add((Component)this.prefUseLayer, GBC.eol());
        this.prefOther = new JCheckBox(I18n.tr("Show informational level.", new Object[0]), (boolean)ValidatorPrefHelper.PREF_OTHER.get());
        this.prefOther.setToolTipText(I18n.tr("Show the informational tests.", new Object[0]));
        testPanel.add((Component)this.prefOther, GBC.eol());
        this.prefOtherUpload = new JCheckBox(I18n.tr("Show informational level on upload.", new Object[0]), (boolean)ValidatorPrefHelper.PREF_OTHER_UPLOAD.get());
        this.prefOtherUpload.setToolTipText(I18n.tr("Show the informational tests in the upload check windows.", new Object[0]));
        testPanel.add((Component)this.prefOtherUpload, GBC.eol());
        ActionListener otherUploadEnabled = e -> this.prefOtherUpload.setEnabled(this.prefOther.isSelected());
        this.prefOther.addActionListener(otherUploadEnabled);
        otherUploadEnabled.actionPerformed(null);
        GBC a = GBC.eol().insets(-5, 0, 0, 0);
        a.anchor = 13;
        testPanel.add((Component)new JLabel(I18n.tr("On demand", new Object[0])), GBC.std());
        testPanel.add((Component)new JLabel(I18n.tr("On upload", new Object[0])), a);
        this.allTests = OsmValidator.getTests();
        for (Test test : this.allTests) {
            test.addGui(testPanel);
        }
        gui.getValidatorPreference().addSubTab(this, I18n.tr("Tests", new Object[0]), GuiHelper.embedInVerticalScrollPane(testPanel), I18n.tr("Choose tests to enable", new Object[0]));
    }

    @Override
    public boolean ok() {
        LinkedList<String> tests = new LinkedList<String>();
        LinkedList<String> testsBeforeUpload = new LinkedList<String>();
        for (Test test : this.allTests) {
            test.ok();
            String name = test.getClass().getName();
            if (!test.enabled) {
                tests.add(name);
            }
            if (test.testBeforeUpload) continue;
            testsBeforeUpload.add(name);
        }
        ArrayList<Test> testsToInitialize = new ArrayList<Test>(this.allTests);
        testsToInitialize.remove(OsmValidator.getTest(MapCSSTagChecker.class));
        OsmValidator.initializeTests(testsToInitialize);
        Config.getPref().putList("validator.skip", tests);
        Config.getPref().putList("validator.skipBeforeUpload", testsBeforeUpload);
        ValidatorPrefHelper.PREF_USE_IGNORE.put(this.prefUseIgnore.isSelected());
        ValidatorPrefHelper.PREF_OTHER.put(this.prefOther.isSelected());
        ValidatorPrefHelper.PREF_OTHER_UPLOAD.put(this.prefOtherUpload.isSelected());
        ValidatorPrefHelper.PREF_LAYER.put(this.prefUseLayer.isSelected());
        return false;
    }

    @Override
    public boolean isExpert() {
        return false;
    }

    @Override
    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane gui) {
        return gui.getValidatorPreference();
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new ValidatorTestsPreference();
        }
    }
}

