/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.relation.GenericRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.IRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.RelationDialogManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public abstract class RelationEditor
extends ExtendedDialog
implements IRelationEditor {
    private static final long serialVersionUID = 1L;
    public static final String RELATION_PROP = RelationEditor.class.getName() + ".relation";
    public static final String RELATION_SNAPSHOT_PROP = RelationEditor.class.getName() + ".relationSnapshot";
    private transient Relation relation;
    private transient Relation relationSnapshot;
    private final transient OsmDataLayer layer;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);

    protected RelationEditor(OsmDataLayer layer, Relation relation) {
        super((Component)MainApplication.getMainFrame(), "", new String[]{I18n.tr("Apply Changes", new Object[0]), I18n.tr("Cancel", new Object[0])}, false, false);
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        this.layer = layer;
        this.setRelation(relation);
        layer.removeRecentRelation(relation);
    }

    public static RelationEditor getEditor(OsmDataLayer layer, Relation r, Collection<RelationMember> selectedMembers) {
        if (RelationDialogManager.getRelationDialogManager().isOpenInEditor(layer, r)) {
            return RelationDialogManager.getRelationDialogManager().getEditorForRelation(layer, r);
        }
        GenericRelationEditor editor = new GenericRelationEditor(layer, r, selectedMembers);
        RelationDialogManager.getRelationDialogManager().positionOnScreen(editor);
        RelationDialogManager.getRelationDialogManager().register(layer, r, editor);
        return editor;
    }

    protected void updateTitle() {
        if (this.getRelation() == null) {
            this.setTitle(I18n.tr("Create new relation in layer ''{0}''", this.layer.getName()));
        } else if (this.getRelation().isNew()) {
            this.setTitle(I18n.tr("Edit new relation in layer ''{0}''", this.layer.getName()));
        } else {
            this.setTitle(I18n.tr("Edit relation #{0} in layer ''{1}''", this.relation.getId(), this.layer.getName()));
        }
    }

    @Override
    public final Relation getRelation() {
        return this.relation;
    }

    @Override
    public final void setRelation(Relation relation) {
        this.setRelationSnapshot(relation == null ? null : new Relation(relation));
        Relation oldValue = this.relation;
        this.relation = relation;
        if (this.relation != oldValue) {
            this.support.firePropertyChange(RELATION_PROP, oldValue, this.relation);
        }
        this.updateTitle();
    }

    @Override
    public final OsmDataLayer getLayer() {
        return this.layer;
    }

    @Override
    public final Relation getRelationSnapshot() {
        return this.relationSnapshot;
    }

    protected final void setRelationSnapshot(Relation snapshot) {
        Relation oldValue = this.relationSnapshot;
        this.relationSnapshot = snapshot;
        if (this.relationSnapshot != oldValue) {
            this.support.firePropertyChange(RELATION_SNAPSHOT_PROP, oldValue, this.relationSnapshot);
        }
    }

    @Override
    public final boolean isDirtyRelation() {
        return !this.relation.hasEqualSemanticAttributes(this.relationSnapshot);
    }

    @Override
    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public void dispose() {
        this.layer.setRecentRelation(this.relation);
        super.dispose();
    }
}

