/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.autofilter;

import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public class AutoFilterRule {
    private final String key;
    private final int minZoomLevel;
    private UnaryOperator<String> valueFormatter = s -> s;
    private Comparator<String> valueComparator = Comparator.comparingInt(s -> Integer.parseInt((String)this.valueFormatter.apply((String)s)));

    public AutoFilterRule(String key, int minZoomLevel) {
        this.key = key;
        this.minZoomLevel = minZoomLevel;
    }

    public String getKey() {
        return this.key;
    }

    public int getMinZoomLevel() {
        return this.minZoomLevel;
    }

    public Function<String, String> getValueFormatter() {
        return this.valueFormatter;
    }

    public AutoFilterRule setValueFormatter(UnaryOperator<String> valueFormatter) {
        this.valueFormatter = Objects.requireNonNull(valueFormatter);
        return this;
    }

    public Comparator<String> getValueComparator() {
        return this.valueComparator;
    }

    public AutoFilterRule setValueComparator(Comparator<String> valueComparator) {
        this.valueComparator = valueComparator;
        return this;
    }

    public static AutoFilterRule[] defaultRules() {
        return new AutoFilterRule[]{new AutoFilterRule("level", 17), new AutoFilterRule("layer", 16), new AutoFilterRule("maxspeed", 16).setValueFormatter(s -> s.replaceAll(" mph", "")), new AutoFilterRule("voltage", 5).setValueFormatter(s -> s.replaceAll("000$", "k") + 'V').setValueComparator(Comparator.comparingInt(Integer::parseInt))};
    }

    public String toString() {
        return this.key + '[' + this.minZoomLevel + ']';
    }
}

