/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.AbstractProj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Utils;

public class SwissObliqueMercator
extends AbstractProj {
    private Ellipsoid ellps;
    private double kR;
    private double alpha;
    private double b0;
    private double k;
    private double phi0;
    private static final double EPSILON = 1.0E-11;

    @Override
    public void initialize(ProjParameters params) throws ProjectionConfigurationException {
        super.initialize(params);
        if (params.lat0 == null) {
            throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lat_0"));
        }
        this.ellps = params.ellps;
        this.initialize(params.lat0);
    }

    private void initialize(double lat0) {
        this.phi0 = Utils.toRadians(lat0);
        this.kR = Math.sqrt(1.0 - this.ellps.e2) / (1.0 - this.ellps.e2 * Math.pow(Math.sin(this.phi0), 2.0));
        this.alpha = Math.sqrt(1.0 + this.ellps.eb2 * Math.pow(Math.cos(this.phi0), 4.0));
        this.b0 = Math.asin(Math.sin(this.phi0) / this.alpha);
        this.k = Math.log(Math.tan(0.7853981633974483 + this.b0 / 2.0)) - this.alpha * Math.log(Math.tan(0.7853981633974483 + this.phi0 / 2.0)) + this.alpha * this.ellps.e / 2.0 * Math.log((1.0 + this.ellps.e * Math.sin(this.phi0)) / (1.0 - this.ellps.e * Math.sin(this.phi0)));
    }

    @Override
    public String getName() {
        return I18n.tr("Swiss Oblique Mercator", new Object[0]);
    }

    @Override
    public String getProj4Id() {
        return "somerc";
    }

    @Override
    public double[] project(double phi, double lambda) {
        double s = this.alpha * Math.log(Math.tan(0.7853981633974483 + phi / 2.0)) - this.alpha * this.ellps.e / 2.0 * Math.log((1.0 + this.ellps.e * Math.sin(phi)) / (1.0 - this.ellps.e * Math.sin(phi))) + this.k;
        double b = 2.0 * (Math.atan(Math.exp(s)) - 0.7853981633974483);
        double l = this.alpha * lambda;
        double lb = Math.atan2(Math.sin(l), Math.sin(this.b0) * Math.tan(b) + Math.cos(this.b0) * Math.cos(l));
        double bb = Math.asin(Math.cos(this.b0) * Math.sin(b) - Math.sin(this.b0) * Math.cos(b) * Math.cos(l));
        double y = this.kR * lb;
        double x = this.kR / 2.0 * Math.log((1.0 + Math.sin(bb)) / (1.0 - Math.sin(bb)));
        return new double[]{y, x};
    }

    @Override
    public double[] invproject(double y, double x) {
        double lb = y / this.kR;
        double bb = 2.0 * (Math.atan(Math.exp(x / this.kR)) - 0.7853981633974483);
        double b = Math.asin(Math.cos(this.b0) * Math.sin(bb) + Math.sin(this.b0) * Math.cos(bb) * Math.cos(lb));
        double l = Math.atan2(Math.sin(lb), Math.cos(this.b0) * Math.cos(lb) - Math.sin(this.b0) * Math.tan(bb));
        double lambda = l / this.alpha;
        double phi = b;
        double prevPhi = -1000.0;
        int iteration = 0;
        while (Math.abs(phi - prevPhi) > 1.0E-11) {
            if (++iteration > 30) {
                throw new JosmRuntimeException("Too many iterations");
            }
            prevPhi = phi;
            double s = 1.0 / this.alpha * (Math.log(Math.tan(0.7853981633974483 + b / 2.0)) - this.k) + this.ellps.e * Math.log(Math.tan(0.7853981633974483 + Math.asin(this.ellps.e * Math.sin(phi)) / 2.0));
            phi = 2.0 * Math.atan(Math.exp(s)) - 1.5707963267948966;
        }
        return new double[]{phi, lambda};
    }

    @Override
    public Bounds getAlgorithmBounds() {
        if (this.phi0 > 0.0) {
            return new Bounds(-10.0, -40.0, 85.0, 40.0, false);
        }
        return new Bounds(-85.0, -40.0, 10.0, 40.0, false);
    }
}

