/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;

public class RelationToChildReference {
    private final Relation parent;
    private final int position;
    private final String role;
    private final OsmPrimitive child;

    public static Set<RelationToChildReference> getRelationToChildReferences(OsmPrimitive child) {
        Set parents = child.referrers(Relation.class).collect(Collectors.toSet());
        HashSet<RelationToChildReference> references = new HashSet<RelationToChildReference>();
        for (Relation parent : parents) {
            for (int i = 0; i < parent.getMembersCount(); ++i) {
                if (!parent.getMember(i).refersTo(child)) continue;
                references.add(new RelationToChildReference(parent, i, parent.getMember(i)));
            }
        }
        return references;
    }

    public static Set<RelationToChildReference> getRelationToChildReferences(Collection<? extends OsmPrimitive> children) {
        HashSet<RelationToChildReference> references = new HashSet<RelationToChildReference>();
        for (OsmPrimitive osmPrimitive : children) {
            references.addAll(RelationToChildReference.getRelationToChildReferences(osmPrimitive));
        }
        return references;
    }

    public RelationToChildReference(Relation parent, int position, String role, OsmPrimitive child) {
        this.parent = parent;
        this.position = position;
        this.role = role;
        this.child = child;
    }

    public RelationToChildReference(Relation parent, int position, RelationMember member) {
        this(parent, position, member.getRole(), member.getMember());
    }

    public Relation getParent() {
        return this.parent;
    }

    public int getPosition() {
        return this.position;
    }

    public String getRole() {
        return this.role;
    }

    public OsmPrimitive getChild() {
        return this.child;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RelationToChildReference that = (RelationToChildReference)obj;
        return this.position == that.position && Objects.equals(this.parent, that.parent) && Objects.equals(this.role, that.role) && Objects.equals(this.child, that.child);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.position, this.role, this.child);
    }
}

