/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodePair;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.Pair;

public class NodeGraph {
    private final Set<NodePair> edges;
    private int numUndirectedEges;
    private final Map<Node, List<NodePair>> successors = new LinkedHashMap<Node, List<NodePair>>();
    private final Map<Node, List<NodePair>> predecessors = new LinkedHashMap<Node, List<NodePair>>();

    public static List<NodePair> buildNodePairs(Way way, boolean directed) {
        ArrayList<NodePair> pairs = new ArrayList<NodePair>();
        for (Pair<Node, Node> pair : way.getNodePairs(false)) {
            pairs.add(new NodePair(pair));
            if (directed) continue;
            pairs.add(new NodePair(pair).swap());
        }
        return pairs;
    }

    public static List<NodePair> buildNodePairs(List<Way> ways, boolean directed) {
        ArrayList<NodePair> pairs = new ArrayList<NodePair>();
        for (Way w : ways) {
            pairs.addAll(NodeGraph.buildNodePairs(w, directed));
        }
        return pairs;
    }

    public static List<NodePair> eliminateDuplicateNodePairs(List<NodePair> pairs) {
        ArrayList<NodePair> cleaned = new ArrayList<NodePair>();
        for (NodePair p : pairs) {
            if (cleaned.contains(p) || cleaned.contains(p.swap())) continue;
            cleaned.add(p);
        }
        return cleaned;
    }

    public static NodeGraph createDirectedGraphFromNodePairs(List<NodePair> pairs) {
        NodeGraph graph = new NodeGraph();
        for (NodePair pair : pairs) {
            graph.add(pair);
        }
        return graph;
    }

    public static NodeGraph createDirectedGraphFromWays(Collection<Way> ways) {
        NodeGraph graph = new NodeGraph();
        for (Way w : ways) {
            graph.add(NodeGraph.buildNodePairs(w, true));
        }
        return graph;
    }

    public static NodeGraph createUndirectedGraphFromNodeList(List<NodePair> pairs) {
        NodeGraph graph = new NodeGraph();
        for (NodePair pair : pairs) {
            graph.add(pair);
            graph.add(pair.swap());
        }
        return graph;
    }

    public static NodeGraph createUndirectedGraphFromNodeWays(Collection<Way> ways) {
        NodeGraph graph = new NodeGraph();
        for (Way w : ways) {
            graph.add(NodeGraph.buildNodePairs(w, false));
        }
        return graph;
    }

    public static NodeGraph createNearlyUndirectedGraphFromNodeWays(Collection<Way> ways) {
        boolean dir = true;
        NodeGraph graph = new NodeGraph();
        for (Way w : ways) {
            if (!w.isNew()) {
                graph.add(NodeGraph.buildNodePairs(w, dir));
                dir = false;
                continue;
            }
            graph.add(NodeGraph.buildNodePairs(w, false));
        }
        return graph;
    }

    protected void rememberSuccessor(NodePair pair) {
        if (this.successors.containsKey(pair.getA())) {
            if (!this.successors.get(pair.getA()).contains(pair)) {
                this.successors.get(pair.getA()).add(pair);
            }
        } else {
            ArrayList<NodePair> l = new ArrayList<NodePair>();
            l.add(pair);
            this.successors.put(pair.getA(), l);
        }
    }

    protected void rememberPredecessors(NodePair pair) {
        if (this.predecessors.containsKey(pair.getB())) {
            if (!this.predecessors.get(pair.getB()).contains(pair)) {
                this.predecessors.get(pair.getB()).add(pair);
            }
        } else {
            ArrayList<NodePair> l = new ArrayList<NodePair>();
            l.add(pair);
            this.predecessors.put(pair.getB(), l);
        }
    }

    protected boolean isTerminalNode(Node n) {
        if (this.successors.get(n) == null) {
            return false;
        }
        if (this.successors.get(n).size() != 1) {
            return false;
        }
        if (this.predecessors.get(n) == null) {
            return true;
        }
        if (this.predecessors.get(n).size() == 1) {
            NodePair p1 = this.successors.get(n).get(0);
            NodePair p2 = this.predecessors.get(n).get(0);
            return p1.equals(p2.swap());
        }
        return false;
    }

    protected void prepare() {
        LinkedHashSet<NodePair> undirectedEdges = new LinkedHashSet<NodePair>();
        this.successors.clear();
        this.predecessors.clear();
        for (NodePair pair : this.edges) {
            if (!undirectedEdges.contains(pair) && !undirectedEdges.contains(pair.swap())) {
                undirectedEdges.add(pair);
            }
            this.rememberSuccessor(pair);
            this.rememberPredecessors(pair);
        }
        this.numUndirectedEges = undirectedEdges.size();
    }

    public NodeGraph() {
        this.edges = new LinkedHashSet<NodePair>();
    }

    public void add(NodePair pair) {
        if (!this.edges.contains(pair)) {
            this.edges.add(pair);
        }
    }

    public void add(Collection<NodePair> pairs) {
        for (NodePair pair : pairs) {
            this.add(pair);
        }
    }

    protected Set<Node> getTerminalNodes() {
        LinkedHashSet<Node> ret = new LinkedHashSet<Node>();
        for (Node n : this.getNodes()) {
            if (!this.isTerminalNode(n)) continue;
            ret.add(n);
        }
        return ret;
    }

    protected List<NodePair> getOutboundPairs(NodePair pair) {
        return this.getOutboundPairs(pair.getB());
    }

    protected List<NodePair> getOutboundPairs(Node node) {
        return Optional.ofNullable(this.successors.get(node)).orElseGet(Collections::emptyList);
    }

    protected Set<Node> getNodes() {
        LinkedHashSet<Node> nodes = new LinkedHashSet<Node>(2 * this.edges.size());
        for (NodePair pair : this.edges) {
            nodes.add(pair.getA());
            nodes.add(pair.getB());
        }
        return nodes;
    }

    protected boolean isSpanningWay(Stack<NodePair> way) {
        return this.numUndirectedEges == way.size();
    }

    protected List<Node> buildPathFromNodePairs(Stack<NodePair> path) {
        LinkedList<Node> ret = new LinkedList<Node>();
        for (NodePair pair : path) {
            ret.add(pair.getA());
        }
        ret.add(path.peek().getB());
        return ret;
    }

    protected List<Node> buildSpanningPath(Node startNode) {
        if (startNode != null) {
            Stack<NodePair> path = new Stack<NodePair>();
            Stack<NodePair> nextPairs = new Stack<NodePair>();
            nextPairs.addAll(this.getOutboundPairs(startNode));
            while (!nextPairs.isEmpty()) {
                NodePair cur = (NodePair)nextPairs.pop();
                if (path.contains(cur) || path.contains(cur.swap())) continue;
                while (!path.isEmpty() && !((NodePair)path.peek()).isPredecessorOf(cur)) {
                    path.pop();
                }
                path.push(cur);
                if (this.isSpanningWay(path)) {
                    return this.buildPathFromNodePairs(path);
                }
                nextPairs.addAll(this.getOutboundPairs(path.peek()));
            }
        }
        return Collections.emptyList();
    }

    public List<Node> buildSpanningPath() {
        this.prepare();
        Set<Node> nodes = this.getTerminalNodes();
        nodes = nodes.isEmpty() ? this.getNodes() : nodes;
        for (Node n : nodes) {
            List<Node> path = this.buildSpanningPath(n);
            if (path.isEmpty()) continue;
            return path;
        }
        return null;
    }
}

