/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.coor;

import java.io.Serializable;
import java.util.Objects;

abstract class Coordinate
implements Serializable {
    protected final double x;
    protected final double y;

    Coordinate(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    protected final double distance(Coordinate coor) {
        return this.distance(coor.x, coor.y);
    }

    public final double distance(double px, double py) {
        double dx = this.x - px;
        double dy = this.y - py;
        return Math.sqrt(dx * dx + dy * dy);
    }

    protected final double distanceSq(Coordinate coor) {
        return this.distanceSq(coor.x, coor.y);
    }

    public final double distanceSq(double px, double py) {
        double dx = this.x - px;
        double dy = this.y - py;
        return dx * dx + dy * dy;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Coordinate that = (Coordinate)obj;
        return Double.compare(that.x, this.x) == 0 && Double.compare(that.y, this.y) == 0;
    }
}

