/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine;

import org.apache.commons.jcs.engine.PooledCacheEventQueue;
import org.apache.commons.jcs.engine.behavior.ICacheEventQueue;
import org.apache.commons.jcs.engine.behavior.ICacheListener;
import org.apache.commons.jcs.utils.threadpool.PoolConfiguration;
import org.apache.commons.jcs.utils.threadpool.ThreadPoolManager;

public class CacheEventQueue<K, V>
extends PooledCacheEventQueue<K, V> {
    private static final ICacheEventQueue.QueueType queueType = ICacheEventQueue.QueueType.SINGLE;

    public CacheEventQueue(ICacheListener<K, V> listener, long listenerId, String cacheName) {
        this(listener, listenerId, cacheName, 10, 500);
    }

    public CacheEventQueue(ICacheListener<K, V> listener, long listenerId, String cacheName, int maxFailure, int waitBeforeRetry) {
        super(listener, listenerId, cacheName, maxFailure, waitBeforeRetry, null);
    }

    @Override
    protected void initialize(ICacheListener<K, V> listener, long listenerId, String cacheName, int maxFailure, int waitBeforeRetry, String threadPoolName) {
        super.initialize(listener, listenerId, cacheName, maxFailure, waitBeforeRetry);
        this.pool = ThreadPoolManager.getInstance().createPool(new PoolConfiguration(false, 0, 1, 0, this.getWaitToDieMillis(), PoolConfiguration.WhenBlockedPolicy.RUN, 0), "CacheEventQueue.QProcessor-" + this.getCacheName());
    }

    @Override
    public ICacheEventQueue.QueueType getQueueType() {
        return queueType;
    }
}

