/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.admin;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.admin.CacheElementInfo;
import org.apache.commons.jcs.admin.CacheRegionInfo;
import org.apache.commons.jcs.admin.CountingOnlyOutputStream;
import org.apache.commons.jcs.admin.JCSJMXBean;
import org.apache.commons.jcs.auxiliary.remote.server.RemoteCacheServer;
import org.apache.commons.jcs.auxiliary.remote.server.RemoteCacheServerFactory;
import org.apache.commons.jcs.engine.CacheElementSerialized;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.IElementAttributes;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.control.CompositeCacheManager;
import org.apache.commons.jcs.engine.memory.behavior.IMemoryCache;

public class JCSAdminBean
implements JCSJMXBean {
    private final CompositeCacheManager cacheHub;

    public JCSAdminBean() {
        try {
            this.cacheHub = CompositeCacheManager.getInstance();
        }
        catch (CacheException e) {
            throw new RuntimeException("Could not retrieve cache manager instance", e);
        }
    }

    public JCSAdminBean(CompositeCacheManager cacheHub) {
        this.cacheHub = cacheHub;
    }

    @Override
    public CacheElementInfo[] buildElementInfo(String cacheName) throws Exception {
        CompositeCache cache = this.cacheHub.getCache(cacheName);
        Object[] keys = cache.getMemoryCache().getKeySet().toArray(new Serializable[0]);
        try {
            Arrays.sort(keys);
        }
        catch (Exception e) {
            keys = cache.getMemoryCache().getKeySet().toArray(new Serializable[0]);
        }
        LinkedList<CacheElementInfo> records = new LinkedList<CacheElementInfo>();
        DateFormat format = DateFormat.getDateTimeInstance(3, 3);
        long now = System.currentTimeMillis();
        for (Object key : keys) {
            ICacheElement element = cache.getMemoryCache().getQuiet(key);
            IElementAttributes attributes = element.getElementAttributes();
            CacheElementInfo elementInfo = new CacheElementInfo(String.valueOf(key), attributes.getIsEternal(), format.format(new Date(attributes.getCreateTime())), attributes.getMaxLife(), (now - attributes.getCreateTime() - attributes.getMaxLife() * 1000L) / -1000L);
            records.add(elementInfo);
        }
        return records.toArray(new CacheElementInfo[0]);
    }

    @Override
    public CacheRegionInfo[] buildCacheInfo() throws Exception {
        Object[] cacheNames = this.cacheHub.getCacheNames();
        Arrays.sort(cacheNames);
        LinkedList<CacheRegionInfo> cacheInfo = new LinkedList<CacheRegionInfo>();
        for (int i = 0; i < cacheNames.length; ++i) {
            CompositeCache cache = this.cacheHub.getCache((String)cacheNames[i]);
            CacheRegionInfo regionInfo = new CacheRegionInfo(cache.getCacheName(), cache.getSize(), cache.getStatus().toString(), cache.getStats(), cache.getHitCountRam(), cache.getHitCountAux(), cache.getMissCountNotFound(), cache.getMissCountExpired(), this.getByteCount(cache));
            cacheInfo.add(regionInfo);
        }
        return cacheInfo.toArray(new CacheRegionInfo[0]);
    }

    @Override
    public int getByteCount(String cacheName) {
        return this.getByteCount(this.cacheHub.getCache(cacheName));
    }

    public <K, V> int getByteCount(CompositeCache<K, V> cache) {
        if (cache == null) {
            throw new IllegalArgumentException("The cache object specified was null.");
        }
        long size = 0L;
        IMemoryCache<K, V> memCache = cache.getMemoryCache();
        for (K key : memCache.getKeySet()) {
            ICacheElement<K, V> ice = null;
            try {
                ice = memCache.get(key);
            }
            catch (IOException e) {
                throw new RuntimeException("IOException while trying to get a cached element", e);
            }
            if (ice == null) continue;
            if (ice instanceof CacheElementSerialized) {
                size += (long)((CacheElementSerialized)ice).getSerializedValue().length;
                continue;
            }
            V element = ice.getVal();
            CountingOnlyOutputStream counter = new CountingOnlyOutputStream();
            try (ObjectOutputStream out = new ObjectOutputStream(counter);){
                out.writeObject(element);
            }
            catch (IOException e) {
                throw new RuntimeException("IOException while trying to measure the size of the cached element", e);
            }
            finally {
                try {
                    counter.close();
                }
                catch (IOException iOException) {}
            }
            size = size + (long)counter.getCount() - 4L;
        }
        if (size > Integer.MAX_VALUE) {
            throw new IllegalStateException("The size of cache " + cache.getCacheName() + " (" + size + " bytes) is too large to be represented as an integer.");
        }
        return (int)size;
    }

    @Override
    public void clearAllRegions() throws IOException {
        if (RemoteCacheServerFactory.getRemoteCacheServer() == null) {
            String[] names = this.cacheHub.getCacheNames();
            for (int i = 0; i < names.length; ++i) {
                this.cacheHub.getCache(names[i]).removeAll();
            }
        } else {
            try {
                String[] cacheNames = this.cacheHub.getCacheNames();
                RemoteCacheServer remoteCacheServer = RemoteCacheServerFactory.getRemoteCacheServer();
                for (int i = 0; i < cacheNames.length; ++i) {
                    String cacheName = cacheNames[i];
                    remoteCacheServer.removeAll(cacheName);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to remove all elements from all cache regions: " + e, e);
            }
        }
    }

    @Override
    public void clearRegion(String cacheName) throws IOException {
        if (cacheName == null) {
            throw new IllegalArgumentException("The cache name specified was null.");
        }
        if (RemoteCacheServerFactory.getRemoteCacheServer() == null) {
            this.cacheHub.getCache(cacheName).removeAll();
        } else {
            try {
                RemoteCacheServer remoteCacheServer = RemoteCacheServerFactory.getRemoteCacheServer();
                remoteCacheServer.removeAll(cacheName);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to remove all elements from cache region [" + cacheName + "]: " + e, e);
            }
        }
    }

    @Override
    public void removeItem(String cacheName, String key) throws IOException {
        if (cacheName == null) {
            throw new IllegalArgumentException("The cache name specified was null.");
        }
        if (key == null) {
            throw new IllegalArgumentException("The key specified was null.");
        }
        if (RemoteCacheServerFactory.getRemoteCacheServer() == null) {
            this.cacheHub.getCache(cacheName).remove(key);
        } else {
            try {
                Object keyToRemove = null;
                CompositeCache cache = CompositeCacheManager.getInstance().getCache(cacheName);
                Set allKeysInCache = cache.getMemoryCache().getKeySet();
                for (Object keyInCache : allKeysInCache) {
                    if (!keyInCache.toString().equals(key)) continue;
                    if (keyToRemove == null) {
                        keyToRemove = keyInCache;
                        continue;
                    }
                    throw new IllegalStateException("Unexpectedly found duplicate keys in the cache region matching the key specified.");
                }
                if (keyToRemove == null) {
                    throw new IllegalStateException("No match for this key could be found in the set of keys retrieved from the memory cache.");
                }
                RemoteCacheServer remoteCacheServer = RemoteCacheServerFactory.getRemoteCacheServer();
                remoteCacheServer.remove(cacheName, key);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to remove element with key [" + key + ", " + key.getClass() + "] from cache region [" + cacheName + "]: " + e, e);
            }
        }
    }
}

