/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtcp;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.transform.node.TransformerNode;
import org.jitsi.nlj.transform.node.outgoing.OutgoingSsrcStats;
import org.jitsi.nlj.transform.node.outgoing.OutgoingStatisticsTracker;
import org.jitsi.rtp.Packet;
import org.jitsi.rtp.rtcp.RtcpSrPacket;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\fH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/jitsi/nlj/rtcp/RtcpSrUpdater;", "Lorg/jitsi/nlj/transform/node/TransformerNode;", "statsTracker", "Lorg/jitsi/nlj/transform/node/outgoing/OutgoingStatisticsTracker;", "(Lorg/jitsi/nlj/transform/node/outgoing/OutgoingStatisticsTracker;)V", "getStatsTracker", "()Lorg/jitsi/nlj/transform/node/outgoing/OutgoingStatisticsTracker;", "trace", "", "f", "Lkotlin/Function0;", "transform", "Lorg/jitsi/nlj/PacketInfo;", "packetInfo", "jitsi-media-transform"})
public final class RtcpSrUpdater
extends TransformerNode {
    @NotNull
    private final OutgoingStatisticsTracker statsTracker;

    public RtcpSrUpdater(@NotNull OutgoingStatisticsTracker statsTracker) {
        Intrinsics.checkNotNullParameter(statsTracker, "statsTracker");
        super("RtcpSrUpdater");
        this.statsTracker = statsTracker;
    }

    @NotNull
    public final OutgoingStatisticsTracker getStatsTracker() {
        return this.statsTracker;
    }

    @Override
    @Nullable
    protected PacketInfo transform(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        Packet packet = packetInfo.getPacket();
        RtcpSrPacket rtcpSrPacket = packet instanceof RtcpSrPacket ? (RtcpSrPacket)packet : null;
        if (rtcpSrPacket == null) {
            return packetInfo;
        }
        RtcpSrPacket rtcpSrPacket2 = rtcpSrPacket;
        OutgoingSsrcStats.Snapshot snapshot = this.statsTracker.getSsrcSnapshot(rtcpSrPacket2.getSenderSsrc());
        if (snapshot == null) {
            return null;
        }
        OutgoingSsrcStats.Snapshot ssrcStats = snapshot;
        rtcpSrPacket2.getSenderInfo().setSendersOctetCount(ssrcStats.getOctetCount());
        rtcpSrPacket2.getSenderInfo().setSendersPacketCount(ssrcStats.getPacketCount());
        return packetInfo;
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }
}

