/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.ACKBitfield;
import net.i2p.router.transport.udp.InboundMessageFragments;
import net.i2p.router.transport.udp.InboundMessageState;
import net.i2p.router.transport.udp.OutboundMessageState;
import net.i2p.router.transport.udp.PacketBuilder;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.SimpleBandwidthEstimator;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.router.util.CachedIteratorCollection;
import net.i2p.router.util.PriBlockingQueue;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;

public class PeerState {
    protected final RouterContext _context;
    protected final Log _log;
    protected final Hash _remotePeer;
    private final SessionKey _currentMACKey;
    private final SessionKey _currentCipherKey;
    private SessionKey _nextMACKey;
    protected final long _keyEstablishedTime;
    private long _clockSkew;
    private final Object _clockSkewLock = new Object();
    private long _lastSendTime;
    private long _lastSendFullyTime;
    private long _lastPingTime;
    private long _lastReceiveTime;
    private int _consecutiveFailedSends;
    private final Set<Long> _currentACKs;
    private final Queue<ResendACK> _currentACKsResend;
    protected volatile long _lastACKSend;
    protected volatile long _wantACKSendSince;
    private int _sendWindowBytes;
    private int _sendWindowBytesRemaining;
    private final Object _sendWindowBytesRemainingLock = new Object();
    private final SimpleBandwidthEstimator _bwEstimator;
    private int _receiveBps;
    private int _receiveBytes;
    private long _receivePeriodBegin;
    private volatile long _lastCongestionOccurred;
    private volatile int _slowStartThreshold;
    protected final byte[] _remoteIP;
    protected volatile InetAddress _remoteIPAddress;
    protected volatile int _remotePort;
    protected volatile RemoteHostId _remoteHostId;
    private long _weRelayToThemAs;
    private long _theyRelayToUsAs;
    protected int _mtu;
    private int _mtuReceive;
    private int _largeMTU;
    private final int _minMTU;
    private long _consecutiveSmall;
    private int _mtuIncreases;
    private int _mtuDecreases;
    protected int _rtt;
    private int _rttDeviation;
    private int _rto;
    static final long RETRANSMISSION_PERIOD_WIDTH = 100L;
    private int _messagesReceived;
    private int _messagesSent;
    private int _packetsTransmitted;
    private int _packetsRetransmitted;
    private long _nextSequenceNumber;
    private final AtomicBoolean _fastRetransmit = new AtomicBoolean();
    protected int _packetsReceivedDuplicate;
    private int _packetsReceived;
    private boolean _mayDisconnect;
    protected final Map<Long, InboundMessageState> _inboundMessages;
    private final CachedIteratorCollection<OutboundMessageState> _outboundMessages;
    private final PriBlockingQueue<OutboundMessageState> _outboundQueue;
    private final Map<Integer, Long> _ackedMessages;
    private long _retransmitTimer;
    protected final UDPTransport _transport;
    protected volatile boolean _dead;
    private static final int MIN_CONCURRENT_MSGS = 8;
    private static final int INIT_CONCURRENT_MSGS = 20;
    private int _concurrentMessagesAllowed = 20;
    private int _consecutiveRejections;
    protected final boolean _isInbound;
    private long _lastIntroducerTime;
    private static final int MAX_SEND_WINDOW_BYTES = 0x100000;
    private static final int MAX_SEND_MSGS_PENDING = 128;
    public static final int MIN_MTU = 620;
    public static final int MIN_IPV6_MTU = 1280;
    public static final int MAX_IPV6_MTU = 1488;
    private static final int DEFAULT_MTU = 620;
    public static final int LARGE_MTU = 1484;
    public static final int MAX_MTU = Math.max(1484, 1488);
    private static final int MTU_STEP = 64;
    private static final int MIN_RTO = 1000;
    private static final int INIT_RTO = 1000;
    private static final int INIT_RTT = 0;
    private static final int MAX_RTO = 60000;
    protected static final int ACK_FREQUENCY = 150;
    protected static final int CLOCK_SKEW_FUDGE = 100;
    private static final int MAX_RESEND_ACKS = 32;
    private static final int MAX_RESEND_ACKS_LARGE = 21;
    private static final int MAX_RESEND_ACKS_SMALL = 12;
    private static final long RESEND_ACK_TIMEOUT = 60000L;
    private static final int FAST_RTX_ACKS = 3;
    private static final float RTT_DAMPENING = 0.125f;
    private static final int MTU_RCV_DISPLAY_THRESHOLD = 20;
    private static final int OVERHEAD_SIZE = 60;
    private static final int IPV6_OVERHEAD_SIZE = 80;
    private static final int MIN_EXPLICIT_ACKS = 3;
    private static final int MIN_ACK_SIZE = 13;

    public PeerState(RouterContext ctx, UDPTransport transport, byte[] remoteIP, int remotePort, Hash remotePeer, boolean isInbound, int rtt, SessionKey cipherKey, SessionKey macKey) {
        long now;
        this._context = ctx;
        this._log = ctx.logManager().getLog(PeerState.class);
        this._transport = transport;
        this._keyEstablishedTime = now = ctx.clock().now();
        this._lastSendTime = now;
        this._lastReceiveTime = now;
        this._currentACKs = new ConcurrentHashSet<Long>();
        this._currentACKsResend = new LinkedBlockingQueue<ResendACK>();
        this._slowStartThreshold = 524288;
        this._receivePeriodBegin = now;
        this._remotePort = remotePort;
        if (remoteIP.length == 4) {
            this._mtu = 620;
            this._mtuReceive = 620;
            this._largeMTU = transport.getMTU(false);
            this._minMTU = 620;
        } else {
            this._mtu = 1280;
            this._mtuReceive = 1280;
            this._largeMTU = transport.getMTU(true);
            this._minMTU = 1280;
        }
        this._sendWindowBytes = this._mtu > 1095 ? 3 * this._mtu : 4 * this._mtu;
        this._sendWindowBytesRemaining = this._sendWindowBytes;
        this._rto = 1000;
        this._rtt = 0;
        if (rtt > 0) {
            this.recalculateTimeouts(rtt);
        } else {
            this._rttDeviation = this._rtt;
        }
        this._inboundMessages = new HashMap<Long, InboundMessageState>(8);
        this._outboundMessages = new CachedIteratorCollection();
        this._outboundQueue = new PriBlockingQueue(ctx, "UDP-PeerState", 32);
        this._ackedMessages = new AckedMessages();
        this._remoteIP = remoteIP;
        this._remotePeer = remotePeer;
        this._isInbound = isInbound;
        this._remoteHostId = new RemoteHostId(remoteIP, remotePort);
        this._bwEstimator = new SimpleBandwidthEstimator(ctx, this);
        this._currentCipherKey = cipherKey;
        this._currentMACKey = macKey;
    }

    protected PeerState(RouterContext ctx, UDPTransport transport, InetSocketAddress addr, Hash remotePeer, boolean isInbound, int rtt) {
        long now;
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._transport = transport;
        this._keyEstablishedTime = now = ctx.clock().now();
        this._lastSendTime = now;
        this._lastReceiveTime = now;
        this._slowStartThreshold = 524288;
        this._receivePeriodBegin = now;
        this._remoteIP = addr.getAddress().getAddress();
        this._remotePort = addr.getPort();
        this._mtu = 1280;
        this._mtuReceive = 1280;
        this._largeMTU = this._remoteIP.length == 4 ? transport.getSSU2MTU(false) : transport.getSSU2MTU(true);
        this._minMTU = 1280;
        this._sendWindowBytesRemaining = this._sendWindowBytes = 3 * this._mtu;
        this._rto = 1000;
        this._rtt = 0;
        if (rtt > 0) {
            this.recalculateTimeouts(rtt);
        } else {
            this._rttDeviation = this._rtt;
        }
        this._inboundMessages = new HashMap<Long, InboundMessageState>(8);
        this._outboundMessages = new CachedIteratorCollection();
        this._outboundQueue = new PriBlockingQueue(ctx, "UDP-PeerState", 32);
        this._remotePeer = remotePeer;
        this._isInbound = isInbound;
        this._remoteHostId = new RemoteHostId(this._remoteIP, this._remotePort);
        this._bwEstimator = new SimpleBandwidthEstimator(ctx, this);
        this._currentACKs = null;
        this._currentACKsResend = null;
        this._ackedMessages = null;
        this._currentCipherKey = null;
        this._currentMACKey = null;
    }

    public int getVersion() {
        return 1;
    }

    void changePort(int newPort) {
        if (newPort != this._remotePort) {
            this._remoteHostId = new RemoteHostId(this._remoteIP, newPort);
            this._remotePort = newPort;
        }
    }

    public Hash getRemotePeer() {
        return this._remotePeer;
    }

    SessionKey getCurrentMACKey() {
        return this._currentMACKey;
    }

    SessionKey getCurrentCipherKey() {
        return this._currentCipherKey;
    }

    SessionKey getNextMACKey() {
        return this._nextMACKey;
    }

    SessionKey getNextCipherKey() {
        return null;
    }

    public long getKeyEstablishedTime() {
        return this._keyEstablishedTime;
    }

    public long getClockSkew() {
        return this._clockSkew;
    }

    public long getLastSendTime() {
        return this._lastSendTime;
    }

    public long getLastSendFullyTime() {
        return this._lastSendFullyTime;
    }

    public long getLastReceiveTime() {
        return this._lastReceiveTime;
    }

    public int getConsecutiveFailedSends() {
        return this._consecutiveFailedSends;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSendWindowBytes() {
        CachedIteratorCollection<OutboundMessageState> cachedIteratorCollection = this._outboundMessages;
        synchronized (cachedIteratorCollection) {
            return this._sendWindowBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSendWindowBytesRemaining() {
        Object object = this._sendWindowBytesRemainingLock;
        synchronized (object) {
            return this._sendWindowBytesRemaining;
        }
    }

    public byte[] getRemoteIP() {
        return this._remoteIP;
    }

    public InetAddress getRemoteIPAddress() {
        block3: {
            if (this._remoteIPAddress == null) {
                try {
                    this._remoteIPAddress = InetAddress.getByAddress(this._remoteIP);
                }
                catch (UnknownHostException uhe) {
                    if (!this._log.shouldLog(40)) break block3;
                    this._log.error("Invalid IP? ", uhe);
                }
            }
        }
        return this._remoteIPAddress;
    }

    public int getRemotePort() {
        return this._remotePort;
    }

    public long getWeRelayToThemAs() {
        return this._weRelayToThemAs;
    }

    public long getTheyRelayToUsAs() {
        return this._theyRelayToUsAs;
    }

    public int getMTU() {
        return this._mtu;
    }

    public int getReceiveMTU() {
        return this._mtuReceive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void adjustClockSkew(long skew) {
        long actualSkew = skew + 100L - (long)(this._rtt / 2);
        if (this._packetsReceived <= 1) {
            Object object = this._clockSkewLock;
            synchronized (object) {
                this._clockSkew = actualSkew;
            }
            return;
        }
        double adj = 0.1 * (double)actualSkew;
        Object object = this._clockSkewLock;
        synchronized (object) {
            this._clockSkew = (long)(0.9 * (double)this._clockSkew + adj);
        }
    }

    void setLastSendTime(long when) {
        this._lastSendTime = when;
    }

    void setLastReceiveTime(long when) {
        this._lastReceiveTime = when;
    }

    void setLastPingTime(long when) {
        this._lastPingTime = when;
    }

    long getLastSendOrPingTime() {
        return Math.max(Math.max(this._lastSendTime, this._lastACKSend), this._lastPingTime);
    }

    public int getSendBps(long now) {
        return (int)(this._bwEstimator.getBandwidthEstimate(now) * 1000.0f);
    }

    public synchronized int getReceiveBps(long now) {
        long duration = now - this._receivePeriodBegin;
        if (duration >= 1000L) {
            this._receiveBps = (int)(0.9f * (float)this._receiveBps + 0.1f * ((float)this._receiveBytes * (1000.0f / (float)duration)));
            this._receiveBytes = 0;
            this._receivePeriodBegin = now;
        }
        return this._receiveBps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int incrementConsecutiveFailedSends() {
        CachedIteratorCollection<OutboundMessageState> cachedIteratorCollection = this._outboundMessages;
        synchronized (cachedIteratorCollection) {
            ++this._consecutiveFailedSends;
            return this._consecutiveFailedSends;
        }
    }

    public long getInactivityTime() {
        long now = this._context.clock().now();
        long lastActivity = Math.max(this._lastReceiveTime, this._lastSendFullyTime);
        return now - lastActivity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean allocateSendingBytes(OutboundMessageState state, long now) {
        int messagePushCount = state.getPushCount();
        if (messagePushCount == 0 && this._outboundMessages.size() > this._concurrentMessagesAllowed) {
            ++this._consecutiveRejections;
            this._context.statManager().addRateData("udp.rejectConcurrentActive", this._outboundMessages.size(), this._consecutiveRejections);
            return false;
        }
        int sendRemaining = this.getSendWindowBytesRemaining();
        if (sendRemaining <= this.fragmentOverhead()) {
            return false;
        }
        int size = state.getSendSize(sendRemaining);
        if (size > 0) {
            if (messagePushCount == 0) {
                this._context.statManager().addRateData("udp.allowConcurrentActive", this._outboundMessages.size(), this._concurrentMessagesAllowed);
                if (this._consecutiveRejections > 0) {
                    this._context.statManager().addRateData("udp.rejectConcurrentSequence", this._consecutiveRejections, this._outboundMessages.size());
                }
                this._consecutiveRejections = 0;
            }
            Object object = this._sendWindowBytesRemainingLock;
            synchronized (object) {
                this._sendWindowBytesRemaining -= size;
            }
            this._lastSendTime = now;
            return true;
        }
        return false;
    }

    void setWeRelayToThemAs(long tag) {
        this._weRelayToThemAs = tag;
    }

    void setTheyRelayToUsAs(long tag) {
        this._theyRelayToUsAs = tag;
    }

    public int getSlowStartThreshold() {
        return this._slowStartThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConcurrentSends() {
        CachedIteratorCollection<OutboundMessageState> cachedIteratorCollection = this._outboundMessages;
        synchronized (cachedIteratorCollection) {
            return this._outboundMessages.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConcurrentSendWindow() {
        CachedIteratorCollection<OutboundMessageState> cachedIteratorCollection = this._outboundMessages;
        synchronized (cachedIteratorCollection) {
            return this._concurrentMessagesAllowed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConsecutiveSendRejections() {
        CachedIteratorCollection<OutboundMessageState> cachedIteratorCollection = this._outboundMessages;
        synchronized (cachedIteratorCollection) {
            return this._consecutiveRejections;
        }
    }

    public boolean isInbound() {
        return this._isInbound;
    }

    public boolean isIPv6() {
        return this._remoteIP.length == 16;
    }

    long getIntroducerTime() {
        return this._lastIntroducerTime;
    }

    void setIntroducerTime() {
        this._lastIntroducerTime = this._context.clock().now();
    }

    synchronized void messageFullyReceived(Long messageId, int bytes) {
        if (bytes > 0) {
            this._receiveBytes += bytes;
            ++this._messagesReceived;
        } else {
            ++this._packetsReceivedDuplicate;
        }
        long now = this._context.clock().now();
        long duration = now - this._receivePeriodBegin;
        if (duration >= 1000L) {
            this._receiveBps = (int)(0.9f * (float)this._receiveBps + 0.1f * ((float)this._receiveBytes * (1000.0f / (float)duration)));
            this._receiveBytes = 0;
            this._receivePeriodBegin = now;
        }
        if (this._currentACKs != null) {
            this._currentACKs.add(messageId);
        }
        this.messagePartiallyReceived(now);
    }

    void messagePartiallyReceived() {
        this.messagePartiallyReceived(this._context.clock().now());
    }

    protected synchronized void messagePartiallyReceived(long now) {
        if (this._wantACKSendSince <= 0L) {
            this._wantACKSendSince = now;
            new ACKTimer();
        }
    }

    Map<Long, InboundMessageState> getInboundMessages() {
        return this._inboundMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int expireInboundMessages() {
        int rv = 0;
        Map<Long, InboundMessageState> map = this._inboundMessages;
        synchronized (map) {
            Iterator<InboundMessageState> iter = this._inboundMessages.values().iterator();
            while (iter.hasNext()) {
                InboundMessageState state = iter.next();
                if (state.isExpired() || this._dead) {
                    iter.remove();
                    continue;
                }
                if (state.isComplete()) {
                    this._log.error("inbound message is complete, but wasn't handled inline? " + state + " with " + this);
                    iter.remove();
                    continue;
                }
                ++rv;
            }
        }
        return rv;
    }

    private void congestionOccurred() {
        float bwe;
        long now = this._context.clock().now();
        if (this._lastCongestionOccurred + (long)this._rto > now) {
            return;
        }
        this._lastCongestionOccurred = now;
        int congestionAt = this._sendWindowBytes;
        int oldsst = this._slowStartThreshold;
        if (this._fastRetransmit.get()) {
            bwe = -1.0f;
        } else {
            this._sendWindowBytes = this.getVersion() == 2 ? 1500 : (this.isIPv6() ? 1488 : 1484);
            bwe = this._bwEstimator.getBandwidthEstimate(now);
            this._slowStartThreshold = Math.max((int)(bwe * (float)this._rtt), 2 * this._mtu);
        }
        int oldRto = this._rto;
        long oldTimer = this._retransmitTimer - now;
        this._rto = Math.min(60000, Math.max(1000, this._rto << 1));
        this._retransmitTimer = now + (long)this._rto;
        if (this._log.shouldInfo()) {
            this._log.info(this._remotePeer + " Congestion, RTO: " + oldRto + " -> " + this._rto + " timer: " + oldTimer + " -> " + this._rto + " window: " + congestionAt + " -> " + this._sendWindowBytes + " SST: " + oldsst + " -> " + this._slowStartThreshold + " FRTX? " + this._fastRetransmit + " BWE: " + DataHelper.formatSize2Decimal((long)(bwe * 1000.0f), false) + "bps");
        }
    }

    List<Long> getCurrentFullACKs() {
        ArrayList<Long> rv = new ArrayList<Long>(this._currentACKs);
        return rv;
    }

    List<Long> getCurrentResendACKs() {
        int sz = this._currentACKsResend.size();
        ArrayList<Long> randomResends = new ArrayList<Long>(sz);
        if (sz > 0) {
            long cutoff = this._context.clock().now() - 60000L;
            int i = 0;
            Iterator iter = this._currentACKsResend.iterator();
            while (iter.hasNext()) {
                ResendACK rack = (ResendACK)iter.next();
                if (rack.time > cutoff && i++ < 32) {
                    randomResends.add(rack.id);
                    continue;
                }
                iter.remove();
                if (!this._log.shouldDebug()) continue;
                this._log.debug("Expired ack " + rack.id + " sent " + (cutoff + 60000L - rack.time) + " ago, now " + this._currentACKsResend.size() + " resend acks");
            }
            if (i > 1) {
                Collections.shuffle(randomResends, this._context.random());
            }
        }
        return randomResends;
    }

    void removeACKMessage(Long messageId) {
        boolean removed = this._currentACKs.remove(messageId);
        if (removed) {
            this._currentACKsResend.offer(new ResendACK(messageId, this._context.clock().now()));
            if (this._log.shouldDebug()) {
                this._log.debug("Sent ack " + messageId + " now " + this._currentACKs.size() + " current and " + this._currentACKsResend.size() + " resend acks");
            }
        }
        this._lastACKSend = this._context.clock().now();
    }

    private List<ACKBitfield> retrieveACKBitfields(boolean alwaysIncludeRetransmissions) {
        int bytesRemaining;
        int resendSize = this._currentACKsResend.size();
        int maxResendAcks = bytesRemaining < 620 ? 12 : 21;
        ArrayList<ACKBitfield> rv = new ArrayList<ACKBitfield>(maxResendAcks);
        ArrayList<Long> currentACKsRemoved = new ArrayList<Long>(this._currentACKs.size());
        Iterator<Long> iter = this._currentACKs.iterator();
        for (bytesRemaining = this.countMaxACKData(); bytesRemaining >= 4 && iter.hasNext(); bytesRemaining -= 4) {
            Long val = iter.next();
            iter.remove();
            long id = val;
            rv.add(new FullACKBitfield(id));
            currentACKsRemoved.add(val);
        }
        if (this._currentACKs.isEmpty()) {
            this._wantACKSendSince = 0L;
        }
        if (alwaysIncludeRetransmissions || !rv.isEmpty()) {
            List<Long> randomResends = this.getCurrentResendACKs();
            int oldIndex = Math.min(resendSize, maxResendAcks);
            iter = randomResends.iterator();
            while (bytesRemaining >= 4 && oldIndex-- > 0 && iter.hasNext()) {
                Long cur = iter.next();
                long c = cur;
                FullACKBitfield bf = new FullACKBitfield(c);
                rv.add(bf);
                bytesRemaining -= 4;
            }
            if (!currentACKsRemoved.isEmpty()) {
                long now = this._context.clock().now();
                for (Long val : currentACKsRemoved) {
                    this._currentACKsResend.offer(new ResendACK(val, now));
                }
            }
        }
        int partialIncluded = 0;
        if (bytesRemaining > 4) {
            ArrayList<ACKBitfield> partial = new ArrayList<ACKBitfield>();
            this.fetchPartialACKs(partial);
            for (int i = 0; bytesRemaining > 4 && i < partial.size(); ++i) {
                ACKBitfield bitfield = (ACKBitfield)partial.get(i);
                int bytes = bitfield.fragmentCount() / 7 + 1;
                if (bytesRemaining <= bytes + 4) continue;
                rv.add(bitfield);
                bytesRemaining -= bytes + 4;
                ++partialIncluded;
            }
        }
        if (!rv.isEmpty()) {
            this._lastACKSend = this._context.clock().now();
        }
        if (partialIncluded > 0) {
            this._context.statManager().addRateData("udp.sendACKPartial", partialIncluded, rv.size() - partialIncluded);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fetchPartialACKs(List<ACKBitfield> rv) {
        ArrayList<InboundMessageState> states = null;
        boolean curState = false;
        Map<Long, InboundMessageState> map = this._inboundMessages;
        synchronized (map) {
            int numMessages = this._inboundMessages.size();
            if (numMessages <= 0) {
                return;
            }
            Iterator<InboundMessageState> iter = this._inboundMessages.values().iterator();
            while (iter.hasNext()) {
                InboundMessageState state = iter.next();
                if (state.isExpired()) {
                    iter.remove();
                    continue;
                }
                if (state.isComplete()) continue;
                if (states == null) {
                    states = new ArrayList<InboundMessageState>(numMessages);
                }
                states.add(state);
            }
        }
        if (states != null) {
            for (InboundMessageState ims : states) {
                ACKBitfield abf = ims.createACKBitfield();
                rv.add(abf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void locked_messageACKed(int bytesACKed, int maxPktSz, long lifetime, int numSends, boolean anyPending, boolean anyQueued) {
        long now;
        Object object;
        this._consecutiveFailedSends = 0;
        if (numSends < 2) {
            if (this._context.random().nextInt(this._concurrentMessagesAllowed) <= 0) {
                ++this._concurrentMessagesAllowed;
            }
            if (this._sendWindowBytes <= this._slowStartThreshold) {
                this._sendWindowBytes += bytesACKed;
                Object object2 = this._sendWindowBytesRemainingLock;
                synchronized (object2) {
                    this._sendWindowBytesRemaining += bytesACKed;
                }
            } else {
                float prob = (float)bytesACKed / (float)(this._sendWindowBytes << 1);
                float v = this._context.random().nextFloat();
                if (v < 0.0f) {
                    v = 0.0f - v;
                }
                if (v <= prob) {
                    this._sendWindowBytes += bytesACKed;
                    object = this._sendWindowBytesRemainingLock;
                    synchronized (object) {
                        this._sendWindowBytesRemaining += bytesACKed;
                    }
                }
            }
        } else {
            int allow = this._concurrentMessagesAllowed - 1;
            if (allow < 8) {
                allow = 8;
            }
            this._concurrentMessagesAllowed = allow;
        }
        if (this._sendWindowBytes > 0x100000) {
            this._sendWindowBytes = 0x100000;
        }
        this._lastSendFullyTime = this._lastReceiveTime = (now = this._context.clock().now());
        object = this._sendWindowBytesRemainingLock;
        synchronized (object) {
            this._sendWindowBytesRemaining += bytesACKed;
            if (this._sendWindowBytesRemaining > this._sendWindowBytes) {
                this._sendWindowBytesRemaining = this._sendWindowBytes;
            }
        }
        if (numSends < 2) {
            this.recalculateTimeouts(lifetime);
            this.adjustMTU(maxPktSz, true);
        }
        if (!anyPending) {
            this._retransmitTimer = 0L;
            this.exitFastRetransmit();
        } else {
            long oldTimer = this._retransmitTimer - now;
            this._retransmitTimer = now + (long)this.getRTO();
            if (this._log.shouldLog(10)) {
                this._log.debug(this._remotePeer + " ACK, timer: " + oldTimer + " -> " + (this._retransmitTimer - now));
            }
        }
        if (anyPending || anyQueued) {
            this._transport.getOMF().nudge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void messageACKed(int bytesACKed, int maxPktSz, long lifetime, int numSends, boolean anyPending, boolean anyQueued) {
        PeerState peerState = this;
        synchronized (peerState) {
            this.locked_messageACKed(bytesACKed, maxPktSz, lifetime, numSends, anyPending, anyQueued);
        }
        this._bwEstimator.addSample(bytesACKed);
        if (numSends >= 2 && this._log.shouldDebug()) {
            this._log.debug(this._remotePeer + " acked after numSends=" + numSends + " w/ lifetime=" + lifetime + " and size=" + bytesACKed);
        }
    }

    private void recalculateTimeouts(long lifetime) {
        if (this._rtt <= 0) {
            this._rtt = (int)lifetime;
            this._rttDeviation = this._rtt / 2;
        } else {
            this._rttDeviation = (int)(0.75 * (double)this._rttDeviation + 0.25 * (double)Math.abs(lifetime - (long)this._rtt));
            this._rtt = (int)((float)this._rtt * 0.875f + 0.125f * (float)lifetime);
        }
        this._rto = Math.min(60000, Math.max(1000, this._rtt + (this._rttDeviation << 2)));
    }

    private void adjustMTU(int maxPktSz, boolean success) {
        if (this._packetsTransmitted > 0) {
            boolean wantLarge;
            boolean bl = wantLarge = success && (float)this._packetsRetransmitted / (float)this._packetsTransmitted < 0.1f;
            if (wantLarge) {
                if (this._mtu < this._largeMTU && maxPktSz > this._mtu - 128 && (this._mtuDecreases <= 1 || this._context.random().nextInt(this._mtuDecreases) <= 0)) {
                    this._mtu = Math.min(this._mtu + 64, this._largeMTU);
                    ++this._mtuIncreases;
                    this._mtuDecreases = 0;
                    this._context.statManager().addRateData("udp.mtuIncrease", this._mtuIncreases);
                    if (this._log.shouldDebug()) {
                        this._log.debug("Increased MTU after " + maxPktSz + " byte packet acked on " + this);
                    }
                }
            } else if (this._mtu > this._minMTU && maxPktSz > this._mtu - 256) {
                this._mtu = Math.max(this._mtu - 64, this._minMTU);
                ++this._mtuDecreases;
                this._mtuIncreases = 0;
                this._context.statManager().addRateData("udp.mtuDecrease", this._mtuDecreases);
                if (this._log.shouldDebug()) {
                    this._log.debug("Decreased MTU after " + maxPktSz + " byte packet retx on " + this);
                }
            }
        }
    }

    synchronized void setHisMTU(int mtu) {
        if (mtu <= this._minMTU || mtu >= this._largeMTU) {
            return;
        }
        if (mtu < this._largeMTU) {
            this._largeMTU = mtu;
        }
        if (mtu < this._mtu) {
            this._mtu = mtu;
        }
    }

    synchronized void messageRetransmitted(int packets, int maxPktSz) {
        this._context.statManager().addRateData("udp.congestionOccurred", this._sendWindowBytes);
        this._context.statManager().addRateData("udp.congestedRTO", this._rto, this._rttDeviation);
        this._packetsRetransmitted += packets;
        this.congestionOccurred();
        this.adjustMTU(maxPktSz, false);
    }

    synchronized void packetsTransmitted(int packets) {
        this._packetsTransmitted += packets;
    }

    public synchronized int getRTT() {
        return this._rtt;
    }

    public synchronized int getRTO() {
        return this._rto;
    }

    public synchronized int getRTTDeviation() {
        return this._rttDeviation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessagesSent() {
        CachedIteratorCollection<OutboundMessageState> cachedIteratorCollection = this._outboundMessages;
        synchronized (cachedIteratorCollection) {
            return this._messagesSent;
        }
    }

    public synchronized int getMessagesReceived() {
        return this._messagesReceived;
    }

    public synchronized int getPacketsTransmitted() {
        return this._packetsTransmitted;
    }

    public synchronized int getPacketsRetransmitted() {
        return this._packetsRetransmitted;
    }

    public synchronized int getPacketsReceived() {
        return this._packetsReceived;
    }

    public synchronized int getPacketsReceivedDuplicate() {
        return this._packetsReceivedDuplicate;
    }

    synchronized void packetReceived(int size) {
        ++this._packetsReceived;
        size = this._remoteIP.length == 4 ? (size += 60) : (size += 80);
        if (size <= this._minMTU) {
            ++this._consecutiveSmall;
            if (this._consecutiveSmall >= 20L) {
                this._mtuReceive = this._minMTU;
            }
        } else {
            this._consecutiveSmall = 0L;
            if (size > this._mtuReceive) {
                this._mtuReceive = size;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ECNReceived() {
        PeerState peerState = this;
        synchronized (peerState) {
            this.congestionOccurred();
        }
        this._context.statManager().addRateData("udp.congestionOccurred", this._sendWindowBytes);
    }

    void dataReceived() {
        this._lastReceiveTime = this._context.clock().now();
    }

    public long getLastACKSend() {
        return this._lastACKSend;
    }

    synchronized void clearWantedACKSendSince() {
        if (this._currentACKs.isEmpty()) {
            this._wantACKSendSince = 0L;
        }
    }

    boolean unsentACKThresholdReached() {
        return this._currentACKs.size() >= 16;
    }

    private int countMaxACKData() {
        return Math.min(1020, this._mtu - (this._remoteIP.length == 4 ? 20 : 40) - 8 - 16 - 16 - 1 - 4 - 1 - 1 - 16);
    }

    public RemoteHostId getRemoteHostId() {
        return this._remoteHostId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(OutboundMessageState state) {
        boolean fail;
        if (this._dead) {
            this._transport.failed(state, false);
            return;
        }
        if (state.getPeer() != this) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Not for me!", new Exception("I did it"));
            }
            this._transport.failed(state, false);
            return;
        }
        boolean rv = false;
        PriBlockingQueue<OutboundMessageState> priBlockingQueue = this._outboundQueue;
        synchronized (priBlockingQueue) {
            fail = !this._outboundQueue.offer(state);
            state.setSeqNum(this._nextSequenceNumber++);
        }
        if (fail) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Dropping msg, OB queue full for " + this.toString());
            }
            this._transport.failed(state, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropOutbound() {
        ArrayList<OutboundMessageState> tempList;
        this._dead = true;
        Object object = this._outboundMessages;
        synchronized (object) {
            tempList = new ArrayList<OutboundMessageState>(this._outboundMessages);
            this._outboundMessages.clear();
        }
        object = this._outboundQueue;
        synchronized (object) {
            this._outboundQueue.drainTo(tempList);
        }
        for (OutboundMessageState oms : tempList) {
            this._transport.failed(oms, false);
        }
        this._wantACKSendSince = 0L;
    }

    public int getOutboundMessageCount() {
        if (this._dead) {
            return 0;
        }
        return this._outboundMessages.size() + this._outboundQueue.size();
    }

    public void setMayDisconnect() {
        this._mayDisconnect = true;
    }

    public boolean getMayDisconnect() {
        return this._mayDisconnect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int finishMessages(long now) {
        if (this._outboundMessages.isEmpty()) {
            return this._outboundQueue.size();
        }
        if (this._dead) {
            this.dropOutbound();
            return 0;
        }
        int rv = 0;
        ArrayList<OutboundMessageState> succeeded = null;
        ArrayList<OutboundMessageState> failed = null;
        CachedIteratorCollection<OutboundMessageState> cachedIteratorCollection = this._outboundMessages;
        synchronized (cachedIteratorCollection) {
            Iterator<OutboundMessageState> iter = this._outboundMessages.iterator();
            while (iter.hasNext()) {
                OutboundMessageState state = iter.next();
                if (state.isComplete()) {
                    iter.remove();
                    if (succeeded == null) {
                        succeeded = new ArrayList<OutboundMessageState>(4);
                    }
                    succeeded.add(state);
                    continue;
                }
                if (state.isExpired(now)) {
                    iter.remove();
                    this._context.statManager().addRateData("udp.sendFailed", state.getPushCount());
                    if (failed == null) {
                        failed = new ArrayList<OutboundMessageState>(4);
                    }
                    failed.add(state);
                    continue;
                }
                if (state.getMaxSends() <= 10) continue;
                iter.remove();
                this._context.statManager().addRateData("udp.sendAggressiveFailed", state.getPushCount());
                if (failed == null) {
                    failed = new ArrayList(4);
                }
                failed.add(state);
            }
            rv = this._outboundMessages.size();
        }
        for (int i = 0; succeeded != null && i < succeeded.size(); ++i) {
            OutboundMessageState state = (OutboundMessageState)succeeded.get(i);
            this._transport.succeeded(state);
            OutNetMessage msg = state.getMessage();
            if (msg == null) continue;
            msg.timestamp("sending complete");
        }
        if (failed != null) {
            int failedSize = 0;
            int failedCount = 0;
            boolean totalFail = false;
            for (int i = 0; i < failed.size(); ++i) {
                OutboundMessageState state = (OutboundMessageState)failed.get(i);
                failedSize += state.getUnackedSize();
                failedCount += state.getUnackedFragments();
                OutNetMessage msg = state.getMessage();
                if (msg != null) {
                    msg.timestamp("expired in the active pool");
                    this._transport.failed(state);
                    if (this._log.shouldWarn()) {
                        this._log.warn("Message expired: " + state + " to: " + this);
                    }
                    if (this._isInbound || state.getSeqNum() != 0L) continue;
                    totalFail = true;
                    continue;
                }
                if (!this._log.shouldLog(30)) continue;
                this._log.warn("Unable to send a direct message: " + state + " to: " + this);
            }
            if (failedSize > 0) {
                if (totalFail) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("First message failed on " + this);
                    }
                    this._transport.sendDestroy(this, 14);
                    this._transport.dropPeer(this, true, "OB First Message Fail");
                    return 0;
                }
                Object object = this._sendWindowBytesRemainingLock;
                synchronized (object) {
                    this._sendWindowBytesRemaining += failedSize;
                    this._sendWindowBytesRemaining += failedCount * this.fragmentOverhead();
                    if (this._sendWindowBytesRemaining > this._sendWindowBytes) {
                        this._sendWindowBytesRemaining = this._sendWindowBytes;
                    }
                }
            }
            if (rv <= 0) {
                PeerState peerState = this;
                synchronized (peerState) {
                    this._retransmitTimer = 0L;
                    this.exitFastRetransmit();
                }
            }
        }
        return rv + this._outboundQueue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<OutboundMessageState> allocateSend(long now) {
        long retransmitTimer;
        PeerState peerState = this;
        synchronized (peerState) {
            retransmitTimer = this._retransmitTimer;
        }
        boolean canSendOld = retransmitTimer > 0L && now >= retransmitTimer;
        List<OutboundMessageState> rv = this.allocateSend2(canSendOld, now);
        if (rv != null && !rv.isEmpty()) {
            PeerState peerState2 = this;
            synchronized (peerState2) {
                long old = this._retransmitTimer;
                if (this._retransmitTimer == 0L) {
                    this._retransmitTimer = now + (long)this.getRTO();
                } else if (this._fastRetransmit.get()) {
                    this._retransmitTimer = now + (long)this.getRTO();
                }
            }
        }
        if (canSendOld) {
            boolean isEmpty;
            Object object = this._outboundMessages;
            synchronized (object) {
                isEmpty = this._outboundMessages.isEmpty();
            }
            object = this;
            synchronized (object) {
                if (isEmpty) {
                    this._retransmitTimer = 0L;
                    this.exitFastRetransmit();
                } else {
                    this._retransmitTimer = now + 250L;
                }
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OutboundMessageState> allocateSend2(boolean canSendOld, long now) {
        if (this._dead) {
            return null;
        }
        ArrayList<OutboundMessageState> rv = null;
        CachedIteratorCollection<OutboundMessageState> cachedIteratorCollection = this._outboundMessages;
        synchronized (cachedIteratorCollection) {
            if (canSendOld) {
                for (OutboundMessageState state : this._outboundMessages) {
                    if (this._fastRetransmit.get()) {
                        if (state.getNACKs() < 3) continue;
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Allocate sending (FAST) to " + this._remotePeer + ": " + state);
                        }
                    } else if (this._log.shouldLog(10)) {
                        this._log.debug("Allocate sending (OLD) to " + this._remotePeer + ": " + state.getMessageId());
                    }
                    if (rv == null) {
                        rv = new ArrayList<OutboundMessageState>((1 + this._outboundMessages.size()) / 2);
                        this._lastSendTime = now;
                    }
                    rv.add(state);
                    if (rv.size() < this._outboundMessages.size() / 2 || this._fastRetransmit.get()) continue;
                    return rv;
                }
                return rv;
            }
            if (!this._outboundMessages.isEmpty()) {
                for (OutboundMessageState state : this._outboundMessages) {
                    if (!state.hasUnsentFragments()) continue;
                    boolean should = this.locked_shouldSend(state, now);
                    if (should) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Allocate sending more fragments to " + this._remotePeer + ": " + state.getMessageId());
                        }
                        if (rv == null) {
                            rv = new ArrayList(this._concurrentMessagesAllowed);
                        }
                        rv.add(state);
                        continue;
                    }
                    if (this._log.shouldLog(10)) {
                        if (rv == null) {
                            this._log.debug("Nothing to send (BW) to " + this._remotePeer + ", with " + this._outboundMessages.size() + " / " + this._outboundQueue.size() + " remaining");
                        } else {
                            this._log.debug(this._remotePeer + " ran out of BW, but managed to send " + rv.size());
                        }
                    }
                    return rv;
                }
            }
            PriBlockingQueue<OutboundMessageState> priBlockingQueue = this._outboundQueue;
            synchronized (priBlockingQueue) {
                OutboundMessageState state;
                while ((state = (OutboundMessageState)this._outboundQueue.peek()) != null && this.locked_shouldSend(state, now)) {
                    OutboundMessageState dequeuedState = (OutboundMessageState)this._outboundQueue.poll();
                    if (dequeuedState == null) continue;
                    this._outboundMessages.add(dequeuedState);
                    if (rv == null) {
                        rv = new ArrayList(this._concurrentMessagesAllowed);
                    }
                    rv.add(dequeuedState);
                    if (rv.size() < this._concurrentMessagesAllowed) continue;
                    return rv;
                }
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNextDelay(long now) {
        int rv = Integer.MAX_VALUE;
        if (this._dead) {
            return rv;
        }
        PeerState peerState = this;
        synchronized (peerState) {
            if (this._retransmitTimer > 0L) {
                rv = Math.max(0, (int)(this._retransmitTimer - now));
            }
        }
        return rv;
    }

    public boolean isBacklogged() {
        return this._dead || this._outboundQueue.isBacklogged();
    }

    int fragmentSize() {
        return this._mtu - (this._remoteIP.length == 4 ? 74 : 94) - 13;
    }

    int fragmentOverhead() {
        return (this._remoteIP.length == 4 ? 74 : 94) + 13;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean locked_shouldSend(OutboundMessageState state, long now) {
        PeerState peerState = this;
        synchronized (peerState) {
            if (this.allocateSendingBytes(state, now)) {
                if (state.getPushCount() == 0) {
                    ++this._messagesSent;
                }
                return true;
            }
            this._context.statManager().addRateData("udp.sendRejected", state.getPushCount());
            if (this._log.shouldLog(20)) {
                this._log.info(this._remotePeer + " Allocation rejected w/ wsize=" + this.getSendWindowBytes() + " available=" + this.getSendWindowBytesRemaining() + " for message " + state.getMessageId() + ": " + state);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean acked(long messageId, InboundMessageFragments.ModifiableLong highestSeqNumAcked) {
        boolean anyPending;
        if (this._dead) {
            return false;
        }
        OutboundMessageState state = null;
        CachedIteratorCollection<OutboundMessageState> cachedIteratorCollection = this._outboundMessages;
        synchronized (cachedIteratorCollection) {
            Iterator<OutboundMessageState> iter = this._outboundMessages.iterator();
            while (iter.hasNext()) {
                state = iter.next();
                if (state.getMessageId() == messageId) {
                    iter.remove();
                    break;
                }
                if (state.getPushCount() <= 0) {
                    state = null;
                    break;
                }
                state = null;
            }
            anyPending = !this._outboundMessages.isEmpty();
        }
        if (state != null) {
            boolean anyQueued;
            int numSends = state.getMaxSends();
            long lifetime = state.getLifetime();
            if (this._log.shouldDebug()) {
                this._log.debug("Received ack of " + messageId + " by " + this._remotePeer + " after " + lifetime + " and " + numSends + " sends");
            }
            this._context.statManager().addRateData("udp.sendConfirmTime", lifetime);
            if (state.getFragmentCount() > 1) {
                this._context.statManager().addRateData("udp.sendConfirmFragments", state.getFragmentCount());
            }
            this._context.statManager().addRateData("udp.sendConfirmVolley", numSends);
            this._transport.succeeded(state);
            if (anyPending) {
                anyQueued = false;
            } else {
                PriBlockingQueue<OutboundMessageState> priBlockingQueue = this._outboundQueue;
                synchronized (priBlockingQueue) {
                    anyQueued = !this._outboundQueue.isEmpty();
                }
            }
            long sn = state.getSeqNum();
            if (sn > highestSeqNumAcked.value) {
                highestSeqNumAcked.value = sn;
            }
            Map<Integer, Long> map = this._ackedMessages;
            synchronized (map) {
                this._ackedMessages.put((int)messageId, sn);
            }
            int maxPktSz = state.fragmentSize(0) + (this.isIPv6() ? 94 : 74);
            this.messageACKed(state.getUnackedSize(), maxPktSz, lifetime, numSends, anyPending, anyQueued);
        } else {
            long sn;
            Long seq;
            Map<Integer, Long> lifetime = this._ackedMessages;
            synchronized (lifetime) {
                seq = this._ackedMessages.get((int)messageId);
            }
            if (seq != null && (sn = seq.longValue()) > highestSeqNumAcked.value) {
                highestSeqNumAcked.value = sn;
            }
        }
        return state != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean acked(ACKBitfield bitfield, InboundMessageFragments.ModifiableLong highestSeqNumAcked) {
        long sn;
        Long seq;
        boolean anyPending;
        if (this._dead) {
            return false;
        }
        long messageId = bitfield.getMessageId();
        if (bitfield.receivedComplete()) {
            return this.acked(messageId, highestSeqNumAcked);
        }
        OutboundMessageState state = null;
        boolean isComplete = false;
        int ackedSize = 0;
        CachedIteratorCollection<OutboundMessageState> cachedIteratorCollection = this._outboundMessages;
        synchronized (cachedIteratorCollection) {
            Iterator<OutboundMessageState> iter = this._outboundMessages.iterator();
            while (iter.hasNext()) {
                state = iter.next();
                if (state.getMessageId() == messageId) {
                    ackedSize = state.getUnackedSize();
                    boolean complete = state.acked(bitfield);
                    if (complete) {
                        isComplete = true;
                        iter.remove();
                        break;
                    }
                    ackedSize -= state.getUnackedSize();
                    break;
                }
                if (state.getPushCount() <= 0) {
                    state = null;
                    break;
                }
                state = null;
            }
            anyPending = !this._outboundMessages.isEmpty();
        }
        if (state != null) {
            long sn2;
            int numSends = state.getMaxSends();
            int numACKed = bitfield.ackCount();
            this._context.statManager().addRateData("udp.partialACKReceived", numACKed);
            long lifetime = state.getLifetime();
            if (isComplete) {
                this._context.statManager().addRateData("udp.sendConfirmTime", lifetime);
                if (state.getFragmentCount() > 1) {
                    this._context.statManager().addRateData("udp.sendConfirmFragments", state.getFragmentCount());
                }
                this._context.statManager().addRateData("udp.sendConfirmVolley", numSends);
                this._transport.succeeded(state);
                if (this._log.shouldDebug()) {
                    this._log.debug("Received partial ack of " + messageId + " by " + this._remotePeer + " newly-acked: " + ackedSize + ", now complete for: " + state);
                }
            } else if (this._log.shouldDebug()) {
                this._log.debug("Received partial ack of " + messageId + " by " + this._remotePeer + " after " + lifetime + " and " + numSends + " sends complete? false newly-acked: " + ackedSize + ' ' + bitfield + " for: " + state);
            }
            if (ackedSize > 0) {
                boolean anyQueued;
                state.clearNACKs();
                if (anyPending) {
                    anyQueued = false;
                } else {
                    PriBlockingQueue<OutboundMessageState> priBlockingQueue = this._outboundQueue;
                    synchronized (priBlockingQueue) {
                        anyQueued = !this._outboundQueue.isEmpty();
                    }
                }
                this.messageACKed(ackedSize, 0, lifetime, numSends, anyPending, anyQueued);
            }
            if ((sn2 = state.getSeqNum()) > highestSeqNumAcked.value) {
                highestSeqNumAcked.value = sn2;
            }
            if (isComplete) {
                Map<Integer, Long> map = this._ackedMessages;
                synchronized (map) {
                    this._ackedMessages.put((int)messageId, sn2);
                }
            }
            return ackedSize > 0;
        }
        Map<Integer, Long> numACKed = this._ackedMessages;
        synchronized (numACKed) {
            seq = this._ackedMessages.get((int)messageId);
        }
        if (seq != null && (sn = seq.longValue()) > highestSeqNumAcked.value) {
            highestSeqNumAcked.value = sn;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Received an ACK for a message not pending: " + bitfield);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean acked(PacketBuilder.Fragment f) {
        boolean anyQueued;
        boolean anyPending;
        Object iter;
        boolean isComplete;
        int ackedSize;
        OutboundMessageState state;
        if (this._dead) {
            return false;
        }
        OutboundMessageState outboundMessageState = state = f.state;
        synchronized (outboundMessageState) {
            ackedSize = state.getUnackedSize();
            if (ackedSize <= 0) {
                return false;
            }
            isComplete = state.acked(f.num);
            if (!isComplete) {
                ackedSize -= state.getUnackedSize();
            }
        }
        if (ackedSize <= 0) {
            return false;
        }
        CachedIteratorCollection<OutboundMessageState> cachedIteratorCollection = this._outboundMessages;
        synchronized (cachedIteratorCollection) {
            if (isComplete) {
                long sn = state.getSeqNum();
                boolean found = false;
                iter = this._outboundMessages.iterator();
                while (iter.hasNext()) {
                    OutboundMessageState state2 = iter.next();
                    if (state == state2) {
                        iter.remove();
                        found = true;
                        break;
                    }
                    if (state2.getSeqNum() <= sn) continue;
                    break;
                }
                if (!found) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Acked but not found in outbound messages: " + state);
                    }
                    return false;
                }
            }
            anyPending = !this._outboundMessages.isEmpty();
        }
        int numSends = state.getMaxSends();
        this._context.statManager().addRateData("udp.partialACKReceived", 1L);
        long lifetime = state.getLifetime();
        if (isComplete) {
            this._context.statManager().addRateData("udp.sendConfirmTime", lifetime);
            if (state.getFragmentCount() > 1) {
                this._context.statManager().addRateData("udp.sendConfirmFragments", state.getFragmentCount());
            }
            this._context.statManager().addRateData("udp.sendConfirmVolley", numSends);
            this._transport.succeeded(state);
            if (this._log.shouldDebug()) {
                if (state.getFragmentCount() > 1) {
                    this._log.debug("Received partial ack of " + state.getMessageId() + " by " + this._remotePeer + " newly-acked: " + ackedSize + ", now complete for: " + state);
                } else {
                    this._log.debug("Received ack of " + state.getMessageId() + " by " + this._remotePeer + " after " + lifetime + " and " + numSends + " sends");
                }
            }
        } else if (this._log.shouldDebug()) {
            this._log.debug("Received partial ack of " + state.getMessageId() + " by " + this._remotePeer + " after " + lifetime + " and " + numSends + " sends complete? false newly-acked: " + ackedSize + " fragment: " + f.num + " for: " + state);
        }
        state.clearNACKs();
        if (anyPending) {
            anyQueued = false;
        } else {
            iter = this._outboundQueue;
            synchronized (iter) {
                anyQueued = !this._outboundQueue.isEmpty();
            }
        }
        int maxPktSz = state.fragmentSize(0) + 3 + (this.isIPv6() ? 80 : 60);
        this.messageACKed(ackedSize, maxPktSz, lifetime, numSends, anyPending, anyQueued);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean highestSeqNumAcked(long highest) {
        boolean rv = false;
        boolean startFast = false;
        boolean continueFast = false;
        Object object = this._outboundMessages;
        synchronized (object) {
            OutboundMessageState state;
            long sn;
            Object iter = this._outboundMessages.iterator();
            while (iter.hasNext() && (sn = (state = iter.next()).getSeqNum()) < highest) {
                if (sn >= highest) continue;
                int nacks = state.incrementNACKs();
                if (nacks == 3) {
                    startFast = true;
                    rv = true;
                } else if (nacks > 3) {
                    continueFast = true;
                    rv = true;
                }
                if (!this._log.shouldDebug()) continue;
                this._log.debug("Message NACKed: " + state);
            }
            if (rv) {
                this._fastRetransmit.set(true);
                if (continueFast) {
                    this._sendWindowBytes += this._mtu;
                    iter = this._sendWindowBytesRemainingLock;
                    synchronized (iter) {
                        this._sendWindowBytesRemaining += this._mtu;
                    }
                    if (this._log.shouldDebug()) {
                        this._log.debug("Continue FAST RTX, inflated window: " + this);
                    }
                } else if (startFast) {
                    float bwe = this._bwEstimator.getBandwidthEstimate();
                    this._slowStartThreshold = Math.max((int)(bwe * (float)this._rtt), 2 * this._mtu);
                    this._sendWindowBytes = this._slowStartThreshold + 3 * this._mtu;
                    Object object2 = this._sendWindowBytesRemainingLock;
                    synchronized (object2) {
                        this._sendWindowBytesRemaining = this._sendWindowBytes;
                    }
                    if (this._log.shouldDebug()) {
                        this._log.debug("Start of FAST RTX, inflated window: " + this);
                    }
                }
            } else {
                this.exitFastRetransmit();
            }
        }
        if (rv) {
            object = this;
            synchronized (object) {
                this._retransmitTimer = this._context.clock().now();
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exitFastRetransmit() {
        if (this._fastRetransmit.compareAndSet(true, false)) {
            PeerState peerState = this;
            synchronized (peerState) {
                this._sendWindowBytes = this._slowStartThreshold;
                Object object = this._sendWindowBytesRemainingLock;
                synchronized (object) {
                    this._sendWindowBytesRemaining = this._sendWindowBytes;
                }
            }
            if (this._log.shouldDebug()) {
                this._log.debug("End of FAST RTX, deflated window: " + this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean shouldRequestImmediateAck() {
        Object object = this._sendWindowBytesRemainingLock;
        synchronized (object) {
            return this._sendWindowBytesRemaining < this._sendWindowBytes / 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFrom(PeerState oldPeer) {
        Map<Long, InboundMessageState> tmp3;
        this._rto = oldPeer._rto;
        this._rtt = oldPeer._rtt;
        this._rttDeviation = oldPeer._rttDeviation;
        this._slowStartThreshold = oldPeer._slowStartThreshold;
        this._sendWindowBytes = oldPeer._sendWindowBytes;
        oldPeer._dead = true;
        if (this.getVersion() == 1 && oldPeer.getVersion() == 1) {
            ArrayList<Long> tmp = new ArrayList<Long>();
            for (Long l : oldPeer._currentACKs) {
                tmp.add(l);
            }
            oldPeer._currentACKs.clear();
            if (!this._dead) {
                this._currentACKs.addAll(tmp);
            }
            tmp3 = new ArrayList();
            tmp3.addAll(oldPeer._currentACKsResend);
            oldPeer._currentACKsResend.clear();
            if (!this._dead) {
                this._currentACKsResend.addAll((Collection<ResendACK>)((Object)tmp3));
            }
        }
        if (this.getVersion() == oldPeer.getVersion()) {
            HashMap<Long, InboundMessageState> msgs = new HashMap<Long, InboundMessageState>();
            tmp3 = oldPeer._inboundMessages;
            synchronized (tmp3) {
                msgs.putAll(oldPeer._inboundMessages);
                oldPeer._inboundMessages.clear();
            }
            if (!this._dead) {
                tmp3 = this._inboundMessages;
                synchronized (tmp3) {
                    this._inboundMessages.putAll(msgs);
                }
            }
            msgs.clear();
            ArrayList<OutboundMessageState> tmp2 = new ArrayList<OutboundMessageState>();
            Object retransmitter = null;
            CachedIteratorCollection<OutboundMessageState> cachedIteratorCollection = oldPeer._outboundMessages;
            synchronized (cachedIteratorCollection) {
                tmp2.addAll(oldPeer._outboundMessages);
                oldPeer._outboundMessages.clear();
            }
            if (!this._dead) {
                cachedIteratorCollection = this._outboundMessages;
                synchronized (cachedIteratorCollection) {
                    this._outboundMessages.addAll(tmp2);
                }
            }
        }
    }

    UDPTransport getTransport() {
        return this._transport;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append(this._remoteHostId.toString());
        buf.append(' ').append(this._remotePeer.toBase64(), 0, 6);
        if (this.getVersion() == 2) {
            buf.append(this._isInbound ? " IB2 " : " OB2 ");
        } else {
            buf.append(this._isInbound ? " IB " : " OB ");
        }
        long now = this._context.clock().now();
        buf.append(" recvAge: ").append(DataHelper.formatDuration(now - this._lastReceiveTime));
        buf.append(" sendAge: ").append(DataHelper.formatDuration(now - this._lastSendFullyTime));
        buf.append(" sendAttemptAge: ").append(DataHelper.formatDuration(now - this._lastSendTime));
        buf.append(" sendACKAge: ").append(DataHelper.formatDuration(now - this._lastACKSend));
        buf.append(" lifetime: ").append(DataHelper.formatDuration(now - this._keyEstablishedTime));
        buf.append(" RTT: ").append(this._rtt);
        buf.append(" RTTdev: ").append(this._rttDeviation);
        buf.append(" RTO: ").append(this._rto);
        buf.append(" MTU: ").append(this._mtu);
        buf.append(" LMTU: ").append(this._largeMTU);
        buf.append(" cwin: ").append(this._sendWindowBytes);
        buf.append(" acwin: ").append(this._sendWindowBytesRemaining);
        buf.append(" SST: ").append(this._slowStartThreshold);
        buf.append(" FRTX? ").append(this._fastRetransmit);
        buf.append(" consecFail: ").append(this._consecutiveFailedSends);
        buf.append(" msgs rcvd: ").append(this._messagesReceived);
        buf.append(" msgs sent: ").append(this._messagesSent);
        buf.append(" pkts rcvd OK/Dup: ").append(this._packetsReceived).append('/').append(this._packetsReceivedDuplicate);
        buf.append(" pkts sent OK/Dup: ").append(this._packetsTransmitted).append('/').append(this._packetsRetransmitted);
        buf.append(" IBM: ").append(this._inboundMessages.size());
        buf.append(" OBQ: ").append(this._outboundQueue.size());
        buf.append(" OBL: ").append(this._outboundMessages.size());
        if (this._weRelayToThemAs > 0L) {
            buf.append(" weRelayToThemAs: ").append(this._weRelayToThemAs);
        }
        if (this._theyRelayToUsAs > 0L) {
            buf.append(" theyRelayToUsAs: ").append(this._theyRelayToUsAs);
        }
        return buf.toString();
    }

    private class ACKTimer
    extends SimpleTimer2.TimedEvent {
        public ACKTimer() {
            super(PeerState.this._context.simpleTimer2());
            long delta = Math.max(10, Math.min(PeerState.this._rtt / 6, 150));
            if (PeerState.this._log.shouldDebug()) {
                PeerState.this._log.debug("Sending delayed ack in " + delta + ": " + PeerState.this);
            }
            this.schedule(delta);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void timeReached() {
            PeerState peerState = PeerState.this;
            synchronized (peerState) {
                long wanted = PeerState.this._wantACKSendSince;
                if (wanted <= 0L) {
                    if (PeerState.this._log.shouldDebug()) {
                        PeerState.this._log.debug("Already acked:" + PeerState.this);
                    }
                    return;
                }
                List ackBitfields = PeerState.this.retrieveACKBitfields(false);
                if (!ackBitfields.isEmpty()) {
                    UDPPacket ack = PeerState.this._transport.getBuilder().buildACK(PeerState.this, ackBitfields);
                    ack.markType(1);
                    ack.setFragmentCount(-1);
                    ack.setMessageType(42);
                    if (PeerState.this._log.shouldDebug()) {
                        PeerState.this._log.debug("Sending " + ackBitfields.size() + " acks to " + PeerState.this);
                    }
                    PeerState.this._transport.send(ack);
                    if (PeerState.this._wantACKSendSince > 0L) {
                        if (PeerState.this._log.shouldInfo()) {
                            PeerState.this._log.info("Requeueing more ACKs for " + PeerState.this);
                        }
                        this.reschedule(25L);
                    }
                } else if (PeerState.this._log.shouldDebug()) {
                    PeerState.this._log.debug("No more acks:" + PeerState.this);
                }
            }
        }
    }

    private static class AckedMessages
    extends LinkedHashMap<Integer, Long> {
        private AckedMessages() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, Long> eldest) {
            return this.size() > 128;
        }
    }

    private static class ResendACK {
        public final Long id;
        public final long time;

        public ResendACK(Long id, long time) {
            this.id = id;
            this.time = time;
        }
    }

    private static class FullACKBitfield
    implements ACKBitfield {
        private final long _msgId;

        public FullACKBitfield(long id) {
            this._msgId = id;
        }

        @Override
        public int fragmentCount() {
            return 1;
        }

        @Override
        public int ackCount() {
            return 1;
        }

        @Override
        public int highestReceived() {
            return 0;
        }

        @Override
        public long getMessageId() {
            return this._msgId;
        }

        @Override
        public boolean received(int fragmentNum) {
            return true;
        }

        @Override
        public boolean receivedComplete() {
            return true;
        }

        public int hashCode() {
            return (int)this._msgId;
        }

        public boolean equals(Object o) {
            if (!(o instanceof FullACKBitfield)) {
                return false;
            }
            return this._msgId == ((ACKBitfield)o).getMessageId();
        }

        public String toString() {
            return "Full ACK " + this._msgId;
        }
    }
}

