/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.blockdevicelib;

import com.amazon.aes.webservices.client.blockdevicelib.ImageVerificationException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class DiskImage {
    public abstract long size();

    public abstract byte[] read(long var1, int var3) throws ImageVerificationException;

    public ByteBuffer readAsBuffer(long offset, int length) throws ImageVerificationException {
        return ByteBuffer.wrap(this.read(offset, length));
    }

    public ByteBuffer readLittleEndian(long offset, int length) throws ImageVerificationException {
        return this.readAsBuffer(offset, length).order(ByteOrder.LITTLE_ENDIAN);
    }

    public static int getUnsignedByte(byte unsignedByte) {
        return unsignedByte & 0xFF;
    }

    public static long getUnsignedInt(int signedInt) {
        return (long)signedInt & 0xFFFFFFFFL;
    }

    public static boolean rangesOverlap(long srcStartOffset, int srcLength, long dstStartOffset, int dstLength) {
        long srcEndOffset = srcStartOffset + (long)srcLength;
        long dstEndOffset = dstStartOffset + (long)dstLength;
        return srcStartOffset < dstEndOffset && dstStartOffset < srcEndOffset;
    }

    public static int copyBytes(byte[] srcData, long srcOffsetInDisk, int srcSize, byte[] dstData, long dstOffsetInDisk) {
        if (DiskImage.rangesOverlap(srcOffsetInDisk, srcSize, dstOffsetInDisk, dstData.length)) {
            int srcArrayOffset = (int)Math.max(0L, dstOffsetInDisk - srcOffsetInDisk);
            int dstArrayOffset = (int)Math.max(0L, srcOffsetInDisk - dstOffsetInDisk);
            int copyLength = Math.min(dstData.length - dstArrayOffset, srcSize - srcArrayOffset);
            System.arraycopy(srcData, srcArrayOffset, dstData, dstArrayOffset, copyLength);
            return copyLength;
        }
        return 0;
    }
}

